/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.TestData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestTasksProvider;
import org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleData;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public abstract class GradleTestRunConfigurationProducer
extends RunConfigurationProducer<GradleRunConfiguration> {
    protected static final Logger LOG = Logger.getInstance(GradleTestRunConfigurationProducer.class);
    private TestTasksChooser testTasksChooser = new TestTasksChooser();

    protected GradleTestRunConfigurationProducer() {
        super(true);
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return GradleExternalTaskConfigurationType.getInstance().getFactory();
    }

    public boolean isPreferredConfiguration(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return GradleTestRunConfigurationProducer.isUsedTestRunners(self.getConfiguration(), TestRunner.CHOOSE_PER_TEST, TestRunner.GRADLE);
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return GradleTestRunConfigurationProducer.isUsedTestRunners(self.getConfiguration(), TestRunner.GRADLE);
    }

    public boolean setupConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        if (sourceElement.isNull()) {
            return false;
        }
        if (GradleTestRunConfigurationProducer.isUsedTestRunners(context, TestRunner.PLATFORM)) {
            return false;
        }
        configuration.setScriptDebugEnabled(false);
        boolean result = this.doSetupConfigurationFromContext(configuration, context, sourceElement);
        this.restoreDefaultScriptParametersIfNeeded((RunConfiguration)configuration, context);
        return result;
    }

    protected abstract boolean doSetupConfigurationFromContext(@NotNull GradleRunConfiguration var1, @NotNull ConfigurationContext var2, @NotNull Ref<PsiElement> var3);

    public boolean isConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context) {
        ProjectSystemId externalSystemId = configuration.getSettings().getExternalSystemId();
        return GradleConstants.SYSTEM_ID.equals((Object)externalSystemId) && GradleTestRunConfigurationProducer.isUsedTestRunners(configuration, TestRunner.CHOOSE_PER_TEST, TestRunner.GRADLE) && this.doIsConfigurationFromContext(configuration, context);
    }

    protected abstract boolean doIsConfigurationFromContext(@NotNull GradleRunConfiguration var1, @NotNull ConfigurationContext var2);

    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        this.restoreDefaultScriptParametersIfNeeded(configuration.getConfiguration(), context);
        startRunnable.run();
    }

    protected void restoreDefaultScriptParametersIfNeeded(@NotNull RunConfiguration configuration, @NotNull ConfigurationContext context) {
        RunnerAndConfigurationSettings template = context.getRunManager().getConfigurationTemplate(this.getConfigurationFactory());
        RunConfiguration original = template.getConfiguration();
        if (original instanceof ExternalSystemRunConfiguration && configuration instanceof ExternalSystemRunConfiguration) {
            ExternalSystemRunConfiguration originalRC = (ExternalSystemRunConfiguration)original;
            ExternalSystemRunConfiguration configurationRC = (ExternalSystemRunConfiguration)configuration;
            String currentParams = configurationRC.getSettings().getScriptParameters();
            String defaultParams = originalRC.getSettings().getScriptParameters();
            if (!StringUtil.isEmptyOrSpaces((String)defaultParams)) {
                if (!StringUtil.isEmptyOrSpaces((String)currentParams)) {
                    configurationRC.getSettings().setScriptParameters(currentParams + " " + defaultParams);
                } else {
                    configurationRC.getSettings().setScriptParameters(defaultParams);
                }
            }
        }
    }

    @Nullable
    protected static String resolveProjectPath(@NotNull Module module) {
        GradleModuleData gradleModuleData = CachedModuleDataFinder.getGradleModuleData((Module)module);
        if (gradleModuleData == null) {
            return null;
        }
        boolean isGradleProjectDirUsedToRunTasks = gradleModuleData.getDirectoryToRunTask().equals(gradleModuleData.getGradleProjectDir());
        if (!isGradleProjectDirUsedToRunTasks) {
            return gradleModuleData.getDirectoryToRunTask();
        }
        return GradleRunnerUtil.resolveProjectPath(module);
    }

    protected TestTasksChooser getTestTasksChooser() {
        return this.testTasksChooser;
    }

    @TestOnly
    public void setTestTasksChooser(TestTasksChooser testTasksChooser) {
        this.testTasksChooser = testTasksChooser;
    }

    @NotNull
    public static TasksToRun findTestsTaskToRun(@NotNull VirtualFile source, @NotNull Project project) {
        List<TasksToRun> tasksToRun = GradleTestRunConfigurationProducer.findAllTestsTaskToRun(source, project);
        if (tasksToRun.isEmpty()) {
            return TasksToRun.EMPTY;
        }
        return tasksToRun.get(0);
    }

    @NotNull
    public static List<TasksToRun> findAllTestsTaskToRun(@NotNull VirtualFile source, @NotNull Project project) {
        String sourcePath = source.getPath();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Module module = (Module)ReadAction.compute(() -> projectFileIndex.getModuleForFile(source));
        if (module == null) {
            return Collections.emptyList();
        }
        ArrayList<TasksToRun> testTasks = new ArrayList<TasksToRun>();
        for (GradleTestTasksProvider provider : (GradleTestTasksProvider[])GradleTestTasksProvider.EP_NAME.getExtensions()) {
            List<String> tasks = provider.getTasks(module, source);
            if (ContainerUtil.isEmpty(tasks)) continue;
            String testName = StringUtil.join(tasks, (String)" ");
            testTasks.add(new TasksToRun.Impl(testName, tasks));
        }
        GradleModuleData gradleModuleData = CachedModuleDataFinder.getGradleModuleData((Module)module);
        if (gradleModuleData == null) {
            return testTasks;
        }
        for (TestData testData : gradleModuleData.findAll(ProjectKeys.TEST)) {
            Set sourceFolders = testData.getSourceFolders();
            for (String sourceFolder : sourceFolders) {
                if (!FileUtil.isAncestor((String)sourceFolder, (String)sourcePath, (boolean)false)) continue;
                String testTaskSimpleName = testData.getTestName();
                SmartList tasks = new SmartList((Object)gradleModuleData.getTaskPath(testTaskSimpleName, true));
                testTasks.add(new TasksToRun.Impl(testTaskSimpleName, (List<String>)tasks));
            }
        }
        return testTasks;
    }

    private static boolean isUsedTestRunners(@NotNull RunConfiguration configuration, TestRunner ... runners) {
        return configuration instanceof GradleRunConfiguration && GradleTestRunConfigurationProducer.isUsedTestRunners((GradleRunConfiguration)configuration, runners);
    }

    private static boolean isUsedTestRunners(@NotNull GradleRunConfiguration configuration, TestRunner ... runners) {
        Project project = configuration.getProject();
        String externalProjectPath = configuration.getSettings().getExternalProjectPath();
        return GradleTestRunConfigurationProducer.isUsedTestRunners(project, externalProjectPath, runners);
    }

    private static boolean isUsedTestRunners(@NotNull ConfigurationContext context, TestRunner ... runners) {
        Project project = context.getProject();
        Module module = context.getModule();
        return project != null && module != null && GradleTestRunConfigurationProducer.isUsedTestRunners(project, GradleTestRunConfigurationProducer.resolveProjectPath(module), runners);
    }

    private static boolean isUsedTestRunners(@NotNull Project project, @Nullable String externalProjectPath, TestRunner ... runners) {
        TestRunner testRunner = GradleProjectSettings.getTestRunner((Project)project, (String)externalProjectPath);
        return ContainerUtil.exists((Object[])runners, it -> it.equals((Object)testRunner));
    }

    protected static void setUniqueNameIfNeeded(@NotNull Project project, @NotNull GradleRunConfiguration configuration) {
        RunManager runManager = RunManager.getInstance((Project)project);
        runManager.setUniqueNameIfNeeded((RunConfiguration)configuration);
    }
}

