/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.testframework.AbstractJavaTestConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.AbstractGradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.AllInDirectoryGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestGradleConfigurationProducerUtilKt;
import org.jetbrains.plugins.gradle.util.GradleExecutionSettingsUtil;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public class AllInPackageGradleConfigurationProducer
extends AbstractGradleTestRunConfigurationProducer<PsiPackage, PsiPackage> {
    @Override
    public boolean isPreferredConfiguration(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return other.isProducedBy(AllInDirectoryGradleConfigurationProducer.class) || super.isPreferredConfiguration(self, other);
    }

    @Override
    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return other.isProducedBy(AllInDirectoryGradleConfigurationProducer.class) || super.shouldReplace(self, other);
    }

    @Override
    @Nullable
    protected PsiPackage getElement(@NotNull ConfigurationContext context) {
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        PsiElement psiLocation = context.getPsiLocation();
        if (psiLocation == null) {
            return null;
        }
        PsiElement sourceElement = AllInPackageGradleConfigurationProducer.getSourceElement(module, psiLocation);
        if (sourceElement == null) {
            return null;
        }
        VirtualFile source = TestGradleConfigurationProducerUtilKt.getSourceFile(sourceElement);
        if (source == null) {
            return null;
        }
        return AllInPackageGradleConfigurationProducer.extractPackage(psiLocation);
    }

    @Override
    @NotNull
    protected String getLocationName(@NotNull ConfigurationContext context, @NotNull PsiPackage element) {
        return String.format("'%s'", element.getName());
    }

    @Override
    @NotNull
    protected String suggestConfigurationName(@NotNull ConfigurationContext context, @NotNull PsiPackage element, @NotNull List<? extends PsiPackage> chosenElements) {
        return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{element.getQualifiedName()});
    }

    @Override
    protected void chooseSourceElements(@NotNull ConfigurationContext context, @NotNull PsiPackage element, @NotNull Consumer<List<PsiPackage>> onElementsChosen) {
        onElementsChosen.accept(Collections.emptyList());
    }

    @Override
    @NotNull
    protected List<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> getAllTestsTaskToRun(@NotNull ConfigurationContext context, @NotNull PsiPackage element, @NotNull List<? extends PsiPackage> chosenElements) {
        Project project = Objects.requireNonNull(context.getProject());
        Module module = Objects.requireNonNull(context.getModule());
        PsiElement psiLocation = Objects.requireNonNull(context.getPsiLocation());
        PsiElement sourceElement = Objects.requireNonNull(AllInPackageGradleConfigurationProducer.getSourceElement(module, psiLocation));
        VirtualFile source = Objects.requireNonNull(TestGradleConfigurationProducerUtilKt.getSourceFile(sourceElement));
        List<TasksToRun> allTasksToRuns = AllInPackageGradleConfigurationProducer.findAllTestsTaskToRun(source, project);
        String testFilter = GradleExecutionSettingsUtil.createTestFilterFrom(element);
        return ContainerUtil.map(allTasksToRuns, it -> new AbstractGradleTestRunConfigurationProducer.TestTasksToRun((TasksToRun)it, testFilter));
    }

    @Nullable
    protected static PsiElement getSourceElement(@NotNull Module module, @NotNull PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            return element;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null) {
            return element;
        }
        if (element instanceof PsiPackage) {
            return AllInPackageGradleConfigurationProducer.getPackageDirectory(module, (PsiPackage)element);
        }
        return null;
    }

    @Nullable
    private static PsiDirectory getPackageDirectory(@NotNull Module module, @NotNull PsiPackage element) {
        PsiDirectory[] sourceDirs = element.getDirectories(GlobalSearchScope.moduleScope((Module)module));
        if (sourceDirs.length == 0) {
            return null;
        }
        return sourceDirs[0];
    }

    @Nullable
    private static PsiPackage extractPackage(@NotNull PsiElement location) {
        PsiPackage psiPackage = AbstractJavaTestConfigurationProducer.checkPackage((PsiElement)location);
        if (psiPackage == null) {
            return null;
        }
        if (psiPackage.getQualifiedName().isEmpty()) {
            return null;
        }
        return psiPackage;
    }
}

