/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.execution.Location;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.psi.search.ExternalModuleBuildGlobalSearchScope;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import icons.GradleIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.groovy.extensions.GroovyRunnableScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;

public final class GradleScriptType
extends GroovyRunnableScriptType {
    public static final GradleScriptType INSTANCE = new GradleScriptType();

    private GradleScriptType() {
        super("gradle");
    }

    @NotNull
    public Icon getScriptIcon() {
        return GradleIcons.GradleFile;
    }

    public boolean isConfigurationByLocation(@NotNull GroovyScriptRunConfiguration existing, @NotNull Location location) {
        return false;
    }

    public GlobalSearchScope patchResolveScope(@NotNull GroovyFile file, @NotNull GlobalSearchScope baseScope) {
        if (!FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
            return baseScope;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return this.patchResolveScopeInner(module, baseScope);
    }

    public GlobalSearchScope patchResolveScopeInner(@Nullable Module module, @NotNull GlobalSearchScope baseScope) {
        if (module == null) {
            return GlobalSearchScope.EMPTY_SCOPE;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return baseScope;
        }
        GlobalSearchScope result = GlobalSearchScope.EMPTY_SCOPE;
        Project project = module.getProject();
        GlobalSearchScope[] jdkScopes = (GlobalSearchScope[])Arrays.stream(ModuleRootManager.getInstance((Module)module).getOrderEntries()).filter(entry -> entry instanceof JdkOrderEntry).map(entry -> LibraryScopeCache.getInstance((Project)project).getScopeForSdk((JdkOrderEntry)entry)).toArray(GlobalSearchScope[]::new);
        result = jdkScopes.length == 0 ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScope.union((GlobalSearchScope[])jdkScopes);
        String modulePath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (modulePath == null) {
            return result;
        }
        List<VirtualFile> files = GradleBuildClasspathManager.getInstance(project).getModuleClasspathEntries(modulePath);
        result = new ExternalModuleBuildGlobalSearchScope(project, result.uniteWith((GlobalSearchScope)new NonClasspathDirectoriesScope(files)), modulePath);
        return result;
    }
}

