/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.GradleIcons;
import java.io.File;
import java.util.regex.Matcher;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;
import org.jetbrains.plugins.groovy.config.GroovyLibraryProperties;

final class GradleLibraryPresentationProvider
extends GroovyLibraryPresentationProviderBase {
    private static final LibraryKind GRADLE_KIND = LibraryKind.create((String)"gradle");
    private final GradleInstallationManager myLibraryManager = (GradleInstallationManager)ApplicationManager.getApplication().getService(GradleInstallationManager.class);

    GradleLibraryPresentationProvider() {
        super(GRADLE_KIND);
    }

    @NotNull
    public Icon getIcon(GroovyLibraryProperties properties) {
        return GradleIcons.Gradle;
    }

    @Nls
    public String getLibraryVersion(VirtualFile[] libraryFiles) {
        return GradleLibraryPresentationProvider.getGradleVersion(libraryFiles);
    }

    public boolean isSDKHome(@NotNull VirtualFile file) {
        return this.myLibraryManager.isGradleSdkHome(null, file);
    }

    public boolean managesLibrary(VirtualFile[] libraryFiles) {
        return this.myLibraryManager.isGradleSdk(libraryFiles);
    }

    @NotNull
    public String getSDKVersion(String path) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        assert (file != null);
        VirtualFile lib = file.findChild("lib");
        assert (lib != null);
        for (VirtualFile virtualFile : lib.getChildren()) {
            String version = GradleLibraryPresentationProvider.getGradleJarVersion(virtualFile);
            if (version == null) continue;
            return version;
        }
        throw new AssertionError((Object)path);
    }

    @Nls
    @NotNull
    public String getLibraryCategoryName() {
        return "Gradle";
    }

    protected void fillLibrary(String path, LibraryEditor libraryEditor) {
        File[] jars;
        File lib = new File(path + "/lib");
        File[] fileArray = jars = lib.exists() ? lib.listFiles() : new File[]{};
        if (jars != null) {
            for (File file : jars) {
                if (!file.getName().endsWith(".jar")) continue;
                libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
        }
    }

    @Nullable
    @NlsSafe
    private static String getGradleVersion(VirtualFile[] libraryFiles) {
        for (VirtualFile file : libraryFiles) {
            String version = GradleLibraryPresentationProvider.getGradleJarVersion(file);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @Nullable
    private static String getGradleJarVersion(VirtualFile file) {
        Matcher matcher = GradleInstallationManager.GRADLE_JAR_FILE_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }
}

