/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.MultipleRepositoryUrlsFix;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

public class MultipleRepositoryUrlsInspection
extends GradleBaseInspection {
    @NotNull
    public GroovyElementVisitor buildGroovyVisitor(@NotNull ProblemsHolder holder, boolean onTheFly) {
        return new MyVisitor(holder);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return BaseInspection.getProbableBugs();
    }

    @NotNull
    static List<GrCallExpression> findUrlCallExpressions(@NotNull GrClosableBlock closure) {
        GrCallExpression[] applicationStatements = (GrCallExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)closure, GrCallExpression.class);
        if (applicationStatements == null) {
            return Collections.emptyList();
        }
        ArrayList<GrCallExpression> statements = new ArrayList<GrCallExpression>();
        for (GrCallExpression statement : applicationStatements) {
            GrReferenceExpression[] referenceExpressions = (GrReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)statement, GrReferenceExpression.class);
            if (referenceExpressions == null) continue;
            for (GrReferenceExpression expression : referenceExpressions) {
                String expressionText = expression.getText();
                if (!"url".equals(expressionText) && !"setUrl".equals(expressionText)) continue;
                statements.add(statement);
            }
        }
        return statements;
    }

    private static class MyVisitor
    extends GroovyElementVisitor {
        private final ProblemsHolder myHolder;

        MyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitClosure(@NotNull GrClosableBlock closure) {
            PsiFile file = closure.getContainingFile();
            if (file == null || !FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
                return;
            }
            super.visitClosure(closure);
            GrMethodCall mavenMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)closure, GrMethodCall.class);
            if (mavenMethodCall == null) {
                return;
            }
            GrExpression mavenMethodExpression = mavenMethodCall.getInvokedExpression();
            if (!ArrayUtil.contains((String)mavenMethodExpression.getText(), (String[])new String[]{"maven", "ivy"})) {
                return;
            }
            GrMethodCall repositoryMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)mavenMethodCall, GrMethodCall.class);
            if (repositoryMethodCall == null) {
                return;
            }
            GrExpression repositoryMethodExpression = repositoryMethodCall.getInvokedExpression();
            if (!repositoryMethodExpression.getText().equals("repositories")) {
                return;
            }
            List<GrCallExpression> statements = MultipleRepositoryUrlsInspection.findUrlCallExpressions(closure);
            if (statements.size() > 1) {
                this.myHolder.registerProblem((PsiElement)closure, GradleInspectionBundle.message("multiple.repository.urls", new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{new MultipleRepositoryUrlsFix(mavenMethodExpression.getText())});
            }
        }
    }
}

