/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyLocalInspectionTool;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.GrBlockLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrExpressionLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J*\u0010\u0015\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/GradlePluginDslStructureInspection;", "Lorg/jetbrains/plugins/groovy/codeInspection/GroovyLocalInspectionTool;", "()V", "allowedStrings", "", "", "buildGroovyVisitor", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkApply", "", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "checkIdAlias", "checkPluginsStatement", "pluginsStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "checkVersion", "decomposeCall", "Lkotlin/Triple;", "Lcom/intellij/psi/PsiElement;", "call", "getBadStatementHighlightingElement", "suspiciousStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "Companion", "intellij.gradle.java"})
public final class GradlePluginDslStructureInspection
extends GroovyLocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> allowedStrings;

    public GradlePluginDslStructureInspection() {
        Object[] objectArray = new String[]{"buildscript", "pluginManagement", "plugins"};
        this.allowedStrings = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public GroovyElementVisitor buildGroovyVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new GroovyElementVisitor(this, holder){
            final /* synthetic */ GradlePluginDslStructureInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitFile(@NotNull GroovyFileBase file) {
                int lastPluginsStatement;
                Object[] statements;
                block3: {
                    int n;
                    Object[] $this$indexOfFirst$iv = statements = file.getStatements();
                    boolean $i$f$indexOfFirst = false;
                    int n2 = $this$indexOfFirst$iv.length;
                    for (int index$iv = 0; index$iv < n2; ++index$iv) {
                        GrStatement it = $this$indexOfFirst$iv[index$iv];
                        boolean bl = false;
                        if (!(it instanceof GrMethodCall && Intrinsics.areEqual((Object)((GrMethodCall)it).getInvokedExpression().getText(), (Object)"plugins"))) continue;
                        n = index$iv;
                        break block3;
                    }
                    n = lastPluginsStatement = -1;
                }
                if (lastPluginsStatement == -1) {
                    return;
                }
                GrStatement grStatement = statements[lastPluginsStatement];
                Intrinsics.checkNotNull((Object)grStatement, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall");
                GrMethodCall pluginsStatement = (GrMethodCall)grStatement;
                GradlePluginDslStructureInspection.access$checkPluginsStatement(this.this$0, this.$holder, pluginsStatement);
                List<E> statementsToCheck = ArraysKt.asList((Object[])statements).subList(0, lastPluginsStatement);
                for (GrStatement suspiciousStatement : statementsToCheck) {
                    PsiElement psiToHighlight;
                    if (GradlePluginDslStructureInspection.access$getBadStatementHighlightingElement(this.this$0, suspiciousStatement) == null) continue;
                    this.$holder.registerProblem(psiToHighlight, GradleInspectionBundle.message("inspection.message.incorrect.buildscript.structure", new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                }
            }
        };
    }

    private final void checkPluginsStatement(ProblemsHolder holder, GrMethodCall pluginsStatement) {
        for (GrStatement statement : Companion.getStatements(pluginsStatement)) {
            String string;
            PsiElement refElement;
            if (!(statement instanceof GrMethodCall)) {
                holder.registerProblem((PsiElement)statement, GradleInspectionBundle.message("inspection.message.only.method.calls.to.id.alias.are.available.in.plugins.block", new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            Triple<PsiElement, GrExpression, String> triple = this.decomposeCall((GrMethodCall)statement);
            if (triple == null) continue;
            PsiElement psiElement = refElement = (PsiElement)triple.component1();
            String string2 = string = psiElement != null ? psiElement.getText() : null;
            if (Intrinsics.areEqual((Object)string, (Object)"apply")) {
                this.checkApply(holder, (GrExpression)statement);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"version")) {
                this.checkVersion(holder, (GrExpression)statement);
                continue;
            }
            if (!this.checkIdAlias(holder, (GrExpression)statement)) continue;
            holder.registerProblem((PsiElement)statement, GradleInspectionBundle.message("inspection.message.only.method.calls.to.id.alias.are.available.in.plugins.block", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private final Triple<PsiElement, GrExpression, String> decomposeCall(GrMethodCall call) {
        GrExpression $this$asSafely$iv = call.getInvokedExpression();
        boolean $i$f$asSafely = false;
        GrExpression grExpression = $this$asSafely$iv;
        if (!(grExpression instanceof GrReferenceExpression)) {
            grExpression = null;
        }
        GrReferenceExpression grReferenceExpression = (GrReferenceExpression)grExpression;
        if (grReferenceExpression == null) {
            return null;
        }
        GrReferenceExpression caller = grReferenceExpression;
        GrExpression $this$asSafely$iv2 = caller.getQualifierExpression();
        boolean $i$f$asSafely2 = false;
        GrExpression grExpression2 = $this$asSafely$iv2;
        if (!(grExpression2 instanceof GrMethodCall)) {
            grExpression2 = null;
        }
        GrMethodCall grMethodCall = (GrMethodCall)grExpression2;
        GrExpression $this$asSafely$iv3 = grMethodCall != null ? grMethodCall.getInvokedExpression() : null;
        boolean $i$f$asSafely3 = false;
        GrExpression grExpression3 = $this$asSafely$iv3;
        if (!(grExpression3 instanceof GrReferenceExpression)) {
            grExpression3 = null;
        }
        GrReferenceExpression grReferenceExpression2 = (GrReferenceExpression)grExpression3;
        String qualifierCallName = grReferenceExpression2 != null ? grReferenceExpression2.getReferenceName() : null;
        return new Triple((Object)caller.getReferenceNameElement(), (Object)caller.getQualifierExpression(), (Object)qualifierCallName);
    }

    private final void checkApply(ProblemsHolder holder, GrExpression method) {
        if (!(method instanceof GrMethodCall)) {
            return;
        }
        Triple<PsiElement, GrExpression, String> triple = this.decomposeCall((GrMethodCall)method);
        if (triple == null) {
            return;
        }
        Triple<PsiElement, GrExpression, String> triple2 = triple;
        PsiElement refElement = (PsiElement)triple2.component1();
        GrExpression qualifier = (GrExpression)triple2.component2();
        String qualifierCallName = (String)triple2.component3();
        if (Intrinsics.areEqual((Object)qualifierCallName, (Object)"version")) {
            this.checkVersion(holder, qualifier);
        } else if (refElement != null && this.checkIdAlias(holder, qualifier)) {
            holder.registerProblem(refElement, GradleInspectionBundle.message("inspection.message.only.method.calls.to.id.alias.are.available.in.plugins.block", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private final void checkVersion(ProblemsHolder holder, GrExpression method) {
        if (!(method instanceof GrMethodCall)) {
            return;
        }
        Triple<PsiElement, GrExpression, String> triple = this.decomposeCall((GrMethodCall)method);
        if (triple == null) {
            return;
        }
        Triple<PsiElement, GrExpression, String> triple2 = triple;
        PsiElement refElement = (PsiElement)triple2.component1();
        GrExpression qualifier = (GrExpression)triple2.component2();
        if (refElement != null && this.checkIdAlias(holder, qualifier)) {
            holder.registerProblem(refElement, GradleInspectionBundle.message("inspection.message.only.method.calls.to.id.alias.are.available.in.plugins.block", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private final boolean checkIdAlias(ProblemsHolder holder, GrExpression method) {
        String methodName;
        PsiElement refElement;
        if (!(method instanceof GrMethodCall)) {
            return true;
        }
        Triple<PsiElement, GrExpression, String> triple = this.decomposeCall((GrMethodCall)method);
        if (triple == null) {
            return true;
        }
        PsiElement psiElement = refElement = (PsiElement)triple.component1();
        String string = methodName = psiElement != null ? psiElement.getText() : null;
        if (!Intrinsics.areEqual((Object)methodName, (Object)"id") && !Intrinsics.areEqual((Object)methodName, (Object)"alias")) {
            PsiElement psiElement2 = refElement;
            if (psiElement2 == null) {
                psiElement2 = (PsiElement)method;
            }
            holder.registerProblem(psiElement2, GradleInspectionBundle.message("inspection.message.only.method.calls.to.id.alias.are.available.in.plugins.block", new Object[0]), new LocalQuickFix[0]);
        }
        return false;
    }

    private final PsiElement getBadStatementHighlightingElement(GrStatement suspiciousStatement) {
        if (!(suspiciousStatement instanceof GrMethodCall)) {
            return (PsiElement)suspiciousStatement;
        }
        if (!this.allowedStrings.contains(((GrMethodCall)suspiciousStatement).getInvokedExpression().getText())) {
            return (PsiElement)((GrMethodCall)suspiciousStatement).getInvokedExpression();
        }
        return null;
    }

    public static final /* synthetic */ void access$checkPluginsStatement(GradlePluginDslStructureInspection $this, ProblemsHolder holder, GrMethodCall pluginsStatement) {
        $this.checkPluginsStatement(holder, pluginsStatement);
    }

    public static final /* synthetic */ PsiElement access$getBadStatementHighlightingElement(GradlePluginDslStructureInspection $this, GrStatement suspiciousStatement) {
        return $this.getBadStatementHighlightingElement(suspiciousStatement);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/GradlePluginDslStructureInspection$Companion;", "", "()V", "getStatements", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "funExpr", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;)[Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;)[Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GrStatement[] getStatements(@NotNull GrMethodCall call) {
            GrFunctionalExpression grFunctionalExpression;
            GrClosableBlock grClosableBlock = (GrClosableBlock)ArraysKt.singleOrNull((Object[])call.getClosureArguments());
            if (grClosableBlock != null) {
                grFunctionalExpression = (GrFunctionalExpression)grClosableBlock;
            } else {
                GrFunctionalExpression grFunctionalExpression2;
                GrExpression grExpression = (GrExpression)ArraysKt.firstOrNull((Object[])call.getExpressionArguments());
                if (grExpression != null) {
                    GrExpression $this$asSafely$iv = grExpression;
                    boolean $i$f$asSafely = false;
                    GrExpression grExpression2 = $this$asSafely$iv;
                    if (!(grExpression2 instanceof GrFunctionalExpression)) {
                        grExpression2 = null;
                    }
                    grFunctionalExpression2 = (GrFunctionalExpression)grExpression2;
                } else {
                    grFunctionalExpression2 = grFunctionalExpression = null;
                }
                if (grFunctionalExpression2 == null) {
                    boolean $i$f$emptyArray = false;
                    return new GrStatement[0];
                }
            }
            GrFunctionalExpression closure = grFunctionalExpression;
            return this.getStatements(closure);
        }

        private final GrStatement[] getStatements(GrFunctionalExpression funExpr) {
            GrStatement[] grStatementArray;
            GrFunctionalExpression grFunctionalExpression = funExpr;
            if (grFunctionalExpression instanceof GrClosableBlock) {
                return ((GrClosableBlock)funExpr).getStatements();
            }
            if (grFunctionalExpression instanceof GrLambdaExpression) {
                GrLambdaBody body = ((GrLambdaExpression)funExpr).getBody();
                if (body instanceof GrBlockLambdaBody) {
                    grStatementArray = ((GrBlockLambdaBody)body).getStatements();
                } else if (body instanceof GrExpressionLambdaBody) {
                    GrStatement[] grStatementArray2 = new GrStatement[]{(GrStatement)((GrExpressionLambdaBody)body).getExpression()};
                    grStatementArray = grStatementArray2;
                } else {
                    boolean $i$f$emptyArray = false;
                    grStatementArray = new GrStatement[]{};
                }
            } else {
                boolean $i$f$emptyArray = false;
                grStatementArray = new GrStatement[]{};
            }
            return grStatementArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

