/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.config.GradleFileType;
import org.jetbrains.plugins.groovy.codeInspection.GroovyLocalInspectionTool;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J-\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J&\u0010\u0018\u001a\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J$\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020\u001d2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\"H\u0002J+\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010$\u001a\u00020%2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0010H\u0002\u00a2\u0006\u0002\u0010&\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/GradleIncorrectDependencyNotationArgumentInspection;", "Lorg/jetbrains/plugins/groovy/codeInspection/GroovyLocalInspectionTool;", "()V", "buildGroovyVisitor", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkArgument", "", "argument", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "type", "Lcom/intellij/psi/PsiType;", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "checkMap", "checkNamedArguments", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/arguments/GrNamedArgument;", "place", "Lcom/intellij/psi/PsiElement;", "checkString", "extractComponentType", "context", "fqn", "", "getObservableArguments", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;[Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;)Ljava/util/List;", "intellij.gradle.java"})
public final class GradleIncorrectDependencyNotationArgumentInspection
extends GroovyLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        return Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)GradleFileType.INSTANCE)) ? super.checkFile(file, manager, isOnTheFly) : null;
    }

    @NotNull
    public GroovyElementVisitor buildGroovyVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new GroovyElementVisitor(holder, this){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ GradleIncorrectDependencyNotationArgumentInspection this$0;
            {
                this.$holder = $holder;
                this.this$0 = $receiver;
            }

            public void visitMethodCall(@NotNull GrMethodCall call) {
                PsiMethod psiMethod = call.resolveMethod();
                if (psiMethod == null) {
                    return;
                }
                PsiMethod method = psiMethod;
                if (!(method instanceof OriginInfoAwareElement) || !Intrinsics.areEqual((Object)((OriginInfoAwareElement)method).getOriginInfo(), (Object)"by Gradle, configuration method")) {
                    return;
                }
                GrExpression[] arguments = call.getArgumentList().getExpressionArguments();
                Object[] namedArguments = call.getNamedArguments();
                if (arguments.length == 0 && namedArguments.length == 0) {
                    this.$holder.registerProblem((PsiElement)call.getArgumentList(), GradleInspectionBundle.message("inspection.display.name.dependency.notation.required", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    return;
                }
                if (!(namedArguments.length == 0)) {
                    GradleIncorrectDependencyNotationArgumentInspection.access$checkNamedArguments(this.this$0, ArraysKt.asList((Object[])namedArguments), (PsiElement)call.getArgumentList(), this.$holder);
                }
                if (!(arguments.length == 0)) {
                    List argumentsToCheck = GradleIncorrectDependencyNotationArgumentInspection.access$getObservableArguments(this.this$0, call, arguments);
                    for (GrExpression argument : argumentsToCheck) {
                        PsiType type = argument.getType();
                        PsiType providerComponentType = GradleIncorrectDependencyNotationArgumentInspection.access$extractComponentType(this.this$0, (PsiElement)argument, type, "org.gradle.api.provider.Provider");
                        PsiType iterableComponentType = GradleIncorrectDependencyNotationArgumentInspection.access$extractComponentType(this.this$0, (PsiElement)argument, providerComponentType, "java.lang.Iterable");
                        GradleIncorrectDependencyNotationArgumentInspection.access$checkArgument(this.this$0, argument, iterableComponentType, this.$holder);
                    }
                }
            }
        };
    }

    private final void checkArgument(GrExpression argument, PsiType type, ProblemsHolder holder) {
        if (type != null) {
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"org.gradle.api.artifacts.Dependency")) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.CharSequence") || type.equalsToText("groovy.lang.GString")) {
                this.checkString(argument, holder);
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"org.gradle.api.artifacts.MinimalExternalModuleDependency")) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
                this.checkMap(argument, holder);
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"org.gradle.api.file.FileCollection")) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"org.gradle.api.Project")) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory.ClassPathNotation")) {
                return;
            }
        }
        holder.registerProblem((PsiElement)argument, GradleInspectionBundle.message("inspection.display.name.unrecognized.dependency.notation", new Object[0]), new LocalQuickFix[0]);
    }

    private final PsiType extractComponentType(PsiElement context, PsiType type, String fqn) {
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"org.gradle.api.file.FileCollection") || !InheritanceUtil.isInheritor((PsiType)type, (String)fqn)) {
            return type;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(fqn, context.getResolveScope());
        if (psiClass == null) {
            return type;
        }
        PsiClass providerClass = psiClass;
        Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type com.intellij.psi.PsiClassType");
        PsiSubstitutor conversion = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)providerClass, (PsiClassType)((PsiClassType)type));
        PsiType psiType = (PsiType)CollectionsKt.firstOrNull((Iterable)conversion.getSubstitutionMap().values());
        if (psiType == null) {
            psiType = type;
        }
        return psiType;
    }

    private final void checkMap(GrExpression argument, ProblemsHolder holder) {
        if (argument instanceof GrListOrMap) {
            this.checkNamedArguments(ArraysKt.asList((Object[])((GrListOrMap)argument).getNamedArguments()), (PsiElement)argument, holder);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void checkNamedArguments(List<? extends GrNamedArgument> arguments, PsiElement place, ProblemsHolder holder) {
        block9: {
            Object[] objectArray;
            boolean hasName = false;
            boolean hasGroup = false;
            boolean hasVersion = false;
            for (GrNamedArgument grNamedArgument : arguments) {
                block10: {
                    block11: {
                        block12: {
                            String string;
                            String string2 = string = grNamedArgument.getLabelName();
                            if (string2 == null) break block9;
                            switch (string2.hashCode()) {
                                case 3373707: {
                                    if (string.equals("name")) break;
                                    break block10;
                                }
                                case 351608024: {
                                    if (string.equals("version")) break block11;
                                    break block10;
                                }
                                case 98629247: {
                                    if (string.equals("group")) break block12;
                                    break block10;
                                }
                            }
                            hasName = true;
                            continue;
                        }
                        hasGroup = true;
                        continue;
                    }
                    hasVersion = true;
                }
            }
            if (!hasName) {
                objectArray = new Object[]{"name"};
                holder.registerProblem(place, GradleInspectionBundle.message("inspection.display.name.label.0.is.required", objectArray), new LocalQuickFix[0]);
            }
            if (!hasGroup) {
                objectArray = new Object[]{"group"};
                holder.registerProblem(place, GradleInspectionBundle.message("inspection.display.name.label.0.is.required", objectArray), new LocalQuickFix[0]);
            }
            if (!hasVersion) {
                objectArray = new Object[]{"version"};
                holder.registerProblem(place, GradleInspectionBundle.message("inspection.display.name.label.0.is.required", objectArray), new LocalQuickFix[0]);
            }
            return;
        }
    }

    private final void checkString(GrExpression argument, ProblemsHolder holder) {
        Object string = GroovyConstantExpressionEvaluator.evaluate((GrExpression)argument);
        if (string instanceof String) {
            String[] stringArray = new String[]{":"};
            List parts = StringsKt.split$default((CharSequence)((CharSequence)string), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() < 2) {
                holder.registerProblem((PsiElement)argument, GradleInspectionBundle.message("inspection.display.name.expected.3.parts.separated.by.colon", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private final List<GrExpression> getObservableArguments(GrMethodCall call, GrExpression[] arguments) {
        return !call.hasClosureArguments() && InheritanceUtil.isInheritor((PsiType)((GrExpression)ArraysKt.last((Object[])arguments)).getType(), (String)"groovy.lang.Closure") ? ArraysKt.asList((Object[])arguments).subList(0, ArraysKt.getLastIndex((Object[])arguments)) : ArraysKt.asList((Object[])arguments);
    }

    public static final /* synthetic */ void access$checkNamedArguments(GradleIncorrectDependencyNotationArgumentInspection $this, List arguments, PsiElement place, ProblemsHolder holder) {
        $this.checkNamedArguments(arguments, place, holder);
    }

    public static final /* synthetic */ List access$getObservableArguments(GradleIncorrectDependencyNotationArgumentInspection $this, GrMethodCall call, GrExpression[] arguments) {
        return $this.getObservableArguments(call, arguments);
    }

    public static final /* synthetic */ PsiType access$extractComponentType(GradleIncorrectDependencyNotationArgumentInspection $this, PsiElement context, PsiType type, String fqn) {
        return $this.extractComponentType(context, type, fqn);
    }

    public static final /* synthetic */ void access$checkArgument(GradleIncorrectDependencyNotationArgumentInspection $this, GrExpression argument, PsiType type, ProblemsHolder holder) {
        $this.checkArgument(argument, type, holder);
    }
}

