/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.fix.FixUtilKt;
import org.jetbrains.plugins.gradle.codeInspection.fix.GradleTaskToRegisterFix;
import org.jetbrains.plugins.gradle.codeInspection.fix.GradleWithTypeFix;
import org.jetbrains.plugins.gradle.service.resolve.UtilKt;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.groovy.intentions.GrReplaceMethodCallQuickFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J(\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\bH\u0002J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J(\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/GradleConfigurationAvoidanceInspection;", "Lorg/jetbrains/plugins/gradle/codeInspection/GradleBaseInspection;", "()V", "buildGroovyVisitor", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "lazyApiAvailable", "call", "Lcom/intellij/psi/PsiElement;", "processDomainObjectCollection", "", "method", "Lcom/intellij/psi/PsiMethod;", "elementToHighlight", "processNamedDomainObjectCollection", "processProject", "isReturnTypeValueUsed", "processTaskCollection", "processTaskContainer", "intellij.gradle.java"})
public final class GradleConfigurationAvoidanceInspection
extends GradleBaseInspection {
    @NotNull
    public GroovyElementVisitor buildGroovyVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new GroovyElementVisitor(this, holder){
            final /* synthetic */ GradleConfigurationAvoidanceInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitMethodCall(@NotNull GrMethodCall call) {
                PsiElement psiElement;
                if (!GradleConfigurationAvoidanceInspection.access$lazyApiAvailable(this.this$0, (PsiElement)call)) {
                    return;
                }
                PsiMethod psiMethod = call.resolveMethod();
                if (psiMethod == null) {
                    return;
                }
                PsiMethod method = psiMethod;
                GrExpression callExpression = call.getInvokedExpression();
                if (callExpression instanceof GrReferenceExpression) {
                    psiElement = ((GrReferenceExpression)callExpression).getReferenceNameElement();
                    if (psiElement == null) {
                        psiElement = (PsiElement)callExpression;
                    }
                } else {
                    psiElement = (PsiElement)callExpression;
                }
                PsiElement elementToHighlight = psiElement;
                this.processMethod(method, elementToHighlight, this.$holder, FixUtilKt.isReturnTypeValueUsed((PsiElement)call));
            }

            public void visitIndexProperty(@NotNull GrIndexProperty expression) {
                if (!GradleConfigurationAvoidanceInspection.access$lazyApiAvailable(this.this$0, (PsiElement)expression)) {
                    return;
                }
                GroovyMethodCallReference groovyMethodCallReference = expression.getRValueReference();
                PsiElement $this$asSafely$iv = groovyMethodCallReference != null ? groovyMethodCallReference.resolve() : null;
                boolean $i$f$asSafely = false;
                PsiElement psiElement = $this$asSafely$iv;
                if (!(psiElement instanceof PsiMethod)) {
                    psiElement = null;
                }
                PsiMethod psiMethod = (PsiMethod)psiElement;
                if (psiMethod == null) {
                    return;
                }
                PsiMethod method = psiMethod;
                GrArgumentList elementToHighlight = expression.getArgumentList();
                this.processMethod(method, (PsiElement)elementToHighlight, this.$holder, FixUtilKt.isReturnTypeValueUsed((PsiElement)expression));
            }

            public final void processMethod(@NotNull PsiMethod method, @NotNull PsiElement elementToHighlight, @NotNull ProblemsHolder holder, boolean isReturnTypeValueUsed) {
                PsiClass psiClass = method.getContainingClass();
                if (psiClass == null) {
                    return;
                }
                PsiClass containingClass = psiClass;
                if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.gradle.api.tasks.TaskContainer")) {
                    GradleConfigurationAvoidanceInspection.access$processTaskContainer(this.this$0, method, elementToHighlight, holder, isReturnTypeValueUsed);
                }
                if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.gradle.api.DomainObjectCollection")) {
                    GradleConfigurationAvoidanceInspection.access$processDomainObjectCollection(this.this$0, method, elementToHighlight, holder);
                }
                if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.gradle.api.Project")) {
                    GradleConfigurationAvoidanceInspection.access$processProject(this.this$0, method, elementToHighlight, holder, isReturnTypeValueUsed);
                }
                if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.gradle.api.NamedDomainObjectCollection")) {
                    GradleConfigurationAvoidanceInspection.access$processNamedDomainObjectCollection(this.this$0, method, elementToHighlight, holder);
                }
                if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.gradle.api.tasks.TaskCollection")) {
                    GradleConfigurationAvoidanceInspection.access$processTaskCollection(this.this$0, method, elementToHighlight, holder);
                }
            }
        };
    }

    private final boolean lazyApiAvailable(PsiElement call) {
        String string = UtilKt.getLinkedGradleProjectPath(call);
        if (string == null) {
            return false;
        }
        String linkedProjectPath = string;
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)call.getProject()).getLinkedProjectSettings(linkedProjectPath);
        if (gradleProjectSettings == null || (gradleProjectSettings = gradleProjectSettings.resolveGradleVersion()) == null) {
            return false;
        }
        GradleProjectSettings gradleVersion = gradleProjectSettings;
        return gradleVersion.compareTo(GradleVersion.version((String)"4.9")) >= 0;
    }

    private final void processNamedDomainObjectCollection(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder) {
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"findByName")) {
            Object[] objectArray = new Object[]{"named"};
            holder.registerProblem(elementToHighlight, GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private final void processProject(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder, boolean isReturnTypeValueUsed) {
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"task")) {
            GradleTaskToRegisterFix[] gradleTaskToRegisterFixArray;
            Object[] objectArray;
            if (!isReturnTypeValueUsed) {
                objectArray = new GradleTaskToRegisterFix[]{new GradleTaskToRegisterFix()};
                gradleTaskToRegisterFixArray = objectArray;
            } else {
                boolean $i$f$emptyArray = false;
                gradleTaskToRegisterFixArray = new GradleTaskToRegisterFix[]{};
            }
            GradleTaskToRegisterFix[] fixes = gradleTaskToRegisterFixArray;
            objectArray = new Object[]{"tasks.register"};
            holder.registerProblem(elementToHighlight, GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(fixes, fixes.length));
        }
    }

    private final void processDomainObjectCollection(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder) {
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"all") || Intrinsics.areEqual((Object)method.getName(), (Object)"whenObjectAdded") || Intrinsics.areEqual((Object)method.getName(), (Object)"each")) {
            Object[] objectArray = new Object[]{"configureEach"};
            String string = GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray);
            objectArray = new LocalQuickFix[]{(LocalQuickFix)new GrReplaceMethodCallQuickFix(method.getName(), "configureEach")};
            holder.registerProblem(elementToHighlight, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])objectArray);
        } else if (Intrinsics.areEqual((Object)method.getName(), (Object)"withType") && method.getParameters().length > 1) {
            Object[] objectArray = new Object[]{"withType(...).configureEach"};
            String string = GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray);
            objectArray = new LocalQuickFix[]{new GradleWithTypeFix()};
            holder.registerProblem(elementToHighlight, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])objectArray);
        } else if (Intrinsics.areEqual((Object)method.getName(), (Object)"getByName") || Intrinsics.areEqual((Object)method.getName(), (Object)"getAt")) {
            Object[] objectArray = new Object[]{"named"};
            holder.registerProblem(elementToHighlight, GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private final void processTaskContainer(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder, boolean isReturnTypeValueUsed) {
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"create")) {
            GrReplaceMethodCallQuickFix[] grReplaceMethodCallQuickFixArray;
            Object[] objectArray;
            if (!isReturnTypeValueUsed) {
                objectArray = new GrReplaceMethodCallQuickFix[]{new GrReplaceMethodCallQuickFix(method.getName(), "register")};
                grReplaceMethodCallQuickFixArray = objectArray;
            } else {
                boolean $i$f$emptyArray = false;
                grReplaceMethodCallQuickFixArray = new GrReplaceMethodCallQuickFix[]{};
            }
            GrReplaceMethodCallQuickFix[] fixes = grReplaceMethodCallQuickFixArray;
            objectArray = new Object[]{"register"};
            holder.registerProblem(elementToHighlight, GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(fixes, fixes.length));
        }
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"getByPath") || Intrinsics.areEqual((Object)method.getName(), (Object)"findByPath")) {
            Object[] objectArray = new Object[]{method.getName()};
            holder.registerProblem(elementToHighlight, GradleInspectionBundle.message("inspection.message.0.requires.ordering", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private final void processTaskCollection(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder) {
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"whenTaskAdded")) {
            Object[] objectArray = new Object[]{"configureEach"};
            String string = GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray);
            objectArray = new LocalQuickFix[]{(LocalQuickFix)new GrReplaceMethodCallQuickFix(method.getName(), "configureEach")};
            holder.registerProblem(elementToHighlight, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])objectArray);
        }
    }

    public static final /* synthetic */ boolean access$lazyApiAvailable(GradleConfigurationAvoidanceInspection $this, PsiElement call) {
        return $this.lazyApiAvailable(call);
    }

    public static final /* synthetic */ void access$processTaskContainer(GradleConfigurationAvoidanceInspection $this, PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder, boolean isReturnTypeValueUsed) {
        $this.processTaskContainer(method, elementToHighlight, holder, isReturnTypeValueUsed);
    }

    public static final /* synthetic */ void access$processDomainObjectCollection(GradleConfigurationAvoidanceInspection $this, PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder) {
        $this.processDomainObjectCollection(method, elementToHighlight, holder);
    }

    public static final /* synthetic */ void access$processProject(GradleConfigurationAvoidanceInspection $this, PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder, boolean isReturnTypeValueUsed) {
        $this.processProject(method, elementToHighlight, holder, isReturnTypeValueUsed);
    }

    public static final /* synthetic */ void access$processNamedDomainObjectCollection(GradleConfigurationAvoidanceInspection $this, PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder) {
        $this.processNamedDomainObjectCollection(method, elementToHighlight, holder);
    }

    public static final /* synthetic */ void access$processTaskCollection(GradleConfigurationAvoidanceInspection $this, PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder) {
        $this.processTaskCollection(method, elementToHighlight, holder);
    }
}

