/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/BintrayPublishingPluginInspection;", "Lorg/jetbrains/plugins/gradle/codeInspection/GradleBaseInspection;", "()V", "buildGroovyVisitor", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.gradle.java"})
public final class BintrayPublishingPluginInspection
extends GradleBaseInspection {
    @NotNull
    public GroovyElementVisitor buildGroovyVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new GroovyElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitLiteralExpression(@NotNull GrLiteral literal) {
                PsiFile file = literal.getContainingFile();
                if (!FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
                    return;
                }
                super.visitLiteralExpression(literal);
                if (!literal.isString()) {
                    return;
                }
                if (Intrinsics.areEqual((Object)"com.jfrog.bintray", (Object)literal.getValue()) && (this.isPluginDSL(literal) || this.isApplyPlugin(literal))) {
                    this.$holder.registerProblem((PsiElement)literal, GradleInspectionBundle.message("bintray.publishing.plugin", new Object[0]), ProblemHighlightType.WARNING, new LocalQuickFix[0]);
                }
            }

            private final boolean isApplyPlugin(GrLiteral literal) {
                boolean bl;
                PsiElement psiElement;
                PsiElement psiElement2 = literal.getParent();
                PsiElement psiElement3 = psiElement = psiElement2 != null && (psiElement2 = psiElement2.getParent()) != null ? psiElement2.getParent() : null;
                GrCall grCall = psiElement instanceof GrCall ? (GrCall)psiElement : null;
                if (grCall != null && (grCall = grCall.resolveMethod()) != null) {
                    GrCall it = grCall;
                    boolean bl2 = false;
                    PsiClass psiClass = it.getContainingClass();
                    bl = Intrinsics.areEqual((Object)"org.gradle.api.plugins.PluginAware", (Object)(psiClass != null ? psiClass.getQualifiedName() : null)) && Intrinsics.areEqual((Object)"apply", (Object)it.getName());
                } else {
                    bl = false;
                }
                return bl;
            }

            private final boolean isPluginDSL(GrLiteral literal) {
                boolean bl;
                PsiElement psiElement = literal.getParent();
                Object object = psiElement != null ? psiElement.getParent() : null;
                GrCall grCall = object instanceof GrCall ? (GrCall)object : null;
                if (grCall != null && (grCall = grCall.resolveMethod()) != null) {
                    GrCall it = grCall;
                    boolean bl2 = false;
                    PsiClass psiClass = it.getContainingClass();
                    bl = Intrinsics.areEqual((Object)"org.gradle.plugin.use.PluginDependenciesSpec", (Object)(psiClass != null ? psiClass.getQualifiedName() : null)) && Intrinsics.areEqual((Object)"id", (Object)it.getName());
                } else {
                    bl = false;
                }
                return bl;
            }
        };
    }
}

