/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.java;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.java.ExplodedDirectoryModuleExtension;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsAnnotationRootType;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaDependencyScope;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.java.JpsNativeLibraryRootType;
import org.jetbrains.jps.model.java.JpsProductionModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.JpsProductionModuleSourcePackagingElement;
import org.jetbrains.jps.model.java.JpsTestModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsRepositoryLibraryType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsPackagingElementSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsCompilerValidationExcludeSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsEclipseCompilerOptionsSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerConfigurationSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerNotNullableSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerOptionsSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerWorkspaceConfigurationSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsValidationSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.RmicCompilerOptionsSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryPropertiesSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryRootTypeSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootPropertiesSerializer;

public class JpsJavaModelSerializerExtension
extends JpsModelSerializerExtension {
    public static final String EXPORTED_ATTRIBUTE = "exported";
    public static final String SCOPE_ATTRIBUTE = "scope";
    public static final String OUTPUT_TAG = "output";
    public static final String URL_ATTRIBUTE = "url";
    public static final String LANGUAGE_LEVEL_ATTRIBUTE = "languageLevel";
    public static final String EXPLODED_TAG = "exploded";
    public static final String EXCLUDE_EXPLODED_TAG = "exclude-exploded";
    public static final String TEST_OUTPUT_TAG = "output-test";
    public static final String INHERIT_COMPILER_OUTPUT_ATTRIBUTE = "inherit-compiler-output";
    public static final String EXCLUDE_OUTPUT_TAG = "exclude-output";
    public static final String ANNOTATION_PATHS_TAG = "annotation-paths";
    public static final String JAVADOC_PATHS_TAG = "javadoc-paths";
    public static final String MODULE_LANGUAGE_LEVEL_ATTRIBUTE = "LANGUAGE_LEVEL";
    public static final String ROOT_TAG = "root";
    public static final String RELATIVE_OUTPUT_PATH_ATTRIBUTE = "relativeOutputPath";
    public static final String IS_GENERATED_ATTRIBUTE = "generated";
    public static final JavaSourceRootPropertiesSerializer JAVA_SOURCE_ROOT_PROPERTIES_SERIALIZER = new JavaSourceRootPropertiesSerializer(JavaSourceRootType.SOURCE, "java-source");
    public static final String JAVA_RESOURCE_ROOT_ID = "java-resource";
    public static final String JAVA_TEST_RESOURCE_ROOT_ID = "java-test-resource";

    @Override
    public void loadRootModel(@NotNull JpsModule module, @NotNull Element rootModel) {
        JpsJavaModelSerializerExtension.loadExplodedDirectoryExtension(module, rootModel);
        JpsJavaModelSerializerExtension.loadJavaModuleExtension(module, rootModel);
    }

    @Override
    public void loadModuleOptions(@NotNull JpsModule module, @NotNull Element rootElement) {
        String productionModuleName;
        Element testModuleProperties = JDomSerializationUtil.findComponent(rootElement, "TestModuleProperties");
        if (testModuleProperties != null && (productionModuleName = testModuleProperties.getAttributeValue("production-module")) != null) {
            JpsJavaModelSerializerExtension.getService().setTestModuleProperties(module, JpsElementFactory.getInstance().createModuleReference(productionModuleName));
        }
    }

    @Override
    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        return Arrays.asList(new JavaProjectExtensionSerializer(), new JpsJavaCompilerConfigurationSerializer(), new JpsValidationSerializer(), new JpsJavaCompilerNotNullableSerializer(), new JpsCompilerValidationExcludeSerializer(), new JpsJavaCompilerWorkspaceConfigurationSerializer(), new JpsJavaCompilerOptionsSerializer("JavacSettings", "Javac"), new JpsEclipseCompilerOptionsSerializer("EclipseCompilerSettings", "Eclipse"), new RmicCompilerOptionsSerializer("RmicSettings", "Rmic"));
    }

    @Override
    @NotNull
    public List<? extends JpsModuleSourceRootPropertiesSerializer<?>> getModuleSourceRootPropertiesSerializers() {
        return Arrays.asList(JAVA_SOURCE_ROOT_PROPERTIES_SERIALIZER, new JavaSourceRootPropertiesSerializer(JavaSourceRootType.TEST_SOURCE, "java-test"), new JavaResourceRootPropertiesSerializer(JavaResourceRootType.RESOURCE, JAVA_RESOURCE_ROOT_ID), new JavaResourceRootPropertiesSerializer(JavaResourceRootType.TEST_RESOURCE, JAVA_TEST_RESOURCE_ROOT_ID));
    }

    @Override
    public void loadModuleDependencyProperties(JpsDependencyElement dependency, Element entry) {
        JpsJavaDependencyScope scope;
        boolean exported = entry.getAttributeValue(EXPORTED_ATTRIBUTE) != null;
        String scopeName = entry.getAttributeValue(SCOPE_ATTRIBUTE);
        try {
            scope = scopeName != null ? JpsJavaDependencyScope.valueOf(scopeName) : JpsJavaDependencyScope.COMPILE;
        }
        catch (IllegalArgumentException e) {
            scope = JpsJavaDependencyScope.COMPILE;
        }
        JpsJavaDependencyExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateDependencyExtension(dependency);
        extension.setExported(exported);
        extension.setScope(scope);
    }

    @Override
    public List<JpsLibraryRootTypeSerializer> getLibraryRootTypeSerializers() {
        return Arrays.asList(new JpsLibraryRootTypeSerializer("JAVADOC", JpsOrderRootType.DOCUMENTATION, true), new JpsLibraryRootTypeSerializer("ANNOTATIONS", JpsAnnotationRootType.INSTANCE, false), new JpsLibraryRootTypeSerializer("NATIVE", JpsNativeLibraryRootType.INSTANCE, false));
    }

    @Override
    @NotNull
    public List<JpsLibraryRootTypeSerializer> getSdkRootTypeSerializers() {
        return Arrays.asList(new JpsLibraryRootTypeSerializer("javadocPath", JpsOrderRootType.DOCUMENTATION, true), new JpsLibraryRootTypeSerializer("annotationsPath", JpsAnnotationRootType.INSTANCE, true));
    }

    @Override
    @NotNull
    public List<? extends JpsPackagingElementSerializer<?>> getPackagingElementSerializers() {
        return Arrays.asList(new JpsModuleOutputPackagingElementSerializer(), new JpsTestModuleOutputPackagingElementSerializer(), new JpsModuleSourcePackagingElementSerializer());
    }

    @Override
    @NotNull
    public List<? extends JpsLibraryPropertiesSerializer<?>> getLibraryPropertiesSerializers() {
        return Collections.singletonList(new JpsRepositoryLibraryPropertiesSerializer());
    }

    private static void loadExplodedDirectoryExtension(JpsModule module, Element rootModelComponent) {
        Element exploded = rootModelComponent.getChild(EXPLODED_TAG);
        if (exploded != null) {
            ExplodedDirectoryModuleExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateExplodedDirectoryExtension(module);
            extension.setExcludeExploded(rootModelComponent.getChild(EXCLUDE_EXPLODED_TAG) != null);
            extension.setExplodedUrl(exploded.getAttributeValue(URL_ATTRIBUTE));
        }
    }

    private static void loadJavaModuleExtension(JpsModule module, Element rootModelComponent) {
        JpsJavaModuleExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateModuleExtension(module);
        Element outputTag = rootModelComponent.getChild(OUTPUT_TAG);
        String outputUrl = outputTag != null ? outputTag.getAttributeValue(URL_ATTRIBUTE) : null;
        extension.setOutputUrl(outputUrl);
        Element testOutputTag = rootModelComponent.getChild(TEST_OUTPUT_TAG);
        String testOutputUrl = testOutputTag != null ? testOutputTag.getAttributeValue(URL_ATTRIBUTE) : null;
        extension.setTestOutputUrl(StringUtil.isEmpty((String)testOutputUrl) ? outputUrl : testOutputUrl);
        extension.setInheritOutput(Boolean.parseBoolean(rootModelComponent.getAttributeValue(INHERIT_COMPILER_OUTPUT_ATTRIBUTE)));
        extension.setExcludeOutput(rootModelComponent.getChild(EXCLUDE_OUTPUT_TAG) != null);
        String languageLevel = rootModelComponent.getAttributeValue(MODULE_LANGUAGE_LEVEL_ATTRIBUTE);
        if (languageLevel != null) {
            extension.setLanguageLevel(JpsJavaModelSerializerExtension.readLanguageLevel(languageLevel, null));
        }
        JpsJavaModelSerializerExtension.loadAdditionalRoots(rootModelComponent, ANNOTATION_PATHS_TAG, extension.getAnnotationRoots());
        JpsJavaModelSerializerExtension.loadAdditionalRoots(rootModelComponent, JAVADOC_PATHS_TAG, extension.getJavadocRoots());
    }

    private static void loadAdditionalRoots(Element rootModelComponent, String rootsTagName, JpsUrlList result) {
        Element roots = rootModelComponent.getChild(rootsTagName);
        for (Element root : JDOMUtil.getChildren((Element)roots, (String)ROOT_TAG)) {
            result.addUrl(root.getAttributeValue(URL_ATTRIBUTE));
        }
    }

    private static JpsJavaExtensionService getService() {
        return JpsJavaExtensionService.getInstance();
    }

    private static LanguageLevel readLanguageLevel(String level, LanguageLevel defaultLevel) {
        for (LanguageLevel languageLevel : LanguageLevel.values()) {
            if (!level.equals(languageLevel.name())) continue;
            return languageLevel;
        }
        return defaultLevel;
    }

    private static class JavaProjectExtensionSerializer
    extends JpsProjectExtensionSerializer {
        JavaProjectExtensionSerializer() {
            super(null, "ProjectRootManager");
        }

        @Override
        public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            String languageLevel;
            String url;
            JpsJavaProjectExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateProjectExtension(project);
            Element output = componentTag.getChild(JpsJavaModelSerializerExtension.OUTPUT_TAG);
            if (output != null && (url = output.getAttributeValue(JpsJavaModelSerializerExtension.URL_ATTRIBUTE)) != null) {
                extension.setOutputUrl(url);
            }
            if ((languageLevel = componentTag.getAttributeValue(JpsJavaModelSerializerExtension.LANGUAGE_LEVEL_ATTRIBUTE)) != null) {
                extension.setLanguageLevel(JpsJavaModelSerializerExtension.readLanguageLevel(languageLevel, LanguageLevel.HIGHEST));
            }
        }
    }

    private static final class JavaSourceRootPropertiesSerializer
    extends JpsModuleSourceRootPropertiesSerializer<JavaSourceRootProperties> {
        private JavaSourceRootPropertiesSerializer(JpsModuleSourceRootType<JavaSourceRootProperties> type, String typeId) {
            super(type, typeId);
        }

        @Override
        public JavaSourceRootProperties loadProperties(@NotNull Element sourceRootTag) {
            String packagePrefix = StringUtil.notNullize((String)sourceRootTag.getAttributeValue("packagePrefix"));
            boolean isGenerated = Boolean.parseBoolean(sourceRootTag.getAttributeValue(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE));
            return JpsJavaModelSerializerExtension.getService().createSourceRootProperties(packagePrefix, isGenerated);
        }

        @Override
        public void saveProperties(@NotNull JavaSourceRootProperties properties, @NotNull Element sourceRootTag) {
            String isTestSource = Boolean.toString(((JpsModuleSourceRootType)this.getType()).equals(JavaSourceRootType.TEST_SOURCE));
            sourceRootTag.setAttribute("isTestSource", isTestSource);
            String packagePrefix = properties.getPackagePrefix();
            if (!packagePrefix.isEmpty()) {
                sourceRootTag.setAttribute("packagePrefix", packagePrefix);
            }
            if (properties.isForGeneratedSources()) {
                sourceRootTag.setAttribute(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE, Boolean.TRUE.toString());
            }
        }
    }

    private static final class JavaResourceRootPropertiesSerializer
    extends JpsModuleSourceRootPropertiesSerializer<JavaResourceRootProperties> {
        private JavaResourceRootPropertiesSerializer(JpsModuleSourceRootType<JavaResourceRootProperties> type, String typeId) {
            super(type, typeId);
        }

        @Override
        public JavaResourceRootProperties loadProperties(@NotNull Element sourceRootTag) {
            String relativeOutputPath = StringUtil.notNullize((String)sourceRootTag.getAttributeValue(JpsJavaModelSerializerExtension.RELATIVE_OUTPUT_PATH_ATTRIBUTE));
            boolean isGenerated = Boolean.parseBoolean(sourceRootTag.getAttributeValue(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE));
            return JpsJavaModelSerializerExtension.getService().createResourceRootProperties(relativeOutputPath, isGenerated);
        }

        @Override
        public void saveProperties(@NotNull JavaResourceRootProperties properties, @NotNull Element sourceRootTag) {
            String relativeOutputPath = properties.getRelativeOutputPath();
            if (!relativeOutputPath.isEmpty()) {
                sourceRootTag.setAttribute(JpsJavaModelSerializerExtension.RELATIVE_OUTPUT_PATH_ATTRIBUTE, relativeOutputPath);
            }
            if (properties.isForGeneratedSources()) {
                sourceRootTag.setAttribute(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE, Boolean.TRUE.toString());
            }
        }
    }

    private static final class JpsModuleOutputPackagingElementSerializer
    extends JpsPackagingElementSerializer<JpsProductionModuleOutputPackagingElement> {
        private JpsModuleOutputPackagingElementSerializer() {
            super("module-output", JpsProductionModuleOutputPackagingElement.class);
        }

        @Override
        public JpsProductionModuleOutputPackagingElement load(Element element) {
            JpsModuleReference reference = JpsElementFactory.getInstance().createModuleReference(element.getAttributeValue("name"));
            return JpsJavaModelSerializerExtension.getService().createProductionModuleOutput(reference);
        }
    }

    private static final class JpsTestModuleOutputPackagingElementSerializer
    extends JpsPackagingElementSerializer<JpsTestModuleOutputPackagingElement> {
        private JpsTestModuleOutputPackagingElementSerializer() {
            super("module-test-output", JpsTestModuleOutputPackagingElement.class);
        }

        @Override
        public JpsTestModuleOutputPackagingElement load(Element element) {
            JpsModuleReference reference = JpsElementFactory.getInstance().createModuleReference(element.getAttributeValue("name"));
            return JpsJavaModelSerializerExtension.getService().createTestModuleOutput(reference);
        }
    }

    private static final class JpsModuleSourcePackagingElementSerializer
    extends JpsPackagingElementSerializer<JpsProductionModuleSourcePackagingElement> {
        private JpsModuleSourcePackagingElementSerializer() {
            super("module-source", JpsProductionModuleSourcePackagingElement.class);
        }

        @Override
        public JpsProductionModuleSourcePackagingElement load(Element element) {
            JpsModuleReference reference = JpsElementFactory.getInstance().createModuleReference(element.getAttributeValue("name"));
            return JpsJavaModelSerializerExtension.getService().createProductionModuleSource(reference);
        }
    }

    private static class JpsRepositoryLibraryPropertiesSerializer
    extends JpsLibraryPropertiesSerializer<JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor>> {
        private static final String MAVEN_ID_ATTRIBUTE = "maven-id";
        private static final String INCLUDE_TRANSITIVE_DEPS_ATTRIBUTE = "include-transitive-deps";
        private static final String EXCLUDE_TAG = "exclude";
        private static final String DEPENDENCY_TAG = "dependency";

        JpsRepositoryLibraryPropertiesSerializer() {
            super(JpsRepositoryLibraryType.INSTANCE, JpsRepositoryLibraryType.INSTANCE.getTypeId());
        }

        @Override
        public JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor> loadProperties(@Nullable Element elem) {
            return JpsElementFactory.getInstance().createSimpleElement(JpsRepositoryLibraryPropertiesSerializer.loadDescriptor(elem));
        }

        @NotNull
        private static JpsMavenRepositoryLibraryDescriptor loadDescriptor(@Nullable Element elem) {
            if (elem == null) {
                return new JpsMavenRepositoryLibraryDescriptor(null);
            }
            boolean includeTransitiveDependencies = Boolean.parseBoolean(elem.getAttributeValue(INCLUDE_TRANSITIVE_DEPS_ATTRIBUTE, "true"));
            Element excludeTag = elem.getChild(EXCLUDE_TAG);
            List dependencyTags = excludeTag != null ? excludeTag.getChildren(DEPENDENCY_TAG) : Collections.emptyList();
            List excludedDependencies = ContainerUtil.map((Collection)dependencyTags, it -> it.getAttributeValue(MAVEN_ID_ATTRIBUTE));
            return new JpsMavenRepositoryLibraryDescriptor(elem.getAttributeValue(MAVEN_ID_ATTRIBUTE, (String)null), includeTransitiveDependencies, excludedDependencies);
        }
    }
}

