/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.impl;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.JpsGlobalLoader;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.model.serialization.JpsPathMapper;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;

public final class JpsSerializationManagerImpl
extends JpsSerializationManager {
    @Override
    @NotNull
    public JpsModel loadModel(@NotNull String projectPath, @Nullable String optionsPath, boolean loadUnloadedModules) throws IOException {
        JpsModel model = JpsElementFactory.getInstance().createModel();
        if (optionsPath != null) {
            JpsGlobalLoader.loadGlobalSettings(model.getGlobal(), optionsPath);
        }
        Map<String, String> pathVariables = JpsModelSerializationDataService.computeAllPathVariables(model.getGlobal());
        JpsProjectLoader.loadProject(model.getProject(), pathVariables, model.getGlobal().getPathMapper(), Paths.get(projectPath, new String[0]), loadUnloadedModules);
        return model;
    }

    @Override
    @NotNull
    public JpsProject loadProject(@NotNull String projectPath, @NotNull Map<String, String> pathVariables) throws IOException {
        return this.loadProject(projectPath, pathVariables, false);
    }

    @Override
    @NotNull
    public JpsProject loadProject(@NotNull String projectPath, @NotNull Map<String, String> pathVariables, boolean loadUnloadedModules) throws IOException {
        JpsModel model = JpsElementFactory.getInstance().createModel();
        JpsProjectLoader.loadProject(model.getProject(), pathVariables, JpsPathMapper.IDENTITY, Paths.get(projectPath, new String[0]), loadUnloadedModules);
        return model.getProject();
    }
}

