/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SystemProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathMacroUtil {
    @NonNls
    public static final String PROJECT_DIR_MACRO_NAME = "PROJECT_DIR";
    @NonNls
    public static final String PROJECT_NAME_MACRO_NAME = "PROJECT_NAME";
    @NonNls
    public static final String MODULE_DIR_MACRO_NAME = "MODULE_DIR";
    public static final String DEPRECATED_MODULE_DIR = "$MODULE_DIR$";
    public static final String MODULE_WORKING_DIR_NAME = "MODULE_WORKING_DIR";
    public static final String MODULE_WORKING_DIR = "$MODULE_WORKING_DIR$";
    @NonNls
    public static final String DIRECTORY_STORE_NAME = ".idea";
    @NonNls
    public static final String APPLICATION_HOME_DIR = "APPLICATION_HOME_DIR";
    @NonNls
    public static final String APPLICATION_CONFIG_DIR = "APPLICATION_CONFIG_DIR";
    @NonNls
    public static final String APPLICATION_PLUGINS_DIR = "APPLICATION_PLUGINS_DIR";
    @NonNls
    public static final String USER_HOME_NAME = "USER_HOME";
    private static volatile Map<String, String> ourGlobalMacrosForIde;
    private static volatile Map<String, String> ourGlobalMacrosForStandalone;

    @Nullable
    public static String getModuleDir(@NotNull String moduleFilePath) {
        String moduleDir = PathUtilRt.getParentPath((String)moduleFilePath);
        if (Strings.isEmpty((String)moduleDir)) {
            return null;
        }
        String moduleDirParent = PathUtilRt.getParentPath((String)moduleDir);
        if (!Strings.isEmpty((String)moduleDirParent) && PathUtilRt.getFileName((String)moduleDir).equals(DIRECTORY_STORE_NAME)) {
            moduleDir = moduleDirParent;
        }
        if ((moduleDir = FileUtilRt.toSystemIndependentName((String)moduleDir)).endsWith(":/")) {
            moduleDir = moduleDir.substring(0, moduleDir.length() - 1);
        }
        return moduleDir;
    }

    @NotNull
    public static String getUserHomePath() {
        return Objects.requireNonNull(PathMacroUtil.getGlobalSystemMacroValue(USER_HOME_NAME));
    }

    @NotNull
    public static Map<String, String> getGlobalSystemMacros() {
        return PathMacroUtil.getGlobalSystemMacros(true);
    }

    @NotNull
    public static Map<String, String> getGlobalSystemMacros(boolean insideIde) {
        if (insideIde) {
            if (ourGlobalMacrosForIde == null) {
                ourGlobalMacrosForIde = PathMacroUtil.computeGlobalPathMacrosInsideIde();
            }
            return ourGlobalMacrosForIde;
        }
        if (ourGlobalMacrosForStandalone == null) {
            ourGlobalMacrosForStandalone = PathMacroUtil.computeGlobalPathMacrosForStandaloneCode();
        }
        return ourGlobalMacrosForStandalone;
    }

    private static Map<String, String> computeGlobalPathMacrosForStandaloneCode() {
        HashMap<String, String> result = new HashMap<String, String>();
        String homePath = PathManager.getHomePath((boolean)false);
        if (homePath != null) {
            result.put(APPLICATION_HOME_DIR, FileUtilRt.toSystemIndependentName((String)homePath));
            result.put(APPLICATION_CONFIG_DIR, FileUtilRt.toSystemIndependentName((String)PathManager.getConfigPath()));
            result.put(APPLICATION_PLUGINS_DIR, FileUtilRt.toSystemIndependentName((String)PathManager.getPluginsPath()));
        }
        result.put(USER_HOME_NAME, PathMacroUtil.computeUserHomePath());
        return Collections.unmodifiableMap(result);
    }

    private static Map<String, String> computeGlobalPathMacrosInsideIde() {
        return Map.of(APPLICATION_HOME_DIR, FileUtilRt.toSystemIndependentName((String)PathManager.getHomePath()), APPLICATION_CONFIG_DIR, FileUtilRt.toSystemIndependentName((String)PathManager.getConfigPath()), APPLICATION_PLUGINS_DIR, FileUtilRt.toSystemIndependentName((String)PathManager.getPluginsPath()), USER_HOME_NAME, PathMacroUtil.computeUserHomePath());
    }

    @NotNull
    private static String computeUserHomePath() {
        return Strings.trimEnd((String)FileUtilRt.toSystemIndependentName((String)SystemProperties.getUserHome()), (String)"/");
    }

    @Nullable
    public static String getGlobalSystemMacroValue(String name) {
        return PathMacroUtil.getGlobalSystemMacroValue(name, true);
    }

    @Nullable
    public static String getGlobalSystemMacroValue(String name, boolean insideIde) {
        return PathMacroUtil.getGlobalSystemMacros(insideIde).get(name);
    }
}

