/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JpsPathMapper;

public class JpsWslPathMapper
implements JpsPathMapper {
    private static final String WSL_PREFIX = "//wsl$/";
    @Nullable
    private String myWslRootPrefix;

    @Override
    @Nullable
    public String mapUrl(@Nullable String url) {
        int index;
        int startPos;
        int endPos;
        if (url == null) {
            return null;
        }
        if (url.contains(WSL_PREFIX) && (endPos = url.indexOf(47, (startPos = url.indexOf(WSL_PREFIX)) + WSL_PREFIX.length())) >= 0) {
            return url.substring(0, startPos) + url.substring(endPos);
        }
        if (url.startsWith("file://")) {
            return "file://" + this.mapPath(url.substring("file://".length()));
        }
        if (url.startsWith("jar://") && (index = url.indexOf("!/")) >= 0) {
            return "jar://" + this.mapPath(url.substring("jar://".length(), index)) + url.substring(index);
        }
        return url;
    }

    @NotNull
    private String mapPath(@NotNull String path) {
        if (this.myWslRootPrefix == null || path.indexOf(58) != 1) {
            String wslPath;
            try {
                wslPath = JpsWslPathMapper.runWslPath(path);
            }
            catch (IOException | InterruptedException e) {
                return path;
            }
            if (path.indexOf(58) == 1) {
                int pathLengthAfterDriveLetter = path.length() - 2;
                this.myWslRootPrefix = wslPath.substring(0, wslPath.length() - pathLengthAfterDriveLetter - 1);
            }
            return wslPath;
        }
        return this.myWslRootPrefix + Character.toLowerCase(path.charAt(0)) + FileUtil.toSystemIndependentName((String)path.substring(2));
    }

    private static String runWslPath(String path) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder("/usr/bin/wslpath", path);
        Process process = processBuilder.start();
        process.waitFor();
        if (process.exitValue() == 0) {
            return StreamUtil.readText((Reader)new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8)).trim();
        }
        return path;
    }
}

