/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpsMacroExpander {
    private final ExpandMacroToPathMap myExpandMacroMap = new ExpandMacroToPathMap();

    public JpsMacroExpander(Map<String, String> pathVariables) {
        for (Map.Entry<String, String> entry : pathVariables.entrySet()) {
            this.addMacro(entry.getKey(), entry.getValue());
        }
    }

    public void addFileHierarchyReplacements(String macroName, File file) {
        this.doAddFileHierarchyReplacements("$" + macroName + "$", file);
    }

    protected void addMacro(String macroName, String path) {
        this.myExpandMacroMap.addMacroExpand(macroName, path);
    }

    private void doAddFileHierarchyReplacements(String macro, @Nullable File file) {
        if (file == null) {
            return;
        }
        this.doAddFileHierarchyReplacements(macro + "/..", file.getParentFile());
        String path = FileUtil.toSystemIndependentName((String)file.getPath());
        if (StringUtil.endsWithChar((CharSequence)path, (char)'/')) {
            this.myExpandMacroMap.put(macro + "/", path);
            this.myExpandMacroMap.put(macro, path.substring(0, path.length() - 1));
        } else {
            this.myExpandMacroMap.put(macro, path);
        }
    }

    public void substitute(@NotNull Element element, boolean caseSensitive) {
        this.myExpandMacroMap.substitute(element, caseSensitive);
    }

    public ExpandMacroToPathMap getExpandMacroMap() {
        return this.myExpandMacroMap;
    }

    public String substitute(@NotNull String element, boolean caseSensitive) {
        return this.myExpandMacroMap.substitute(element, caseSensitive);
    }
}

