/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public class JpsEncodingModelSerializerExtension
extends JpsModelSerializerExtension {
    @Override
    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        return Collections.singletonList(new JpsEncodingConfigurationSerializer());
    }

    @Override
    @NotNull
    public List<? extends JpsGlobalExtensionSerializer> getGlobalExtensionSerializers() {
        return Collections.singletonList(new JpsGlobalEncodingSerializer());
    }

    private static final class JpsEncodingConfigurationSerializer
    extends JpsProjectExtensionSerializer {
        private JpsEncodingConfigurationSerializer() {
            super("encodings.xml", "Encoding");
        }

        @Override
        public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            String projectEncoding = null;
            HashMap<String, String> urlToEncoding = new HashMap<String, String>();
            for (Element fileTag : JDOMUtil.getChildren((Element)componentTag, (String)"file")) {
                String url = fileTag.getAttributeValue("url");
                String encoding = fileTag.getAttributeValue("charset");
                if (url.equals("PROJECT")) {
                    projectEncoding = encoding;
                    continue;
                }
                urlToEncoding.put(url, encoding);
            }
            JpsEncodingConfigurationService.getInstance().setEncodingConfiguration(project, projectEncoding, urlToEncoding);
        }
    }

    private static final class JpsGlobalEncodingSerializer
    extends JpsGlobalExtensionSerializer {
        public static final String ENCODING_ATTRIBUTE = "default_encoding";

        private JpsGlobalEncodingSerializer() {
            super("encoding.xml", "Encoding");
        }

        @Override
        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            String encoding = componentTag.getAttributeValue(ENCODING_ATTRIBUTE);
            JpsEncodingConfigurationService.getInstance().setGlobalEncoding(global, StringUtil.nullize((String)encoding));
        }

        @Override
        public void loadExtensionWithDefaultSettings(@NotNull JpsGlobal global) {
            JpsEncodingConfigurationService.getInstance().setGlobalEncoding(global, "UTF-8");
        }
    }
}

