/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.JDOMUtil;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JDomSerializationUtil {
    @NonNls
    public static final String COMPONENT_ELEMENT = "component";

    @Nullable
    public static Element findComponent(@Nullable Element root, @NonNls String componentName) {
        for (Element element : JDOMUtil.getChildren((Element)root, (String)COMPONENT_ELEMENT)) {
            if (!JDomSerializationUtil.isComponent(componentName, element)) continue;
            return element;
        }
        return null;
    }

    public static boolean isComponent(@NotNull String componentName, @NotNull Element element) {
        return componentName.equals(element.getAttributeValue("name"));
    }

    public static Element createComponentElement(String componentName) {
        Element element = new Element(COMPONENT_ELEMENT);
        element.setAttribute("name", componentName);
        return element;
    }

    @NotNull
    public static Element findOrCreateComponentElement(@NotNull Element root, @NotNull String componentName) {
        Element component = JDomSerializationUtil.findComponent(root, componentName);
        if (component == null) {
            component = JDomSerializationUtil.createComponentElement(componentName);
            JDomSerializationUtil.addComponent(root, component);
        }
        return component;
    }

    public static void addComponent(@NotNull Element root, @NotNull Element component) {
        String componentName = component.getAttributeValue("name");
        Element old = JDomSerializationUtil.findComponent(root, componentName);
        if (old != null) {
            root.removeContent((Content)old);
        }
        for (int i = 0; i < root.getContent().size(); ++i) {
            String name;
            Element element;
            Content o = (Content)root.getContent().get(i);
            if (!(o instanceof Element) || !(element = (Element)o).getName().equals(COMPONENT_ELEMENT) || componentName.compareTo(name = element.getAttributeValue("name")) >= 0) continue;
            root.addContent(i, (Content)component);
            return;
        }
        root.addContent(component);
    }
}

