/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public final class JpsModuleSourceRootImpl<P extends JpsElement>
extends JpsCompositeElementBase<JpsModuleSourceRootImpl<P>>
implements JpsTypedModuleSourceRoot<P> {
    private final JpsModuleSourceRootType<P> myRootType;
    private final String myUrl;

    public JpsModuleSourceRootImpl(String url, JpsModuleSourceRootType<P> type, P properties) {
        this.myRootType = type;
        this.myContainer.setChild(type.getPropertiesRole(), properties);
        this.myUrl = url;
    }

    private JpsModuleSourceRootImpl(JpsModuleSourceRootImpl<P> original) {
        super(original);
        this.myRootType = original.myRootType;
        this.myUrl = original.myUrl;
    }

    @Override
    public <P extends JpsElement> P getProperties(@NotNull JpsModuleSourceRootType<P> type) {
        if (this.myRootType.equals(type)) {
            return this.myContainer.getChild(this.myRootType.getPropertiesRole());
        }
        return null;
    }

    @Override
    @Nullable
    public <P extends JpsElement> P getProperties(@NotNull Set<? extends JpsModuleSourceRootType<P>> types) {
        if (types.contains(this.myRootType)) {
            return this.getProperties();
        }
        return null;
    }

    @Override
    @Nullable
    public <P extends JpsElement> JpsTypedModuleSourceRoot<P> asTyped(@NotNull JpsModuleSourceRootType<P> type) {
        return this.myRootType.equals(type) ? this : null;
    }

    @Override
    @NotNull
    public JpsTypedModuleSourceRoot<?> asTyped() {
        return this;
    }

    @Override
    public JpsElementType<?> getType() {
        return this.myRootType;
    }

    @Override
    @NotNull
    public P getProperties() {
        return this.myContainer.getChild(this.myRootType.getPropertiesRole());
    }

    @Override
    @NotNull
    public JpsModuleSourceRootType<P> getRootType() {
        return this.myRootType;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    @Override
    @NotNull
    public File getFile() {
        return JpsPathUtil.urlToFile(this.myUrl);
    }

    @Override
    @NotNull
    public Path getPath() {
        return Paths.get(JpsPathUtil.urlToPath(this.myUrl), new String[0]);
    }

    @Override
    @NotNull
    public JpsModuleSourceRootImpl<P> createCopy() {
        return new JpsModuleSourceRootImpl<P>(this);
    }
}

