/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import com.intellij.openapi.util.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.impl.JpsDependencyElementBase;

public class JpsLibraryDependencyImpl
extends JpsDependencyElementBase<JpsLibraryDependencyImpl>
implements JpsLibraryDependency {
    public static final JpsElementChildRole<JpsLibraryReference> LIBRARY_REFERENCE_CHILD_ROLE = JpsElementChildRoleBase.create("library reference");
    private volatile Ref<JpsLibrary> myCachedLibrary = null;

    public JpsLibraryDependencyImpl(JpsLibraryReference reference) {
        this.myContainer.setChild(LIBRARY_REFERENCE_CHILD_ROLE, reference);
    }

    public JpsLibraryDependencyImpl(JpsLibraryDependencyImpl original) {
        super(original);
    }

    @Override
    @NotNull
    public JpsLibraryReference getLibraryReference() {
        return this.myContainer.getChild(LIBRARY_REFERENCE_CHILD_ROLE);
    }

    @Override
    public JpsLibrary getLibrary() {
        Ref libRef = this.myCachedLibrary;
        if (libRef == null) {
            this.myCachedLibrary = libRef = new Ref((Object)((JpsLibrary)this.getLibraryReference().resolve()));
        }
        return (JpsLibrary)libRef.get();
    }

    @Override
    @NotNull
    public JpsLibraryDependencyImpl createCopy() {
        return new JpsLibraryDependencyImpl(this);
    }

    public String toString() {
        return "lib dep [" + this.getLibraryReference() + "]";
    }
}

