/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.impl.JpsLibraryDependencyImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleDependencyImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceDependencyImpl;
import org.jetbrains.jps.model.module.impl.JpsSdkDependencyImpl;

public class JpsDependenciesListImpl
extends JpsCompositeElementBase<JpsDependenciesListImpl>
implements JpsDependenciesList {
    public static final JpsElementCollectionRole<JpsDependencyElement> DEPENDENCY_COLLECTION_ROLE = JpsElementCollectionRole.create(JpsElementChildRoleBase.create("dependency"));

    public JpsDependenciesListImpl() {
        this.myContainer.setChild(DEPENDENCY_COLLECTION_ROLE);
    }

    private JpsDependenciesListImpl(JpsDependenciesListImpl original) {
        super(original);
    }

    @Override
    @NotNull
    public List<JpsDependencyElement> getDependencies() {
        return ((JpsElementCollection)((Object)this.myContainer.getChild(DEPENDENCY_COLLECTION_ROLE))).getElements();
    }

    @Override
    public void clear() {
        ((JpsElementCollection)((Object)this.myContainer.getChild(DEPENDENCY_COLLECTION_ROLE))).removeAllChildren();
    }

    @Override
    @NotNull
    public JpsModuleDependency addModuleDependency(@NotNull JpsModule module) {
        return this.addModuleDependency(module.createReference());
    }

    @Override
    @NotNull
    public JpsModuleDependency addModuleDependency(@NotNull JpsModuleReference moduleReference) {
        JpsModuleDependencyImpl dependency = new JpsModuleDependencyImpl(moduleReference);
        ((JpsElementCollection)((Object)this.myContainer.getChild(DEPENDENCY_COLLECTION_ROLE))).addChild(dependency);
        return dependency;
    }

    @Override
    @NotNull
    public JpsLibraryDependency addLibraryDependency(@NotNull JpsLibrary libraryElement) {
        return this.addLibraryDependency(libraryElement.createReference());
    }

    @Override
    @NotNull
    public JpsLibraryDependency addLibraryDependency(@NotNull JpsLibraryReference libraryReference) {
        JpsLibraryDependencyImpl dependency = new JpsLibraryDependencyImpl(libraryReference);
        ((JpsElementCollection)((Object)this.myContainer.getChild(DEPENDENCY_COLLECTION_ROLE))).addChild(dependency);
        return dependency;
    }

    @Override
    public void addModuleSourceDependency() {
        ((JpsElementCollection)((Object)this.myContainer.getChild(DEPENDENCY_COLLECTION_ROLE))).addChild(new JpsModuleSourceDependencyImpl());
    }

    @Override
    public void addSdkDependency(@NotNull JpsSdkType<?> sdkType) {
        ((JpsElementCollection)((Object)this.myContainer.getChild(DEPENDENCY_COLLECTION_ROLE))).addChild(new JpsSdkDependencyImpl(sdkType));
    }

    @Override
    @NotNull
    public JpsDependenciesListImpl createCopy() {
        return new JpsDependenciesListImpl(this);
    }

    @Override
    public JpsModuleImpl getParent() {
        return (JpsModuleImpl)super.getParent();
    }
}

