/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl.sdk;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.library.impl.JpsLibraryImpl;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;

public class JpsSdkImpl<P extends JpsElement>
extends JpsCompositeElementBase<JpsSdkImpl<P>>
implements JpsSdk<P> {
    private final JpsSdkType<P> mySdkType;
    private String myHomePath;
    private String myVersionString;

    public JpsSdkImpl(String homePath, String versionString, JpsSdkType<P> type, P properties) {
        this.myHomePath = homePath;
        this.myVersionString = versionString;
        this.mySdkType = type;
        this.myContainer.setChild(type.getSdkPropertiesRole(), properties);
    }

    private JpsSdkImpl(JpsSdkImpl<P> original) {
        super(original);
        this.mySdkType = original.mySdkType;
        this.myHomePath = original.myHomePath;
        this.myVersionString = original.myVersionString;
    }

    @Override
    @NotNull
    public JpsSdkImpl<P> createCopy() {
        return new JpsSdkImpl<P>(this);
    }

    @Override
    public P getSdkProperties() {
        return this.myContainer.getChild(this.mySdkType.getSdkPropertiesRole());
    }

    @Override
    public JpsSdkReference<P> createReference() {
        return JpsElementFactory.getInstance().createSdkReference(((JpsNamedCompositeElementBase)this.getParent()).getName(), this.mySdkType);
    }

    @Override
    public JpsSdkType<P> getSdkType() {
        return this.mySdkType;
    }

    @Override
    @NotNull
    public JpsLibraryImpl<JpsSdk<P>> getParent() {
        return (JpsLibraryImpl)super.getParent();
    }

    @Override
    public void applyChanges(@NotNull JpsSdkImpl<P> modified) {
        super.applyChanges(modified);
        this.setHomePath(modified.getHomePath());
        this.setVersionString(modified.getVersionString());
    }

    @Override
    public String getHomePath() {
        return this.myHomePath;
    }

    @Override
    public void setHomePath(String homePath) {
        if (!Objects.equals(this.myHomePath, homePath)) {
            this.myHomePath = homePath;
            this.fireElementChanged();
        }
    }

    @Override
    public String getVersionString() {
        return this.myVersionString;
    }

    @Override
    public void setVersionString(String versionString) {
        if (!Objects.equals(this.myVersionString, versionString)) {
            this.myVersionString = versionString;
            this.fireElementChanged();
        }
    }
}

