/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.CollectionFactory;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsReferenceableElement;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsElementCollectionImpl;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryReferenceImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootRole;
import org.jetbrains.jps.util.JpsPathUtil;

public final class JpsLibraryImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsLibraryImpl<P>>
implements JpsTypedLibrary<P> {
    private static final ConcurrentMap<JpsOrderRootType, JpsElementCollectionRole<JpsLibraryRoot>> ourRootRoles = new ConcurrentHashMap<JpsOrderRootType, JpsElementCollectionRole<JpsLibraryRoot>>();
    private final JpsLibraryType<P> myLibraryType;
    private static final Set<String> AR_EXTENSIONS = CollectionFactory.createFilePathSet(Arrays.asList("jar", "zip", "swc", "ane"));

    public JpsLibraryImpl(@NotNull String name, @NotNull JpsLibraryType<P> type, @NotNull P properties) {
        super(name);
        this.myLibraryType = type;
        this.myContainer.setChild(this.myLibraryType.getPropertiesRole(), properties);
    }

    private JpsLibraryImpl(@NotNull JpsLibraryImpl<P> original) {
        super(original);
        this.myLibraryType = original.myLibraryType;
    }

    @Override
    @NotNull
    public JpsLibraryType<P> getType() {
        return this.myLibraryType;
    }

    @Override
    @Nullable
    public <P extends JpsElement> JpsTypedLibrary<P> asTyped(@NotNull JpsLibraryType<P> type) {
        return this.myLibraryType.equals(type) ? this : null;
    }

    @Override
    @NotNull
    public P getProperties() {
        return this.myContainer.getChild(this.myLibraryType.getPropertiesRole());
    }

    @Override
    @NotNull
    public List<JpsLibraryRoot> getRoots(@NotNull JpsOrderRootType rootType) {
        JpsElementCollection rootsCollection = (JpsElementCollection)((Object)this.myContainer.getChild(JpsLibraryImpl.getRole(rootType)));
        return rootsCollection != null ? rootsCollection.getElements() : Collections.emptyList();
    }

    @Override
    public void addRoot(@NotNull String url, @NotNull JpsOrderRootType rootType) {
        this.addRoot(url, rootType, JpsLibraryRoot.InclusionOptions.ROOT_ITSELF);
    }

    @Override
    public void addRoot(@NotNull File file, @NotNull JpsOrderRootType rootType) {
        this.addRoot(JpsPathUtil.getLibraryRootUrl(file), rootType);
    }

    @Override
    public void addRoot(@NotNull String url, @NotNull JpsOrderRootType rootType, @NotNull JpsLibraryRoot.InclusionOptions options) {
        ((JpsElementCollection)this.myContainer.getOrSetChild(JpsLibraryImpl.getRole(rootType))).addChild(new JpsLibraryRootImpl(url, rootType, options));
    }

    @Override
    public void removeUrl(@NotNull String url, @NotNull JpsOrderRootType rootType) {
        JpsElementCollection rootsCollection = (JpsElementCollection)((Object)this.myContainer.getChild(JpsLibraryImpl.getRole(rootType)));
        if (rootsCollection != null) {
            for (JpsLibraryRoot root : rootsCollection.getElements()) {
                if (!root.getUrl().equals(url) || !root.getRootType().equals(rootType)) continue;
                rootsCollection.removeChild(root);
                break;
            }
        }
    }

    private static JpsElementCollectionRole<JpsLibraryRoot> getRole(JpsOrderRootType type) {
        JpsElementCollectionRole role = (JpsElementCollectionRole)ourRootRoles.get(type);
        if (role != null) {
            return role;
        }
        ourRootRoles.putIfAbsent(type, JpsElementCollectionRole.create(new JpsLibraryRootRole(type)));
        return (JpsElementCollectionRole)ourRootRoles.get(type);
    }

    @Override
    public void delete() {
        ((JpsElementCollectionImpl)this.getParent()).removeChild(this);
    }

    @Override
    public JpsElementCollectionImpl<JpsLibrary> getParent() {
        return (JpsElementCollectionImpl)this.myParent;
    }

    @Override
    @NotNull
    public JpsLibraryImpl<P> createCopy() {
        return new JpsLibraryImpl<P>(this);
    }

    @Override
    @NotNull
    public JpsLibraryReference createReference() {
        return new JpsLibraryReferenceImpl(this.getName(), this.createParentReference());
    }

    private JpsElementReference<JpsCompositeElement> createParentReference() {
        return ((JpsReferenceableElement)((Object)this.getParent().getParent())).createReference();
    }

    @Override
    public List<File> getFiles(JpsOrderRootType rootType) {
        List<String> urls = this.getRootUrls(rootType);
        ArrayList<File> files = new ArrayList<File>(urls.size());
        for (String url : urls) {
            if (JpsPathUtil.isJrtUrl(url)) continue;
            files.add(JpsPathUtil.urlToFile(url));
        }
        return files;
    }

    @Override
    @NotNull
    public List<Path> getPaths(@NotNull JpsOrderRootType rootType) {
        List<String> urls = this.getRootUrls(rootType);
        ArrayList<Path> result = new ArrayList<Path>(urls.size());
        for (String url : urls) {
            if (JpsPathUtil.isJrtUrl(url)) continue;
            result.add(Paths.get(JpsPathUtil.urlToPath(url), new String[0]));
        }
        return result;
    }

    @Override
    public List<String> getRootUrls(JpsOrderRootType rootType) {
        ArrayList<String> urls = new ArrayList<String>();
        for (JpsLibraryRoot root : this.getRoots(rootType)) {
            switch (root.getInclusionOptions()) {
                case ROOT_ITSELF: {
                    urls.add(root.getUrl());
                    break;
                }
                case ARCHIVES_UNDER_ROOT: {
                    JpsLibraryImpl.collectArchives(JpsPathUtil.urlToFile(root.getUrl()), false, urls);
                    break;
                }
                case ARCHIVES_UNDER_ROOT_RECURSIVELY: {
                    JpsLibraryImpl.collectArchives(JpsPathUtil.urlToFile(root.getUrl()), true, urls);
                }
            }
        }
        return urls;
    }

    private static void collectArchives(File file, boolean recursively, List<? super String> result) {
        Object[] children = file.listFiles();
        if (children != null) {
            Arrays.sort(children);
            for (Object child : children) {
                String extension = FileUtilRt.getExtension((String)((File)child).getName());
                if (((File)child).isDirectory()) {
                    if (!recursively) continue;
                    JpsLibraryImpl.collectArchives((File)child, recursively, result);
                    continue;
                }
                if (!AR_EXTENSIONS.contains(extension)) continue;
                result.add(JpsPathUtil.getLibraryRootUrl((File)child));
            }
        }
    }

    public String toString() {
        return "JpsLibraryImpl: " + this.getName();
    }
}

