/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryImpl;

public class JpsLibraryCollectionImpl
implements JpsLibraryCollection {
    private final JpsElementCollection<JpsLibrary> myCollection;

    public JpsLibraryCollectionImpl(JpsElementCollection<JpsLibrary> collection) {
        this.myCollection = collection;
    }

    @Override
    @NotNull
    public <P extends JpsElement, LibraryType extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addLibrary(@NotNull String name, @NotNull LibraryType type) {
        return this.addLibrary(name, type, (JpsElement)((JpsElementTypeWithDefaultProperties<P>)type).createDefaultProperties());
    }

    @Override
    @NotNull
    public <P extends JpsElement> JpsTypedLibrary<P> addLibrary(@NotNull String name, @NotNull JpsLibraryType<P> type, @NotNull P properties) {
        return this.myCollection.addChild(new JpsLibraryImpl<P>(name, type, properties));
    }

    @Override
    @NotNull
    public List<JpsLibrary> getLibraries() {
        return this.myCollection.getElements();
    }

    @Override
    @NotNull
    public <P extends JpsElement> Iterable<JpsTypedLibrary<P>> getLibraries(@NotNull JpsLibraryType<P> type) {
        return this.myCollection.getElementsOfType(type);
    }

    @Override
    public void addLibrary(@NotNull JpsLibrary library) {
        this.myCollection.addChild(library);
    }

    @Override
    public void removeLibrary(@NotNull JpsLibrary library) {
        this.myCollection.removeChild(library);
    }

    @Override
    public JpsLibrary findLibrary(@NotNull String name) {
        for (JpsLibrary library : this.getLibraries()) {
            if (!name.equals(library.getName())) continue;
            return library;
        }
        return null;
    }

    @Override
    @Nullable
    public <E extends JpsElement> JpsTypedLibrary<E> findLibrary(@NotNull String name, @NotNull JpsLibraryType<E> type) {
        for (JpsTypedLibrary<E> library : this.getLibraries(type)) {
            if (!name.equals(library.getName())) continue;
            return library;
        }
        return null;
    }
}

