/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpsMavenRepositoryLibraryDescriptor {
    public static final String DEFAULT_PACKAGING = "jar";
    private final String myMavenId;
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;
    private final String myPackaging;
    private final boolean myIncludeTransitiveDependencies;
    private final List<String> myExcludedDependencies;
    private final String myJarRepositoryId;
    private final List<ArtifactVerification> myArtifactsVerification;

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        this(groupId, artifactId, version, true, Collections.emptyList());
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, boolean includeTransitiveDependencies, @NotNull List<String> excludedDependencies) {
        this(groupId, artifactId, version, DEFAULT_PACKAGING, includeTransitiveDependencies, excludedDependencies);
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String packaging, boolean includeTransitiveDependencies, @NotNull List<String> excludedDependencies) {
        this(groupId, artifactId, version, packaging, includeTransitiveDependencies, excludedDependencies, Collections.emptyList());
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String packaging, boolean includeTransitiveDependencies, @NotNull List<String> excludedDependencies, @NotNull List<ArtifactVerification> metadata) {
        this(groupId, artifactId, version, packaging, includeTransitiveDependencies, excludedDependencies, metadata, null);
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String packaging, boolean includeTransitiveDependencies, @NotNull List<String> excludedDependencies, @NotNull List<ArtifactVerification> metadata, @Nullable String jarRepositoryId) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
        this.myPackaging = packaging;
        this.myIncludeTransitiveDependencies = includeTransitiveDependencies;
        this.myExcludedDependencies = excludedDependencies;
        this.myMavenId = groupId + ":" + artifactId + ":" + version;
        this.myArtifactsVerification = metadata;
        this.myJarRepositoryId = jarRepositoryId;
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId) {
        this(mavenId, true, Collections.emptyList());
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, boolean includeTransitiveDependencies) {
        this(groupId, artifactId, version, includeTransitiveDependencies, Collections.emptyList());
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId, boolean includeTransitiveDependencies, List<String> excludedDependencies) {
        this(mavenId, DEFAULT_PACKAGING, includeTransitiveDependencies, excludedDependencies);
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId, @NotNull String packaging, boolean includeTransitiveDependencies, List<String> excludedDependencies) {
        this(mavenId, packaging, includeTransitiveDependencies, excludedDependencies, Collections.emptyList(), null);
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId, boolean includeTransitiveDependencies, List<String> excludedDependencies, @NotNull List<ArtifactVerification> artifactsVerification, @Nullable String jarRepositoryId) {
        this(mavenId, DEFAULT_PACKAGING, includeTransitiveDependencies, excludedDependencies, artifactsVerification, jarRepositoryId);
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId, @NotNull String packaging, boolean includeTransitiveDependencies, List<String> excludedDependencies, @NotNull List<ArtifactVerification> artifactsVerification, @Nullable String jarRepositoryId) {
        this.myMavenId = mavenId;
        this.myIncludeTransitiveDependencies = includeTransitiveDependencies;
        this.myExcludedDependencies = excludedDependencies;
        this.myPackaging = packaging;
        this.myArtifactsVerification = artifactsVerification;
        this.myJarRepositoryId = jarRepositoryId;
        if (mavenId == null) {
            this.myVersion = null;
            this.myArtifactId = null;
            this.myGroupId = null;
        } else {
            String[] parts = mavenId.split(":");
            this.myGroupId = parts.length > 0 ? parts[0] : null;
            this.myArtifactId = parts.length > 1 ? parts[1] : null;
            this.myVersion = parts.length > 2 ? parts[2] : null;
        }
    }

    public String getMavenId() {
        return this.myMavenId;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public boolean isIncludeTransitiveDependencies() {
        return this.myIncludeTransitiveDependencies;
    }

    public List<String> getExcludedDependencies() {
        return this.myExcludedDependencies;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getPackaging() {
        return this.myPackaging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpsMavenRepositoryLibraryDescriptor that = (JpsMavenRepositoryLibraryDescriptor)o;
        return this.myIncludeTransitiveDependencies == that.myIncludeTransitiveDependencies && this.myMavenId.equals(that.myMavenId) && this.myPackaging.equals(that.myPackaging) && this.myExcludedDependencies.equals(that.myExcludedDependencies) && this.myArtifactsVerification.equals(that.myArtifactsVerification) && Objects.equals(this.myJarRepositoryId, that.myJarRepositoryId);
    }

    public int hashCode() {
        return Objects.hash(this.myMavenId, this.myPackaging, this.myIncludeTransitiveDependencies, this.myExcludedDependencies, this.myArtifactsVerification, this.myJarRepositoryId);
    }

    public String toString() {
        return this.myMavenId != null ? this.myMavenId : "null";
    }

    public List<ArtifactVerification> getArtifactsVerification() {
        return this.myArtifactsVerification;
    }

    public String getJarRepositoryId() {
        return this.myJarRepositoryId;
    }

    public static class ArtifactVerification {
        private final String url;
        private final String sha256sum;

        public ArtifactVerification(@NotNull String url, @NotNull String sha256sum) {
            this.url = url;
            this.sha256sum = sha256sum;
        }

        public String getSha256sum() {
            return this.sha256sum;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactVerification that = (ArtifactVerification)o;
            return Objects.equals(this.url, that.url) && Objects.equals(this.sha256sum, that.sha256sum);
        }

        public int hashCode() {
            return Objects.hash(this.url, this.sha256sum);
        }
    }
}

