/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl.compiler;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;

public final class ProcessorConfigProfileImpl
implements ProcessorConfigProfile {
    private String myName = "";
    private boolean myEnabled = false;
    private boolean myObtainProcessorsFromClasspath = true;
    private String myProcessorPath = "";
    private boolean myUseProcessorModulePath = false;
    private final Set<String> myProcessors = new LinkedHashSet<String>(1);
    private final Map<String, String> myProcessorOptions = new HashMap<String, String>(1);
    private String myGeneratedProductionDirectoryName = "generated";
    private String myGeneratedTestsDirectoryName = "generated_tests";
    private boolean myOutputRelativeToContentRoot = false;
    private boolean myIsProcOnly = false;
    private final Set<String> myModuleNames = new HashSet<String>(1);

    public ProcessorConfigProfileImpl(String name) {
        this.myName = name;
    }

    public ProcessorConfigProfileImpl(ProcessorConfigProfile profile) {
        this.initFrom(profile);
    }

    @Override
    public void initFrom(ProcessorConfigProfile other) {
        this.myName = other.getName();
        this.myEnabled = other.isEnabled();
        this.myIsProcOnly = other.isProcOnly();
        this.myObtainProcessorsFromClasspath = other.isObtainProcessorsFromClasspath();
        this.myProcessorPath = other.getProcessorPath();
        this.myUseProcessorModulePath = other.isUseProcessorModulePath();
        this.myProcessors.clear();
        this.myProcessors.addAll(other.getProcessors());
        this.myProcessorOptions.clear();
        this.myProcessorOptions.putAll(other.getProcessorOptions());
        this.myGeneratedProductionDirectoryName = other.getGeneratedSourcesDirectoryName(false);
        this.myGeneratedTestsDirectoryName = other.getGeneratedSourcesDirectoryName(true);
        this.myOutputRelativeToContentRoot = other.isOutputRelativeToContentRoot();
        this.myModuleNames.clear();
        this.myModuleNames.addAll(other.getModuleNames());
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    @NotNull
    public String getProcessorPath() {
        return this.myProcessorPath;
    }

    @Override
    public void setProcessorPath(@Nullable String processorPath) {
        this.myProcessorPath = processorPath != null ? processorPath : "";
    }

    @Override
    public void setUseProcessorModulePath(boolean useModulePath) {
        this.myUseProcessorModulePath = useModulePath;
    }

    @Override
    public boolean isUseProcessorModulePath() {
        return this.myUseProcessorModulePath;
    }

    @Override
    public boolean isObtainProcessorsFromClasspath() {
        return this.myObtainProcessorsFromClasspath;
    }

    @Override
    public void setObtainProcessorsFromClasspath(boolean value) {
        this.myObtainProcessorsFromClasspath = value;
    }

    @Override
    @NotNull
    public String getGeneratedSourcesDirectoryName(boolean forTests) {
        return forTests ? this.myGeneratedTestsDirectoryName : this.myGeneratedProductionDirectoryName;
    }

    @Override
    public void setGeneratedSourcesDirectoryName(@Nullable String name, boolean forTests) {
        if (forTests) {
            this.myGeneratedTestsDirectoryName = name != null ? name.trim() : "generated_tests";
        } else {
            this.myGeneratedProductionDirectoryName = name != null ? name.trim() : "generated";
        }
    }

    @Override
    public boolean isOutputRelativeToContentRoot() {
        return this.myOutputRelativeToContentRoot;
    }

    @Override
    public void setOutputRelativeToContentRoot(boolean relativeToContent) {
        this.myOutputRelativeToContentRoot = relativeToContent;
    }

    @Override
    public boolean isProcOnly() {
        return this.myIsProcOnly;
    }

    @Override
    public void setProcOnly(boolean value) {
        this.myIsProcOnly = value;
    }

    @Override
    @NotNull
    public Set<String> getModuleNames() {
        return this.myModuleNames;
    }

    @Override
    public boolean addModuleName(String name) {
        return this.myModuleNames.add(name);
    }

    @Override
    public boolean addModuleNames(Collection<String> names) {
        return this.myModuleNames.addAll(names);
    }

    @Override
    public boolean removeModuleName(String name) {
        return this.myModuleNames.remove(name);
    }

    @Override
    public boolean removeModuleNames(Collection<String> names) {
        return this.myModuleNames.removeAll(names);
    }

    @Override
    public void clearModuleNames() {
        this.myModuleNames.clear();
    }

    @Override
    public void clearProcessors() {
        this.myProcessors.clear();
    }

    @Override
    public boolean addProcessor(String processor) {
        return this.myProcessors.add(processor);
    }

    @Override
    public boolean removeProcessor(String processor) {
        return this.myProcessors.remove(processor);
    }

    @Override
    @NotNull
    public Set<String> getProcessors() {
        return Collections.unmodifiableSet(this.myProcessors);
    }

    @Override
    @NotNull
    public Map<String, String> getProcessorOptions() {
        return Collections.unmodifiableMap(this.myProcessorOptions);
    }

    @Override
    public String setOption(String key, String value) {
        return this.myProcessorOptions.put(key, value);
    }

    @Override
    @Nullable
    public String getOption(String key) {
        return this.myProcessorOptions.get(key);
    }

    @Override
    public void clearProcessorOptions() {
        this.myProcessorOptions.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorConfigProfileImpl profile = (ProcessorConfigProfileImpl)o;
        if (this.myEnabled != profile.myEnabled) {
            return false;
        }
        if (this.myIsProcOnly != profile.myIsProcOnly) {
            return false;
        }
        if (this.myObtainProcessorsFromClasspath != profile.myObtainProcessorsFromClasspath) {
            return false;
        }
        if (this.myGeneratedProductionDirectoryName != null ? !this.myGeneratedProductionDirectoryName.equals(profile.myGeneratedProductionDirectoryName) : profile.myGeneratedProductionDirectoryName != null) {
            return false;
        }
        if (this.myGeneratedTestsDirectoryName != null ? !this.myGeneratedTestsDirectoryName.equals(profile.myGeneratedTestsDirectoryName) : profile.myGeneratedTestsDirectoryName != null) {
            return false;
        }
        if (this.myOutputRelativeToContentRoot != profile.myOutputRelativeToContentRoot) {
            return false;
        }
        if (this.myUseProcessorModulePath != profile.myUseProcessorModulePath) {
            return false;
        }
        if (!this.myModuleNames.equals(profile.myModuleNames)) {
            return false;
        }
        if (!this.myProcessorOptions.equals(profile.myProcessorOptions)) {
            return false;
        }
        if (this.myProcessorPath != null ? !this.myProcessorPath.equals(profile.myProcessorPath) : profile.myProcessorPath != null) {
            return false;
        }
        if (!this.myProcessors.equals(profile.myProcessors)) {
            return false;
        }
        return this.myName.equals(profile.myName);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (this.myEnabled ? 1 : 0);
        result = 31 * result + (this.myIsProcOnly ? 1 : 0);
        result = 31 * result + (this.myObtainProcessorsFromClasspath ? 1 : 0);
        result = 31 * result + (this.myProcessorPath != null ? this.myProcessorPath.hashCode() : 0);
        result = 31 * result + this.myProcessors.hashCode();
        result = 31 * result + this.myProcessorOptions.hashCode();
        result = 31 * result + (this.myGeneratedProductionDirectoryName != null ? this.myGeneratedProductionDirectoryName.hashCode() : 0);
        result = 31 * result + (this.myGeneratedTestsDirectoryName != null ? this.myGeneratedTestsDirectoryName.hashCode() : 0);
        result = 31 * result + (this.myOutputRelativeToContentRoot ? 1 : 0);
        result = 31 * result + (this.myUseProcessorModulePath ? 1 : 0);
        result = 31 * result + this.myModuleNames.hashCode();
        return result;
    }

    public String toString() {
        return this.myName;
    }
}

