/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.system.CpuArch;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.service.JpsServiceManager;

public abstract class JdkVersionDetector {
    public static JdkVersionDetector getInstance() {
        return JpsServiceManager.getInstance().getService(JdkVersionDetector.class);
    }

    @Nullable
    public abstract JdkVersionInfo detectJdkVersionInfo(@NotNull String var1);

    @Nullable
    public abstract JdkVersionInfo detectJdkVersionInfo(@NotNull String var1, @NotNull ExecutorService var2);

    @NotNull
    public static String formatVersionString(@NotNull JavaVersion version) {
        return "java version \"" + version + "\"";
    }

    public static boolean isVersionString(@NotNull String string) {
        return string.length() >= 16 && string.startsWith("java version \"") && StringUtil.endsWithChar((CharSequence)string, (char)'\"');
    }

    public static final class JdkVersionInfo {
        public final JavaVersion version;
        public final Variant variant;
        public final CpuArch arch;

        public JdkVersionInfo(@NotNull JavaVersion version, @Nullable Variant variant, @NotNull CpuArch arch) {
            this.version = version;
            this.variant = variant != null ? variant : Variant.Unknown;
            this.arch = arch;
        }

        @NotNull
        public String suggestedName() {
            String f = this.version.toFeatureString();
            return this.variant.prefix != null ? this.variant.prefix + "-" + f : f;
        }

        @NotNull
        public String displayVersionString() {
            String s = "version " + this.version;
            return this.variant.displayName != null ? this.variant.displayName + " " + s : s;
        }

        public String toString() {
            return this.version + " " + this.arch;
        }
    }

    public static enum Variant {
        AdoptOpenJdk_HS("adopt", "AdoptOpenJDK (HotSpot)"),
        AdoptOpenJdk_J9("adopt-j9", "AdoptOpenJDK (OpenJ9)"),
        Temurin("temurin", "Eclipse Temurin"),
        Semeru("semeru", "IBM Semeru"),
        Corretto("corretto", "Amazon Corretto"),
        GraalVM("graalvm", "GraalVM"),
        IBM("ibm", "IBM JDK"),
        JBR("jbr", "JetBrains Runtime"),
        Liberica("liberica", "BellSoft Liberica"),
        Oracle(null, "Oracle OpenJDK"),
        SapMachine("sap", "SAP SapMachine"),
        Zulu("zulu", "Azul Zulu"),
        Unknown(null, null);

        @Nullable
        public final String prefix;
        @Nullable
        public final String displayName;

        private Variant(String prefix, String displayName) {
            this.prefix = prefix;
            this.displayName = displayName;
        }
    }
}

