/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.impl.JpsGlobalImpl;
import org.jetbrains.jps.model.impl.JpsProjectImpl;

public final class JpsModelImpl
implements JpsModel {
    private final JpsProjectImpl myProject;
    private final JpsGlobalImpl myGlobal;
    private JpsModelImpl myOriginalModel;

    public JpsModelImpl(JpsEventDispatcher eventDispatcher) {
        this.myProject = new JpsProjectImpl(this, eventDispatcher);
        this.myGlobal = new JpsGlobalImpl(this, eventDispatcher);
    }

    private JpsModelImpl(JpsModelImpl original, JpsEventDispatcher eventDispatcher) {
        this.myOriginalModel = original;
        this.myProject = new JpsProjectImpl(original.myProject, (JpsModel)this, eventDispatcher);
        this.myGlobal = new JpsGlobalImpl(original.myGlobal, (JpsModel)this, eventDispatcher);
    }

    @Override
    @NotNull
    public JpsProjectImpl getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public JpsGlobalImpl getGlobal() {
        return this.myGlobal;
    }

    @Override
    @NotNull
    public JpsModel createModifiableModel(@NotNull JpsEventDispatcher eventDispatcher) {
        return new JpsModelImpl(this, eventDispatcher);
    }

    @Override
    public void registerExternalReference(@NotNull JpsElementReference<?> reference) {
        this.myProject.addExternalReference(reference);
    }

    @Override
    public void commit() {
        this.myOriginalModel.applyChanges(this);
    }

    private void applyChanges(@NotNull JpsModelImpl modifiedCopy) {
        this.myProject.applyChanges(modifiedCopy.myProject);
        this.myGlobal.applyChanges(modifiedCopy.myGlobal);
    }
}

