/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.ex;

import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsNamedElement;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;

public abstract class JpsNamedCompositeElementBase<Self extends JpsNamedCompositeElementBase<Self>>
extends JpsCompositeElementBase<Self>
implements JpsNamedElement {
    @NlsSafe
    private String myName;

    protected JpsNamedCompositeElementBase(@NlsSafe @NotNull String name) {
        this.myName = name;
    }

    protected JpsNamedCompositeElementBase(JpsNamedCompositeElementBase<Self> original) {
        super(original);
        this.myName = original.myName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    public void applyChanges(@NotNull Self modified) {
        super.applyChanges(modified);
        this.setName(((JpsNamedCompositeElementBase)modified).getName());
    }

    @Override
    public void setName(@NlsSafe @NotNull String name) {
        if (!this.myName.equals(name)) {
            String oldName = this.myName;
            this.myName = name;
            JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
            if (eventDispatcher != null) {
                eventDispatcher.fireElementRenamed(this, oldName, name);
            }
        }
    }
}

