/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.artifact.impl.elements;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.artifact.JpsArtifactReference;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsExtractedDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsFileCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsLibraryFilesPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElementFactory;
import org.jetbrains.jps.model.artifact.impl.elements.JpsArchivePackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsArtifactOutputPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsArtifactRootElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsDirectoryCopyPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsDirectoryPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsExtractedDirectoryPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsFileCopyPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsLibraryFilesPackagingElementImpl;
import org.jetbrains.jps.model.library.JpsLibraryReference;

public class JpsPackagingElementFactoryImpl
extends JpsPackagingElementFactory {
    @Override
    @NotNull
    public JpsDirectoryCopyPackagingElement createDirectoryCopy(@NotNull String directoryPath) {
        return new JpsDirectoryCopyPackagingElementImpl(directoryPath);
    }

    @Override
    public JpsPackagingElement createParentDirectories(String relativeOutputPath, JpsPackagingElement element) {
        if ((relativeOutputPath = StringUtil.trimStart((String)relativeOutputPath, (String)"/")).length() == 0) {
            return element;
        }
        int slash = relativeOutputPath.indexOf(47);
        if (slash == -1) {
            slash = relativeOutputPath.length();
        }
        String rootName = relativeOutputPath.substring(0, slash);
        String pathTail = relativeOutputPath.substring(slash);
        JpsDirectoryPackagingElement root = this.createDirectory(rootName);
        JpsCompositePackagingElement last = this.getOrCreateDirectoryOrArchive(root, pathTail, true);
        last.addChild(element);
        return root;
    }

    @Override
    public JpsCompositePackagingElement getOrCreateDirectory(@NotNull JpsCompositePackagingElement root, @NotNull String path) {
        return this.getOrCreateDirectoryOrArchive(root, path, true);
    }

    @Override
    public JpsCompositePackagingElement getOrCreateArchive(@NotNull JpsCompositePackagingElement root, @NotNull String path) {
        return this.getOrCreateDirectoryOrArchive(root, path, false);
    }

    @NotNull
    private JpsCompositePackagingElement getOrCreateDirectoryOrArchive(@NotNull JpsCompositePackagingElement root, @NotNull @NonNls String path, boolean directory) {
        if ((path = StringUtil.trimStart((String)StringUtil.trimEnd((String)path, (String)"/"), (String)"/")).length() == 0) {
            return root;
        }
        int index = path.lastIndexOf(47);
        String lastName = path.substring(index + 1);
        String parentPath = index != -1 ? path.substring(0, index) : "";
        JpsCompositePackagingElement parent = this.getOrCreateDirectoryOrArchive(root, parentPath, true);
        JpsCompositePackagingElement last = directory ? this.createDirectory(lastName) : this.createArchive(lastName);
        return parent.addChild(last);
    }

    @Override
    @NotNull
    public JpsFileCopyPackagingElement createFileCopy(@NotNull String filePath, @Nullable String outputFileName) {
        return new JpsFileCopyPackagingElementImpl(filePath, outputFileName);
    }

    @Override
    @NotNull
    public JpsExtractedDirectoryPackagingElement createExtractedDirectory(@NotNull String jarPath, @NotNull String pathInJar) {
        return new JpsExtractedDirectoryPackagingElementImpl(jarPath, pathInJar);
    }

    @Override
    @NotNull
    public JpsDirectoryPackagingElement createDirectory(@NotNull String directoryName) {
        return new JpsDirectoryPackagingElementImpl(directoryName);
    }

    @Override
    @NotNull
    public JpsArchivePackagingElement createArchive(@NotNull String archiveName) {
        return new JpsArchivePackagingElementImpl(archiveName);
    }

    @Override
    @NotNull
    public JpsArtifactRootElement createArtifactRoot() {
        return new JpsArtifactRootElementImpl();
    }

    @Override
    @NotNull
    public JpsLibraryFilesPackagingElement createLibraryElement(@NotNull JpsLibraryReference reference) {
        return new JpsLibraryFilesPackagingElementImpl(reference);
    }

    @Override
    @NotNull
    public JpsArtifactOutputPackagingElement createArtifactOutput(@NotNull JpsArtifactReference reference) {
        return new JpsArtifactOutputPackagingElementImpl(reference);
    }
}

