/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.artifact.impl;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactType;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.impl.JpsArtifactReferenceImpl;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;

public class JpsArtifactImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsArtifactImpl<P>>
implements JpsArtifact {
    private static final JpsElementChildRole<JpsCompositePackagingElement> ROOT_ELEMENT_CHILD_ROLE = JpsElementChildRoleBase.create("root element");
    private final JpsArtifactType<P> myArtifactType;
    private String myOutputPath;
    private boolean myBuildOnMake;

    public JpsArtifactImpl(@NotNull String name, @NotNull JpsCompositePackagingElement rootElement, @NotNull JpsArtifactType<P> type, @NotNull P properties) {
        super(name);
        this.myArtifactType = type;
        this.myContainer.setChild(ROOT_ELEMENT_CHILD_ROLE, rootElement);
        this.myContainer.setChild(type.getPropertiesRole(), properties);
    }

    private JpsArtifactImpl(JpsArtifactImpl<P> original) {
        super(original);
        this.myArtifactType = original.myArtifactType;
        this.myOutputPath = original.myOutputPath;
    }

    @Override
    @NotNull
    public JpsArtifactImpl<P> createCopy() {
        return new JpsArtifactImpl<P>(this);
    }

    @Override
    public String getOutputPath() {
        return this.myOutputPath;
    }

    @Override
    public void setOutputPath(@Nullable String outputPath) {
        if (!Objects.equals(this.myOutputPath, outputPath)) {
            this.myOutputPath = outputPath;
            this.fireElementChanged();
        }
    }

    @Override
    @Nullable
    public String getOutputFilePath() {
        if (StringUtil.isEmpty((String)this.myOutputPath)) {
            return null;
        }
        JpsCompositePackagingElement root = this.getRootElement();
        return root instanceof JpsArchivePackagingElement ? this.myOutputPath + "/" + ((JpsArchivePackagingElement)root).getArchiveName() : this.myOutputPath;
    }

    @NotNull
    public JpsArtifactType<P> getArtifactType() {
        return this.myArtifactType;
    }

    @Override
    @NotNull
    public JpsArtifactReferenceImpl createReference() {
        return new JpsArtifactReferenceImpl(this.getName());
    }

    @Override
    @NotNull
    public JpsCompositePackagingElement getRootElement() {
        return this.myContainer.getChild(ROOT_ELEMENT_CHILD_ROLE);
    }

    @Override
    public void setRootElement(@NotNull JpsCompositePackagingElement rootElement) {
        this.myContainer.setChild(ROOT_ELEMENT_CHILD_ROLE, rootElement);
    }

    public P getProperties() {
        return this.myContainer.getChild(this.myArtifactType.getPropertiesRole());
    }

    @Override
    public boolean isBuildOnMake() {
        return this.myBuildOnMake;
    }

    @Override
    public void setBuildOnMake(boolean buildOnMake) {
        if (this.myBuildOnMake != buildOnMake) {
            this.myBuildOnMake = buildOnMake;
            this.fireElementChanged();
        }
    }
}

