/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.util.text.StringUtilRt;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public final class IgnoredPatternSet {
    private final Set<String> masks;
    private final FileTypeAssocTable<Boolean> ignorePatterns = new FileTypeAssocTable();

    public IgnoredPatternSet() {
        this.masks = new LinkedHashSet<String>();
    }

    IgnoredPatternSet(@NotNull List<String> masks) {
        FileNameMatcherFactory fileNameMatcherFactory = null;
        this.masks = new LinkedHashSet<String>(masks.size());
        for (String ignoredFile : masks) {
            if (this.ignorePatterns.findAssociatedFileType(ignoredFile) != null) continue;
            this.masks.add(ignoredFile);
            if (fileNameMatcherFactory == null) {
                fileNameMatcherFactory = FileNameMatcherFactory.getInstance();
            }
            this.ignorePatterns.addAssociation(fileNameMatcherFactory.createMatcher(ignoredFile), Boolean.TRUE);
        }
    }

    @NotNull
    Set<String> getIgnoreMasks() {
        return Collections.unmodifiableSet(this.masks);
    }

    public void setIgnoreMasks(@NotNull String list) {
        this.clearPatterns();
        StringTokenizer tokenizer = new StringTokenizer(list, ";");
        while (tokenizer.hasMoreTokens()) {
            this.addIgnoreMask(tokenizer.nextToken());
        }
    }

    void addIgnoreMask(@NotNull String ignoredFile) {
        if (this.ignorePatterns.findAssociatedFileType(ignoredFile) == null) {
            this.masks.add(ignoredFile);
            this.ignorePatterns.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(ignoredFile), Boolean.TRUE);
        }
    }

    public boolean isIgnored(@NotNull CharSequence fileName) {
        if (this.ignorePatterns.findAssociatedFileType(fileName) == Boolean.TRUE) {
            return true;
        }
        return StringUtilRt.endsWith((CharSequence)fileName, (CharSequence)".__del__");
    }

    void clearPatterns() {
        this.masks.clear();
        this.ignorePatterns.removeAllAssociations(Boolean.TRUE);
    }
}

