/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class FileTypeAssocTable<T> {
    private final Map<CharSequence, T> myExtensionMappings;
    private final Map<CharSequence, T> myExactFileNameMappings;
    private final Map<CharSequence, T> myExactFileNameAnyCaseMappings;
    private final List<Pair<FileNameMatcher, T>> myMatchingMappings;
    private final ConcurrentCharSequenceMapBuilder<T> myConcurrentCharSequenceMapBuilder;
    private final Map<String, T> myHashBangMap;

    private FileTypeAssocTable(@NotNull Map<? extends CharSequence, ? extends T> extensionMappings, @NotNull Map<? extends CharSequence, ? extends T> exactFileNameMappings, @NotNull Map<? extends CharSequence, ? extends T> exactFileNameAnyCaseMappings, @NotNull ConcurrentCharSequenceMapBuilder<T> concurrentCharSequenceMapBuilder, @NotNull Map<? extends String, ? extends T> hashBangMap, @NotNull List<? extends Pair<FileNameMatcher, T>> matchingMappings) {
        this.myExtensionMappings = concurrentCharSequenceMapBuilder.build(extensionMappings, false);
        this.myExactFileNameMappings = concurrentCharSequenceMapBuilder.build(exactFileNameMappings, true);
        this.myExactFileNameAnyCaseMappings = concurrentCharSequenceMapBuilder.build(exactFileNameAnyCaseMappings, false);
        this.myConcurrentCharSequenceMapBuilder = concurrentCharSequenceMapBuilder;
        this.myHashBangMap = new ConcurrentHashMap<String, T>(hashBangMap);
        this.myMatchingMappings = new CopyOnWriteArrayList<Pair<FileNameMatcher, T>>(matchingMappings);
    }

    public FileTypeAssocTable(@NotNull ConcurrentCharSequenceMapBuilder<T> concurrentCharSequenceMapBuilder) {
        this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), concurrentCharSequenceMapBuilder, Collections.emptyMap(), Collections.emptyList());
    }

    public FileTypeAssocTable() {
        this(FileTypeAssocTable::createCharSequenceConcurrentMap);
    }

    boolean isAssociatedWith(@NotNull T type, @NotNull FileNameMatcher matcher) {
        if (matcher instanceof ExtensionFileNameMatcher || matcher instanceof ExactFileNameMatcher) {
            return type.equals(this.findAssociatedFileType(matcher));
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst()) || !type.equals(mapping.getSecond())) continue;
            return true;
        }
        return false;
    }

    public T addAssociation(@NotNull FileNameMatcher matcher, @NotNull T type) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            String extension = ((ExtensionFileNameMatcher)matcher).getExtension();
            return this.myExtensionMappings.put(extension, type);
        }
        if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            Map<CharSequence, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            return mapToUse.put(exactFileNameMatcher.getFileName(), type);
        }
        int i = ContainerUtil.indexOf(this.myMatchingMappings, p -> ((FileNameMatcher)p.first).equals(matcher));
        if (i == -1) {
            this.myMatchingMappings.add(Pair.create((Object)matcher, type));
            return null;
        }
        Pair<FileNameMatcher, T> old = this.myMatchingMappings.get(i);
        this.myMatchingMappings.set(i, Pair.create((Object)matcher, type));
        return (T)Pair.getSecond(old);
    }

    void addHashBangPattern(@NotNull String hashBang, @NotNull T type) {
        this.myHashBangMap.put(hashBang, type);
    }

    void removeHashBangPattern(@NotNull String hashBang, @NotNull T type) {
        this.myHashBangMap.remove(hashBang, type);
    }

    void removeAssociation(@NotNull FileNameMatcher matcher, @NotNull T type) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            String extension = ((ExtensionFileNameMatcher)matcher).getExtension();
            if (type.equals(this.myExtensionMappings.get(extension))) {
                this.myExtensionMappings.remove(extension);
            }
            return;
        }
        if (matcher instanceof ExactFileNameMatcher) {
            Map<CharSequence, T> mapToUse;
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            String fileName = exactFileNameMatcher.getFileName();
            Map<CharSequence, T> map = mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            if (type.equals(mapToUse.get(fileName))) {
                mapToUse.remove(fileName);
            }
            return;
        }
        this.myMatchingMappings.removeIf(assoc -> matcher.equals(assoc.getFirst()));
    }

    void removeAllAssociations(@NotNull T type) {
        this.removeAllAssociations(bean -> bean.equals(type));
    }

    @Nullable
    public T findAssociatedFileType(@NotNull @NonNls CharSequence fileName) {
        T t;
        if (!this.myExactFileNameMappings.isEmpty() && (t = this.myExactFileNameMappings.get(fileName)) != null) {
            return t;
        }
        if (!this.myExactFileNameAnyCaseMappings.isEmpty() && (t = this.myExactFileNameAnyCaseMappings.get(fileName)) != null) {
            return t;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!((FileNameMatcher)mapping.getFirst()).acceptsCharSequence(fileName)) continue;
            return (T)mapping.getSecond();
        }
        return this.findByExtension(FileUtilRt.getExtension((CharSequence)fileName));
    }

    @Nullable
    T findAssociatedFileTypeByHashBang(@NotNull CharSequence content) {
        for (Map.Entry<String, T> entry : this.myHashBangMap.entrySet()) {
            String hashBang = entry.getKey();
            if (!FileUtil.isHashBangLine((CharSequence)content, (String)hashBang)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    T findAssociatedFileType(@NotNull FileNameMatcher matcher) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            return this.findByExtension(((ExtensionFileNameMatcher)matcher).getExtension());
        }
        if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            Map<CharSequence, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            return mapToUse.get(exactFileNameMatcher.getFileName());
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst())) continue;
            return (T)mapping.getSecond();
        }
        return null;
    }

    T findByExtension(@NotNull CharSequence extension) {
        return this.myExtensionMappings.get(extension);
    }

    String @NotNull [] getAssociatedExtensions(@NotNull T type) {
        ArrayList<String> extensions = new ArrayList<String>();
        for (Map.Entry<CharSequence, T> entry : this.myExtensionMappings.entrySet()) {
            if (!type.equals(entry.getValue())) continue;
            extensions.add(entry.getKey().toString());
        }
        return ArrayUtilRt.toStringArray(extensions);
    }

    @NotNull
    public FileTypeAssocTable<T> copy() {
        return new FileTypeAssocTable<T>(this.myExtensionMappings, this.myExactFileNameMappings, this.myExactFileNameAnyCaseMappings, this.myConcurrentCharSequenceMapBuilder, this.myHashBangMap, this.myMatchingMappings);
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull T type) {
        ArrayList<FileNameMatcher> result = new ArrayList<FileNameMatcher>();
        for (Pair<FileNameMatcher, T> pair : this.myMatchingMappings) {
            if (!type.equals(pair.getSecond())) continue;
            result.add((FileNameMatcher)pair.getFirst());
        }
        for (Map.Entry entry : this.myExactFileNameMappings.entrySet()) {
            if (!type.equals(entry.getValue())) continue;
            result.add(new ExactFileNameMatcher(((CharSequence)entry.getKey()).toString(), false));
        }
        for (Map.Entry entry : this.myExactFileNameAnyCaseMappings.entrySet()) {
            if (!type.equals(entry.getValue())) continue;
            result.add(new ExactFileNameMatcher(((CharSequence)entry.getKey()).toString(), true));
        }
        for (Map.Entry entry : this.myExtensionMappings.entrySet()) {
            if (!type.equals(entry.getValue())) continue;
            result.add(new ExtensionFileNameMatcher(((CharSequence)entry.getKey()).toString()));
        }
        return result;
    }

    @NotNull
    public List<String> getHashBangPatterns(@NotNull T type) {
        return this.myHashBangMap.entrySet().stream().filter(e -> e.getValue().equals(type)).map(e -> (String)e.getKey()).collect(Collectors.toList());
    }

    boolean hasAssociationsFor(@NotNull T fileType) {
        if (this.myExtensionMappings.containsValue(fileType) || this.myExactFileNameMappings.containsValue(fileType) || this.myHashBangMap.containsValue(fileType) || this.myExactFileNameAnyCaseMappings.containsValue(fileType)) {
            return true;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!fileType.equals(mapping.getSecond())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    Map<FileNameMatcher, T> getRemovedMappings(@NotNull FileTypeAssocTable<T> newTable, @NotNull Collection<? extends T> keys) {
        HashMap<FileNameMatcher, T> map = new HashMap<FileNameMatcher, T>();
        for (T key : keys) {
            List<FileNameMatcher> associations = this.getAssociations(key);
            associations.removeAll(newTable.getAssociations(key));
            for (FileNameMatcher matcher : associations) {
                map.put(matcher, key);
            }
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTypeAssocTable that = (FileTypeAssocTable)o;
        return this.myExtensionMappings.equals(that.myExtensionMappings) && this.myMatchingMappings.equals(that.myMatchingMappings) && this.myExactFileNameMappings.equals(that.myExactFileNameMappings) && this.myHashBangMap.equals(that.myHashBangMap) && this.myExactFileNameAnyCaseMappings.equals(that.myExactFileNameAnyCaseMappings);
    }

    public int hashCode() {
        int result = this.myExtensionMappings.hashCode();
        result = 31 * result + this.myMatchingMappings.hashCode();
        result = 31 * result + this.myHashBangMap.hashCode();
        result = 31 * result + this.myExactFileNameMappings.hashCode();
        result = 31 * result + this.myExactFileNameAnyCaseMappings.hashCode();
        return result;
    }

    @NotNull
    Map<String, T> getInternalRawHashBangPatterns() {
        return CollectionFactory.createSmallMemoryFootprintMap(this.myHashBangMap);
    }

    @NotNull
    private static <T> Map<CharSequence, T> createCharSequenceConcurrentMap(@NotNull Map<? extends CharSequence, ? extends T> source, boolean caseSensetive) {
        Map map = CollectionFactory.createCharSequenceMap((boolean)caseSensetive, (int)source.size(), (float)0.5f);
        map.putAll(source);
        return Collections.synchronizedMap(map);
    }

    void removeAllAssociations(@NotNull Predicate<? super T> predicate) {
        this.myExtensionMappings.entrySet().removeIf(entry -> predicate.test((Object)entry.getValue()));
        this.myExactFileNameMappings.entrySet().removeIf(entry -> predicate.test((Object)entry.getValue()));
        this.myExactFileNameAnyCaseMappings.entrySet().removeIf(entry -> predicate.test((Object)entry.getValue()));
        this.myMatchingMappings.removeIf(entry -> predicate.test(entry.getSecond()));
        this.myHashBangMap.entrySet().removeIf(entry -> predicate.test((Object)entry.getValue()));
    }

    public String toString() {
        return "FileTypeAssocTable. myExtensionMappings=" + this.myExtensionMappings + ";\nmyExactFileNameMappings=" + this.myExactFileNameMappings + ";\nmyExactFileNameAnyCaseMappings=" + this.myExactFileNameAnyCaseMappings + ";\nmyMatchingMappings=" + this.myMatchingMappings + ";\nmyHashBangMap=" + this.myHashBangMap + ";";
    }

    @TestOnly
    public void clear() {
        this.myHashBangMap.clear();
        this.myMatchingMappings.clear();
        this.myExtensionMappings.clear();
        this.myExactFileNameMappings.clear();
        this.myExactFileNameAnyCaseMappings.clear();
    }

    void removeAssociationsForFile(@NotNull CharSequence fileName, @NotNull T association) {
        T t = this.myExactFileNameMappings.get(fileName);
        if (association.equals(t)) {
            this.myExactFileNameMappings.remove(fileName);
        }
        if (association.equals(t = this.myExactFileNameAnyCaseMappings.get(fileName))) {
            this.myExactFileNameAnyCaseMappings.remove(fileName);
        }
        this.myMatchingMappings.removeIf(pair -> association.equals(pair.second) && ((FileNameMatcher)pair.getFirst()).acceptsCharSequence(fileName));
        CharSequence extension = FileUtilRt.getExtension((CharSequence)fileName);
        t = this.myExtensionMappings.get(extension);
        if (association.equals(t)) {
            this.myExtensionMappings.remove(extension);
        }
    }

    @FunctionalInterface
    public static interface ConcurrentCharSequenceMapBuilder<T> {
        @NotNull
        public Map<CharSequence, T> build(@NotNull Map<? extends CharSequence, ? extends T> var1, boolean var2);
    }
}

