/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.PatternUtil;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class WildcardFileNameMatcher
implements FileNameMatcher {
    private final String myPattern;
    private final MaskMatcher myMatcher;

    public WildcardFileNameMatcher(@NotNull String pattern) {
        this.myPattern = pattern;
        this.myMatcher = WildcardFileNameMatcher.createMatcher(pattern);
    }

    @NotNull
    private static MaskMatcher createMatcher(@NotNull String pattern) {
        int len = pattern.length();
        if (len > 1 && pattern.indexOf(63) < 0) {
            if (pattern.charAt(0) == '*' && pattern.indexOf(42, 1) < 0) {
                return new SuffixMatcher(pattern.substring(1));
            }
            if (pattern.indexOf(42) == len - 1) {
                return new PrefixMatcher(pattern.substring(0, len - 1));
            }
            if (len > 2 && pattern.charAt(0) == '*' && pattern.indexOf(42, 1) == len - 1) {
                return new InfixMatcher(pattern.substring(1, len - 1));
            }
        }
        return new RegexpMatcher(pattern);
    }

    @Override
    public boolean acceptsCharSequence(@NotNull CharSequence fileName) {
        return this.myMatcher.matches(fileName);
    }

    @Override
    @NotNull
    public String getPresentableString() {
        return this.myPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildcardFileNameMatcher that = (WildcardFileNameMatcher)o;
        return this.myPattern.equals(that.myPattern);
    }

    public int hashCode() {
        return this.myPattern.hashCode();
    }

    @NotNull
    public String getPattern() {
        return this.myPattern;
    }

    public String toString() {
        return this.myPattern;
    }

    private static interface MaskMatcher {
        public boolean matches(@NotNull CharSequence var1);
    }

    private static final class SuffixMatcher
    implements MaskMatcher {
        private final String mySuffix;

        SuffixMatcher(@NotNull String suffix) {
            this.mySuffix = suffix;
        }

        @Override
        public boolean matches(@NotNull CharSequence filename) {
            return Strings.endsWith((CharSequence)filename, (CharSequence)this.mySuffix);
        }
    }

    private static final class PrefixMatcher
    implements MaskMatcher {
        private final String myPrefix;

        private PrefixMatcher(@NotNull String prefix) {
            this.myPrefix = prefix;
        }

        @Override
        public boolean matches(@NotNull CharSequence filename) {
            return Strings.startsWith((CharSequence)filename, (int)0, (CharSequence)this.myPrefix);
        }
    }

    private static final class InfixMatcher
    implements MaskMatcher {
        private final String myInfix;

        InfixMatcher(@NotNull String infix) {
            this.myInfix = infix;
        }

        @Override
        public boolean matches(@NotNull CharSequence filename) {
            return Strings.contains((CharSequence)filename, (CharSequence)this.myInfix);
        }
    }

    private static final class RegexpMatcher
    implements MaskMatcher {
        private final Matcher myMatcher;

        RegexpMatcher(@NotNull String pattern) {
            this.myMatcher = PatternUtil.fromMask((String)pattern).matcher("");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matches(@NotNull CharSequence filename) {
            Matcher matcher = this.myMatcher;
            synchronized (matcher) {
                this.myMatcher.reset(filename);
                return this.myMatcher.matches();
            }
        }
    }
}

