/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.text.Strings;
import org.jetbrains.annotations.NotNull;

public class ExtensionFileNameMatcher
implements FileNameMatcher {
    private final String myExtension;
    private final String myDotExtension;

    public ExtensionFileNameMatcher(@NotNull String extension) {
        this.myExtension = Strings.toLowerCase((String)extension);
        this.myDotExtension = "." + this.myExtension;
        if (extension.contains("*") || extension.contains("?")) {
            throw new IllegalArgumentException("extension should not contain regexp but got: '" + extension + "'");
        }
    }

    @Override
    public boolean acceptsCharSequence(@NotNull CharSequence fileName) {
        return Strings.endsWithIgnoreCase((CharSequence)fileName, (String)this.myDotExtension);
    }

    @Override
    @NotNull
    public String getPresentableString() {
        return "*." + this.myExtension;
    }

    @NotNull
    public String getExtension() {
        return this.myExtension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionFileNameMatcher that = (ExtensionFileNameMatcher)o;
        return this.myExtension.equals(that.myExtension);
    }

    public int hashCode() {
        return this.myExtension.hashCode();
    }

    public String toString() {
        return this.getPresentableString();
    }
}

