/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import com.intellij.tests.JUnit5TeamCityRunnerForTestAllSuite;
import java.lang.reflect.Method;
import java.util.ServiceLoader;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public class JUnit5TeamCityRunnerForTestsOnClasspath {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            ClassNameFilter nameFilter;
            Launcher launcher = LauncherFactory.create();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                nameFilter = JUnit5TeamCityRunnerForTestsOnClasspath.createClassNameFilter(classLoader);
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(0);
                return;
            }
            System.out.println("Number of test engines: " + ServiceLoader.load(TestEngine.class).stream().count());
            LauncherDiscoveryRequest discoveryRequest = LauncherDiscoveryRequestBuilder.request().configurationParameter("junit.jupiter.extensions.autodetection.enabled", "true").selectors(new DiscoverySelector[]{DiscoverySelectors.selectPackage((String)"")}).filters(new Filter[]{nameFilter, EngineFilter.excludeEngines((String[])new String[]{"junit-vintage"})}).build();
            TestPlan testPlan = launcher.discover(discoveryRequest);
            if (testPlan.containsTests()) {
                launcher.execute(testPlan, new TestExecutionListener[]{new JUnit5TeamCityRunnerForTestAllSuite.TCExecutionListener()});
            } else {
                System.exit(42);
            }
        }
        finally {
            System.exit(0);
        }
    }

    private static ClassNameFilter createClassNameFilter(ClassLoader classLoader) throws NoSuchMethodException, ClassNotFoundException {
        final Method included = Class.forName("com.intellij.TestCaseLoader", true, classLoader).getDeclaredMethod("isClassIncluded", String.class);
        return new ClassNameFilter(){

            public FilterResult apply(String className) {
                try {
                    if (((Boolean)included.invoke(null, className)).booleanValue()) {
                        return FilterResult.included(null);
                    }
                    return FilterResult.excluded(null);
                }
                catch (Throwable e) {
                    return FilterResult.excluded((String)e.getMessage());
                }
            }
        };
    }
}

