/*
 * Decompiled with CFR 0.152.
 */
package org.toml.lang.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.lexer.TomlEscapeLexer;
import org.toml.lang.lexer.UtilsKt;
import org.toml.lang.psi.ElementTypesKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a.\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\n\u0010\n\u001a\u00060\u000bj\u0002`\f\u001a,\u0010\u0003\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00012\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0011"}, d2={"decodeEscape", "", "esc", "parseTomlStringCharacters", "Lkotlin/Pair;", "", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "chars", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "lexer", "Lorg/toml/lang/lexer/TomlEscapeLexer;", "sourceOffsets", "unescapeToml", "intellij.toml.core"})
public final class TomlEscapeUtilsKt {
    @NotNull
    public static final String unescapeToml(@NotNull String $this$unescapeToml, @NotNull IElementType tokenType) {
        StringBuilder outChars;
        boolean result;
        String unNewlined;
        if (!ElementTypesKt.getTOML_STRING_LITERALS().contains(tokenType)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        IElementType iElementType = tokenType;
        String string = unNewlined = ElementTypesKt.getTOML_MULTILINE_STRINGS().contains(iElementType) ? StringsKt.removePrefix((String)$this$unescapeToml, (CharSequence)"\n") : $this$unescapeToml;
        return ElementTypesKt.getTOML_BASIC_STRINGS().contains(tokenType) ? ((result = ((Boolean)TomlEscapeUtilsKt.parseTomlStringCharacters(tokenType, unNewlined, outChars = new StringBuilder()).getSecond()).booleanValue()) ? outChars.toString() : unNewlined) : unNewlined;
    }

    @NotNull
    public static final Pair<int[], Boolean> parseTomlStringCharacters(@NotNull IElementType tokenType, @NotNull String chars, @NotNull StringBuilder outChars) {
        if (!ElementTypesKt.getTOML_BASIC_STRINGS().contains(tokenType)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] sourceOffsets = new int[chars.length() + 1];
        TomlEscapeLexer lexer = TomlEscapeLexer.Companion.of(tokenType);
        boolean result = TomlEscapeUtilsKt.parseTomlStringCharacters(lexer, chars, outChars, sourceOffsets);
        return TuplesKt.to((Object)sourceOffsets, (Object)result);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean parseTomlStringCharacters(TomlEscapeLexer lexer, String chars, StringBuilder outChars, int[] sourceOffsets) {
        boolean bl;
        block4: {
            boolean $i$f$parseStringCharacters = false;
            int outOffset$iv = outChars.length();
            int index$iv = 0;
            block0: for (Pair pair : UtilsKt.tokenize(chars, (Lexer)lexer)) {
                IElementType type$iv = (IElementType)pair.component1();
                String text$iv = (String)pair.component2();
                sourceOffsets[outChars.length() - outOffset$iv] = index$iv;
                sourceOffsets[outChars.length() - outOffset$iv + 1] = index$iv + 1;
                IElementType iElementType = type$iv;
                if (Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN)) {
                    void p0;
                    String string = text$iv;
                    StringBuilder stringBuilder = outChars;
                    boolean bl2 = false;
                    stringBuilder.append(TomlEscapeUtilsKt.decodeEscape((String)p0));
                    index$iv += text$iv.length();
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) ? true : Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN)) {
                    bl = false;
                    break block4;
                }
                int first$iv = outChars.length() - outOffset$iv;
                outChars.append(text$iv);
                int i$iv = first$iv;
                int last$iv = outChars.length() - outOffset$iv - 1;
                if (i$iv > last$iv) continue;
                while (true) {
                    sourceOffsets[i$iv] = index$iv++;
                    if (i$iv == last$iv) continue block0;
                    ++i$iv;
                }
            }
            sourceOffsets[outChars.length() - outOffset$iv] = index$iv;
            bl = true;
        }
        return bl;
    }

    private static final String decodeEscape(String esc) {
        return switch (esc) {
            case "\\b" -> "\b";
            case "\\t" -> "\t";
            case "\\n" -> "\n";
            case "\\f" -> "\f";
            case "\\r" -> "\r";
            case "\\\"" -> "\"";
            case "\\\\" -> "\\";
            default -> {
                char var2_2;
                char v1 = var2_2 = esc.length() >= 2 ? (char)'\u0001' : '\u0000';
                if (_Assertions.ENABLED && var2_2 == '\u0000') {
                    String var3_3 = "Assertion failed";
                    throw new AssertionError((Object)var3_3);
                }
                char v2 = var2_2 = esc.charAt(0) == '\\' ? (char)'\u0001' : '\u0000';
                if (_Assertions.ENABLED && var2_2 == '\u0000') {
                    String var3_4 = "Assertion failed";
                    throw new AssertionError((Object)var3_4);
                }
                var2_2 = esc.charAt(1);
                if (var2_2 == 'u' ? true : var2_2 == 'U') {
                    String v3 = esc.substring(2, esc.length());
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    yield String.valueOf((char)Integer.parseInt(v3, 16));
                }
                if (var2_2 == '\r' ? true : var2_2 == '\n') {
                    yield "";
                }
                throw new IllegalStateException("unreachable".toString());
            }
        };
    }
}

