/*
 * Decompiled with CFR 0.152.
 */
package org.toml.lang.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.lexer.UtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001aA\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000fH\u0086\b\u001a\n\u0010\u0010\u001a\u00020\u0003*\u00020\u0011\u00a8\u0006\u0012"}, d2={"esc", "Lcom/intellij/psi/tree/IElementType;", "test", "", "parseStringCharacters", "lexer", "Lcom/intellij/lexer/Lexer;", "chars", "", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sourceOffsets", "", "decoder", "Lkotlin/Function1;", "isWhitespaceChar", "", "intellij.toml.core"})
public final class EscapeUtilsKt {
    @NotNull
    public static final IElementType esc(boolean test) {
        return test ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
    }

    public static final boolean isWhitespaceChar(char $this$isWhitespaceChar) {
        return ((Object)Character.valueOf($this$isWhitespaceChar)).equals(Character.valueOf(' ')) || ((Object)Character.valueOf($this$isWhitespaceChar)).equals(Character.valueOf('\r')) || ((Object)Character.valueOf($this$isWhitespaceChar)).equals(Character.valueOf('\n')) || ((Object)Character.valueOf($this$isWhitespaceChar)).equals(Character.valueOf('\t'));
    }

    public static final boolean parseStringCharacters(@NotNull Lexer lexer, @NotNull String chars, @NotNull StringBuilder outChars, @NotNull int[] sourceOffsets, @NotNull Function1<? super String, String> decoder) {
        boolean $i$f$parseStringCharacters = false;
        int outOffset = outChars.length();
        int index = 0;
        block0: for (Pair pair : UtilsKt.tokenize(chars, lexer)) {
            IElementType type = (IElementType)pair.component1();
            String text = (String)pair.component2();
            sourceOffsets[outChars.length() - outOffset] = index;
            sourceOffsets[outChars.length() - outOffset + 1] = index + 1;
            IElementType iElementType = type;
            if (Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN)) {
                outChars.append((String)decoder.invoke((Object)text));
                index += text.length();
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) ? true : Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN)) {
                return false;
            }
            int first = outChars.length() - outOffset;
            outChars.append(text);
            int i = first;
            int last = outChars.length() - outOffset - 1;
            if (i > last) continue;
            while (true) {
                sourceOffsets[i] = index++;
                if (i == last) continue block0;
                ++i;
            }
        }
        sourceOffsets[outChars.length() - outOffset] = index;
        return true;
    }
}

