/*
 * Decompiled with CFR 0.152.
 */
package org.toml.ide.json;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.ide.experiments.TomlExperiments;
import org.toml.lang.psi.TomlLiteral;
import org.toml.lang.psi.TomlTableHeader;
import org.toml.lang.psi.ext.TomlLiteralKind;
import org.toml.lang.psi.ext.TomlLiteralKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/toml/ide/json/TomlJsonSchemaCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "Companion", "Worker", "intellij.toml.json"})
public final class TomlJsonSchemaCompletionContributor
extends CompletionContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double LOW_PRIORITY = -1000.0;
    @NotNull
    private static final List<JsonSchemaType> JSON_COMPOUND_TYPES;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (!TomlExperiments.INSTANCE.isJsonSchemaEnabled()) {
            return;
        }
        PsiElement position = parameters.getPosition();
        JsonSchemaService jsonSchemaService = JsonSchemaService.Impl.get((Project)position.getProject());
        JsonSchemaObject jsonSchemaObject = jsonSchemaService.getSchemaObject(parameters.getOriginalFile());
        if (jsonSchemaObject != null) {
            PsiElement psiElement = parameters.getOriginalPosition();
            if (psiElement == null) {
                psiElement = parameters.getPosition();
            }
            PsiElement completionPosition = psiElement;
            Worker worker = new Worker(jsonSchemaObject, parameters.getPosition(), completionPosition, (Consumer<LookupElement>)((Consumer)result));
            worker.work();
        }
    }

    public static final /* synthetic */ List access$getJSON_COMPOUND_TYPES$cp() {
        return JSON_COMPOUND_TYPES;
    }

    static {
        Object[] objectArray = new JsonSchemaType[]{JsonSchemaType._array, JsonSchemaType._object, JsonSchemaType._any, null};
        JSON_COMPOUND_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0002\u0010\nJJ\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00030\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00112\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0010\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u001aH\u0002J\u0017\u0010%\u001a\u00070&\u00a2\u0006\u0002\b'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\fH\u0002J\u0018\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0.2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0006\u0010/\u001a\u00020\u0017R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/toml/ide/json/TomlJsonSchemaCompletionContributor$Worker;", "", "rootSchema", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "position", "Lcom/intellij/psi/PsiElement;", "originalPosition", "resultConsumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "(Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/util/Consumer;)V", "isInsideStringLiteral", "", "()Z", "project", "Lcom/intellij/openapi/project/Project;", "variants", "", "getVariants", "()Ljava/util/Set;", "walker", "Lcom/jetbrains/jsonSchema/extension/JsonLikePsiWalker;", "addAllPropertyVariants", "", "properties", "", "", "adapter", "Lcom/jetbrains/jsonSchema/extension/adapters/JsonPropertyAdapter;", "schemaProperties", "", "knownNames", "addPropertyVariant", "key", "jsonSchemaObject", "buildPairLookupElement", "element", "getIconForType", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "type", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaType;", "suggestValues", "schema", "isSurelyValue", "suggestValuesByType", "", "work", "intellij.toml.json"})
    private static final class Worker {
        @NotNull
        private final JsonSchemaObject rootSchema;
        @NotNull
        private final PsiElement position;
        @NotNull
        private final PsiElement originalPosition;
        @NotNull
        private final Consumer<LookupElement> resultConsumer;
        @NotNull
        private final Set<LookupElement> variants;
        @Nullable
        private final JsonLikePsiWalker walker;
        @NotNull
        private final Project project;

        public Worker(@NotNull JsonSchemaObject rootSchema, @NotNull PsiElement position, @NotNull PsiElement originalPosition, @NotNull Consumer<LookupElement> resultConsumer) {
            this.rootSchema = rootSchema;
            this.position = position;
            this.originalPosition = originalPosition;
            this.resultConsumer = resultConsumer;
            this.variants = new LinkedHashSet();
            this.walker = JsonLikePsiWalker.getWalker((PsiElement)this.position, (JsonSchemaObject)this.rootSchema);
            this.project = this.originalPosition.getProject();
        }

        @NotNull
        public final Set<LookupElement> getVariants() {
            return this.variants;
        }

        public final void work() {
            JsonLikePsiWalker checkable;
            JsonLikePsiWalker jsonLikePsiWalker = this.walker;
            if (jsonLikePsiWalker == null || (jsonLikePsiWalker = jsonLikePsiWalker.findElementToCheck(this.position)) == null) {
                return;
            }
            ThreeState isName = this.walker.isName((PsiElement)(checkable = jsonLikePsiWalker));
            JsonPointerPosition pointerPosition = this.walker.findPosition((PsiElement)checkable, isName == ThreeState.NO);
            if (pointerPosition == null || pointerPosition.isEmpty() && isName == ThreeState.NO) {
                return;
            }
            Collection schemas = new JsonSchemaResolver(this.project, this.rootSchema, pointerPosition).resolve();
            HashSet knownNames = new HashSet();
            for (JsonSchemaObject schema : schemas) {
                if (isName != ThreeState.NO) {
                    Set properties = this.walker.getPropertyNamesOfParentObject(this.originalPosition, this.position);
                    JsonPropertyAdapter adapter = this.walker.getParentPropertyAdapter((PsiElement)checkable);
                    Map schemaProperties = schema.getProperties();
                    this.addAllPropertyVariants(properties, adapter, schemaProperties, knownNames, this.originalPosition);
                }
                if (isName == ThreeState.YES) continue;
                this.suggestValues(schema, isName == ThreeState.NO);
            }
            for (LookupElement variant : this.variants) {
                this.resultConsumer.consume((Object)variant);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void addAllPropertyVariants(Collection<String> properties, JsonPropertyAdapter adapter, Map<String, JsonSchemaObject> schemaProperties, Set<String> knownNames, PsiElement originalPosition) {
            $this$filter$iv = schemaProperties.keySet();
            $i$f$filter = false;
            var9_9 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                name = (String)element$iv$iv;
                $i$a$-filter-TomlJsonSchemaCompletionContributor$Worker$addAllPropertyVariants$variants$1 = false;
                if (!properties.contains(name) && !knownNames.contains(name)) ** GOTO lbl-1000
                v0 = adapter;
                if (Intrinsics.areEqual((Object)name, (Object)(v0 != null ? v0.getName() : null))) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            variants = (List)destination$iv$iv;
            for (String variant : variants) {
                knownNames.add(variant);
                jsonSchemaObject = schemaProperties.get(variant);
                if (jsonSchemaObject == null) continue;
                $this$parentOfType_u24default$iv = originalPosition;
                withSelf$iv = false;
                $i$f$parentOfType = false;
                v2 = isTomlHeader = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, TomlTableHeader.class, (boolean)true) != null;
                if (isTomlHeader && !TomlJsonSchemaCompletionContributor.access$getJSON_COMPOUND_TYPES$cp().contains(jsonSchemaObject.guessType())) continue;
                this.addPropertyVariant(variant, jsonSchemaObject);
            }
        }

        private final void addPropertyVariant(String key, JsonSchemaObject jsonSchemaObject) {
            JsonSchemaObject jsonSchemaObject2;
            String description;
            CharSequence charSequence;
            Collection currentVariants = new JsonSchemaResolver(this.project, jsonSchemaObject).resolve();
            JsonSchemaObject jsonSchemaObject3 = (JsonSchemaObject)CollectionsKt.firstOrNull((Iterable)currentVariants);
            if (jsonSchemaObject3 == null) {
                jsonSchemaObject3 = jsonSchemaObject;
            }
            if ((charSequence = (CharSequence)(description = JsonSchemaDocumentationProvider.getBestDocumentation((boolean)true, (JsonSchemaObject)(jsonSchemaObject2 = jsonSchemaObject3)))) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                String string = jsonSchemaObject2.getTypeDescription(true);
                if (string == null) {
                    string = "";
                }
                description = string;
            }
            LookupElementBuilder lookupElement = LookupElementBuilder.create((String)key).withTypeText(description).withIcon(this.getIconForType(jsonSchemaObject2.guessType()));
            this.variants.add((LookupElement)lookupElement);
        }

        private final boolean isInsideStringLiteral() {
            PsiElement psiElement = this.position.getParent();
            TomlLiteral tomlLiteral = psiElement instanceof TomlLiteral ? (TomlLiteral)psiElement : null;
            return (tomlLiteral != null ? TomlLiteralKt.getKind(tomlLiteral) : null) instanceof TomlLiteralKind.String;
        }

        private final void suggestValues(JsonSchemaObject schema, boolean isSurelyValue) {
            List enumVariants = schema.getEnum();
            if (enumVariants != null) {
                for (Object o : enumVariants) {
                    if (this.isInsideStringLiteral() && !(o instanceof String)) continue;
                    String variant = this.isInsideStringLiteral() ? StringUtil.unquoteString((String)o.toString()) : o.toString();
                    this.variants.add((LookupElement)LookupElementBuilder.create((String)variant));
                }
            } else if (isSurelyValue && !this.isInsideStringLiteral()) {
                this.variants.addAll((Collection<LookupElement>)this.suggestValuesByType(schema.guessType()));
            }
        }

        private final List<LookupElement> suggestValuesByType(JsonSchemaType type) {
            JsonSchemaType jsonSchemaType = type;
            return switch (jsonSchemaType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonSchemaType.ordinal()]) {
                case 1 -> CollectionsKt.listOf((Object)this.buildPairLookupElement("{}"));
                case 2 -> CollectionsKt.listOf((Object)this.buildPairLookupElement("[]"));
                case 3 -> CollectionsKt.listOf((Object)this.buildPairLookupElement("\"\""));
                case 4 -> {
                    void $this$mapTo$iv$iv;
                    Object[] var2_2 = new String[]{"true", "false"};
                    Iterable $this$map$iv = CollectionsKt.listOf((Object[])var2_2);
                    boolean $i$f$map = false;
                    Iterable var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String var9_9 = (String)item$iv$iv;
                        Collection var11_11 = destination$iv$iv;
                        boolean $i$a$-map-TomlJsonSchemaCompletionContributor$Worker$suggestValuesByType$1 = false;
                        var11_11.add(LookupElementBuilder.create((String)it));
                    }
                    yield (List)destination$iv$iv;
                }
                default -> CollectionsKt.emptyList();
            };
        }

        private final LookupElement buildPairLookupElement(String element) {
            LookupElementBuilder builder = LookupElementBuilder.create((String)element).withInsertHandler(Worker::buildPairLookupElement$lambda$2);
            return PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)builder), (double)-1000.0);
        }

        private final Icon getIconForType(JsonSchemaType type) {
            JsonSchemaType jsonSchemaType = type;
            return switch (jsonSchemaType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonSchemaType.ordinal()]) {
                case 1 -> AllIcons.Json.Object;
                case 2 -> AllIcons.Json.Array;
                default -> IconManager.getInstance().getPlatformIcon(PlatformIcons.Property);
            };
        }

        private static final void buildPairLookupElement$lambda$2(InsertionContext context, LookupElement lookupElement) {
            EditorModificationUtil.moveCaretRelatively((Editor)context.getEditor(), (int)-1);
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JsonSchemaType.values().length];
                try {
                    nArray[JsonSchemaType._object.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._array.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._string.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._boolean.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/toml/ide/json/TomlJsonSchemaCompletionContributor$Companion;", "", "()V", "JSON_COMPOUND_TYPES", "", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaType;", "LOW_PRIORITY", "", "intellij.toml.json"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

