/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.urlassistant.PathData;
import com.google.urlassistant.PathType;
import com.google.urlassistant.util.ManifestUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Ji\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0010JZ\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0004\u00a8\u0006\u0014"}, d2={"Lcom/google/urlassistant/util/IntentFilterUtils;", "", "()V", "createAndInsertDeepLinkIntentFilter", "Lcom/intellij/psi/xml/XmlTag;", "activityTag", "pathDataList", "", "Lcom/google/urlassistant/PathData;", "schemes", "", "hosts", "ports", "", "mimeTypes", "order", "(Lcom/intellij/psi/xml/XmlTag;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/Integer;)Lcom/intellij/psi/xml/XmlTag;", "createDeepLinkIntentFilter", "fixSingleDeepLinkIntentFilter", "intentFilterTag", "url-assistant"})
public final class IntentFilterUtils {
    @NotNull
    public static final IntentFilterUtils INSTANCE = new IntentFilterUtils();

    private IntentFilterUtils() {
    }

    @NotNull
    public final XmlTag createAndInsertDeepLinkIntentFilter(@NotNull XmlTag activityTag, @NotNull List<? extends PathData> pathDataList, @NotNull List<String> schemes, @NotNull List<String> hosts, @NotNull List<Integer> ports, @NotNull List<String> mimeTypes, @Nullable Integer order) {
        Intrinsics.checkNotNullParameter((Object)activityTag, (String)"activityTag");
        Intrinsics.checkNotNullParameter(pathDataList, (String)"pathDataList");
        Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
        Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
        Intrinsics.checkNotNullParameter(ports, (String)"ports");
        Intrinsics.checkNotNullParameter(mimeTypes, (String)"mimeTypes");
        String xmlString = this.createDeepLinkIntentFilter(activityTag, pathDataList, schemes, hosts, ports, mimeTypes);
        XmlTag intentFilter = activityTag.createChildTag("intent-filter", null, xmlString, false);
        if (order != null) {
            String prefix = activityTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
            intentFilter.setAttribute(prefix + ":order", order.toString());
        }
        XmlTag res = activityTag.addSubTag(intentFilter, false);
        CodeStyleManager.getInstance((Project)activityTag.getProject()).reformat((PsiElement)activityTag);
        Intrinsics.checkNotNullExpressionValue((Object)res, (String)"res");
        return res;
    }

    public static /* synthetic */ XmlTag createAndInsertDeepLinkIntentFilter$default(IntentFilterUtils intentFilterUtils, XmlTag xmlTag, List list, List list2, List list3, List list4, List list5, Integer n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n2 & 0x20) != 0) {
            list5 = CollectionsKt.emptyList();
        }
        if ((n2 & 0x40) != 0) {
            n = null;
        }
        return intentFilterUtils.createAndInsertDeepLinkIntentFilter(xmlTag, list, list2, list3, list4, list5, n);
    }

    @Nullable
    public final XmlTag fixSingleDeepLinkIntentFilter(@NotNull XmlTag intentFilterTag) {
        Intrinsics.checkNotNullParameter((Object)intentFilterTag, (String)"intentFilterTag");
        List<XmlTag> list = ManifestUtils.searchXmlTagsByName(intentFilterTag, "data");
        Intrinsics.checkNotNullExpressionValue(list, (String)"searchXmlTagsByName(inte\u2026g, SdkConstants.TAG_DATA)");
        List<XmlTag> dataList = list;
        Set schemes = new LinkedHashSet();
        Set hosts = new LinkedHashSet();
        Set ports = new LinkedHashSet();
        Set mimeTypes = new LinkedHashSet();
        Set pathDataList = new LinkedHashSet();
        String string = intentFilterTag.getAttributeValue("order", "http://schemas.android.com/apk/res/android");
        Integer order = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        for (XmlTag data : dataList) {
            String mimeType;
            Integer port;
            String portString;
            String host;
            String scheme = data.getAttributeValue("scheme", "http://schemas.android.com/apk/res/android");
            Object[] objectArray = new String[]{"http", "https"};
            if (CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)scheme)) {
                String string2 = scheme;
                Intrinsics.checkNotNull((Object)string2);
                schemes.add(string2);
            }
            String string3 = host = data.getAttributeValue("host", "http://schemas.android.com/apk/res/android");
            boolean bl = string3 != null ? ((CharSequence)string3).length() > 0 : false;
            if (bl) {
                hosts.add(host);
            }
            String string4 = portString = data.getAttributeValue("port", "http://schemas.android.com/apk/res/android");
            Integer n = port = string4 != null ? StringsKt.toIntOrNull((String)string4) : null;
            if (port != null) {
                ports.add(port);
            }
            String string5 = mimeType = data.getAttributeValue("mimeType", "http://schemas.android.com/apk/res/android");
            boolean bl2 = string5 != null ? ((CharSequence)string5).length() > 0 : false;
            if (bl2) {
                mimeTypes.add(mimeType);
            }
            String path = data.getAttributeValue("path", "http://schemas.android.com/apk/res/android");
            String pathPattern = data.getAttributeValue("pathPattern", "http://schemas.android.com/apk/res/android");
            String pathPrefix = data.getAttributeValue("pathPrefix", "http://schemas.android.com/apk/res/android");
            String string6 = path;
            boolean bl3 = string6 != null ? ((CharSequence)string6).length() > 0 : false;
            if (bl3) {
                pathDataList.add(new PathData(PathType.Path, path));
            }
            String string7 = pathPattern;
            boolean bl4 = string7 != null ? ((CharSequence)string7).length() > 0 : false;
            if (bl4) {
                pathDataList.add(new PathData(PathType.PathPattern, pathPattern));
            }
            String string8 = pathPrefix;
            boolean bl5 = string8 != null ? ((CharSequence)string8).length() > 0 : false;
            if (!bl5) continue;
            pathDataList.add(new PathData(PathType.PathPrefix, pathPrefix));
        }
        XmlTag parentTag = intentFilterTag.getParentTag();
        if (schemes.isEmpty() || hosts.isEmpty() || parentTag == null) {
            return null;
        }
        String newFilterXmlString = this.createDeepLinkIntentFilter(parentTag, CollectionsKt.sortedWith((Iterable)pathDataList, (Comparator)new PathData.PathDataComparator()), CollectionsKt.sorted((Iterable)schemes), CollectionsKt.sorted((Iterable)hosts), CollectionsKt.sorted((Iterable)ports), CollectionsKt.sorted((Iterable)mimeTypes));
        XmlTag newFilter = parentTag.createChildTag("intent-filter", null, newFilterXmlString, false);
        if (order != null) {
            String prefix = parentTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
            newFilter.setAttribute(prefix + ":order", order.toString());
        }
        intentFilterTag.replace((PsiElement)newFilter);
        return newFilter;
    }

    private final String createDeepLinkIntentFilter(XmlTag activityTag, List<? extends PathData> pathDataList, List<String> schemes, List<String> hosts, List<Integer> ports, List<String> mimeTypes) {
        String prefix = activityTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
        Object xmlString = null;
        xmlString = StringsKt.trimIndent((String)("\n\n      <action " + prefix + ":name=\"android.intent.action.VIEW\"/>\n      <category " + prefix + ":name=\"android.intent.category.DEFAULT\"/>\n      <category " + prefix + ":name=\"android.intent.category.BROWSABLE\"/>\n      "));
        for (String string : schemes) {
            xmlString = xmlString + "<data " + prefix + ":scheme=\"" + string + "\"/>";
        }
        for (String string : hosts) {
            xmlString = xmlString + "<data " + prefix + ":host=\"" + string + "\"/>";
        }
        Iterator<Object> iterator = ports.iterator();
        while (iterator.hasNext()) {
            int n = ((Number)iterator.next()).intValue();
            xmlString = xmlString + "<data " + prefix + ":port=\"" + n + "\"/>";
        }
        for (String string : mimeTypes) {
            if (!(((CharSequence)string).length() > 0)) continue;
            xmlString = xmlString + "<data " + prefix + ":mimeType=\"" + string + "\"/>";
        }
        for (PathData pathData : pathDataList) {
            String it;
            if (pathData.getPathValue() == null) continue;
            boolean bl = false;
            xmlString = xmlString + "<data " + prefix + ":" + pathData.getPathType() + "=\"" + XmlUtil.escape((String)it) + "\"/>";
        }
        return xmlString;
    }

    static /* synthetic */ String createDeepLinkIntentFilter$default(IntentFilterUtils intentFilterUtils, XmlTag xmlTag, List list, List list2, List list3, List list4, List list5, int n, Object object) {
        if ((n & 0x10) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            list5 = CollectionsKt.emptyList();
        }
        return intentFilterUtils.createDeepLinkIntentFilter(xmlTag, list, list2, list3, list4, list5);
    }
}

