/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.escape.xml.CharacterDataEscaper;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.gradle.model.IdeSigningConfig;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.StringResourceWriter;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.util.FileExtensions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.urlassistant.FullUrl;
import com.google.urlassistant.util.ManifestUtils;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.SameThreadExecutor;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataListener;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DalUtils {
    private static final String ASSET_STATEMENTS = "asset_statements";
    private static final String STRING_ASSET_STATEMENTS = "@string/asset_statements";
    private static final String RESOURCE = "resource";
    private static final String AUTO_VERIFY = "autoVerify";
    private static final String DAL_HANDLE_URL_STATEMENT = "{\n  \"relation\": [\"delegate_permission/common.handle_all_urls\"],\n  \"target\": {\n    \"namespace\": \"android_app\",\n    \"package_name\": \"%1$s\",\n    \"sha256_cert_fingerprints\":\n    [\"%2$s\"]\n  }\n}";
    private static final String DAL_SMART_LOCK_STATEMENT = ",\n{\n  \"relation\": [\"delegate_permission/common.get_login_creds\"],\n  \"target\": {\n    \"namespace\": \"web\",\n    \"site\": \"%1$s\"\n  }\n},\n{\n  \"relation\": [\"delegate_permission/common.get_login_creds\"],\n  \"target\": {\n    \"namespace\": \"android_app\",\n    \"package_name\": \"%2$s\",\n    \"sha256_cert_fingerprints\":\n    [\"%3$s\"]\n  }\n}";
    private static final String DAL_STRING_RES = "[{ \"include\": \"%1$s/.well-known/assetlinks.json\" }]";

    private static Logger getLog() {
        return Logger.getInstance(DalUtils.class);
    }

    @NotNull
    public static FullUrl getFullUrlWithHttps(@NotNull String domain) throws MalformedURLException {
        FullUrl fullUrl = new FullUrl((String)(domain.contains("://") ? domain : "https://" + domain));
        fullUrl.setScheme("https");
        return fullUrl;
    }

    @NotNull
    public static String getDalFileText(@NotNull String packageId, @NotNull String keystoreFingerprint, @Nullable String signInUrl) {
        Object res = String.format(DAL_HANDLE_URL_STATEMENT, packageId, keystoreFingerprint);
        if (signInUrl != null) {
            res = (String)res + String.format(DAL_SMART_LOCK_STATEMENT, signInUrl, packageId, keystoreFingerprint);
        }
        return "[" + (String)res + "]";
    }

    @NotNull
    public static String getDalStringResText(@NotNull String domain) {
        return String.format(DAL_STRING_RES, domain);
    }

    @NotNull
    public static ListenableFuture<VirtualFile> addDalStringResource(@NotNull AndroidFacet facet, @NotNull String statementText) {
        ListenableFuture resourceItem;
        List itemList;
        Project project = facet.getModule().getProject();
        Module baseModule = InstantApps.findBaseFeature((Project)project);
        if (baseModule != null) {
            facet = AndroidFacet.getInstance((Module)baseModule);
        }
        if ((itemList = StudioResourceRepositoryManager.getAppResources((AndroidFacet)facet).getResources(ResourceNamespace.TODO(), ResourceType.STRING, ASSET_STATEMENTS)) == null || itemList.isEmpty()) {
            resourceItem = DalUtils.createItem(facet, ResourceFolderManager.getInstance((AndroidFacet)facet).getPrimaryFolder(), statementText);
        } else {
            for (ResourceItem item : itemList) {
                StringResourceWriter.INSTANCE.setItemText(project, item, statementText);
            }
            resourceItem = Futures.immediateFuture((Object)((ResourceItem)itemList.get(0)));
        }
        return Futures.transform(resourceItem, DalUtils::findContainingFile, (Executor)SameThreadExecutor.INSTANCE);
    }

    @NotNull
    private static ListenableFuture<ResourceItem> createItem(@NotNull AndroidFacet facet, @NotNull VirtualFile resFolder, @NotNull String value) {
        Project project = facet.getModule().getProject();
        XmlFile resourceFile = StringResourceWriter.INSTANCE.getStringResourceFile(project, resFolder);
        if (resourceFile == null) {
            return Futures.immediateFuture(null);
        }
        XmlTag root = resourceFile.getRootTag();
        if (root == null) {
            return Futures.immediateFuture(null);
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{resourceFile}).withName("Creating string asset_statements").run(() -> {
            String escapedText;
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
            try {
                escapedText = CharacterDataEscaper.escape((String)value);
            }
            catch (IllegalArgumentException exception) {
                Logger.getInstance(DalUtils.class).warn((Throwable)exception);
                escapedText = value;
            }
            XmlTag child = root.createChildTag(ResourceType.STRING.getName(), root.getNamespace(), escapedText, false);
            child.setAttribute("name", ASSET_STATEMENTS);
            child.setAttribute("translatable", "false");
            root.addSubTag(child, false);
        });
        SettableFuture result = SettableFuture.create();
        LocalResourceRepository repository = StudioResourceRepositoryManager.getModuleResources((AndroidFacet)facet);
        repository.invokeAfterPendingUpdatesFinish((Executor)EdtExecutorService.getInstance(), () -> {
            List resourceItems = repository.getResources(ResourceNamespace.TODO(), ResourceType.STRING, ASSET_STATEMENTS);
            ResourceItem defaultValue = resourceItems.stream().filter(item -> item.getConfiguration().getLocaleQualifier() == null).findFirst().orElse(null);
            result.set((Object)defaultValue);
        });
        return result;
    }

    public static boolean addStringResource(@NotNull AndroidFacet facet, @NotNull String statementText) {
        List itemList;
        Project project = facet.getModule().getProject();
        Module baseModule = InstantApps.findBaseFeature((Project)project);
        if (baseModule != null) {
            facet = AndroidFacet.getInstance((Module)baseModule);
        }
        if ((itemList = StudioResourceRepositoryManager.getAppResources((AndroidFacet)facet).getResources(ResourceNamespace.RES_AUTO, ResourceType.STRING, ASSET_STATEMENTS)).isEmpty()) {
            List resourceFolders = ResourceFolderManager.getInstance((AndroidFacet)facet).getFolders();
            if (resourceFolders.isEmpty()) {
                return false;
            }
            XmlTag newTag = DalUtils.makeItem(facet, (VirtualFile)resourceFolders.get(resourceFolders.size() - 1), statementText);
            return newTag != null;
        }
        for (ResourceItem item : itemList) {
            boolean successfullyChanged = StringResourceWriter.INSTANCE.setItemText(project, item, statementText);
            if (!successfullyChanged) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static XmlTag makeItem(@NotNull AndroidFacet facet, @NotNull VirtualFile resFolder, @NotNull String value) {
        Project project = facet.getModule().getProject();
        XmlFile resourceFile = StringResourceWriter.INSTANCE.getStringResourceFile(project, resFolder);
        if (resourceFile == null) {
            return null;
        }
        XmlTag root = resourceFile.getRootTag();
        if (root == null) {
            return null;
        }
        return (XmlTag)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{resourceFile}).withName("Creating string asset_statements").compute(() -> {
            String escapedText;
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
            try {
                escapedText = CharacterDataEscaper.escape((String)value);
            }
            catch (IllegalArgumentException exception) {
                Logger.getInstance(DalUtils.class).warn((Throwable)exception);
                escapedText = value;
            }
            XmlTag child = root.createChildTag(ResourceType.STRING.getName(), root.getNamespace(), escapedText, false);
            child.setAttribute("name", ASSET_STATEMENTS);
            child.setAttribute("translatable", "false");
            root.addSubTag(child, false);
            return child;
        });
    }

    @Nullable
    private static VirtualFile findContainingFile(@Nullable ResourceItem resourceItem) {
        if (resourceItem == null) {
            return null;
        }
        PathString source = resourceItem.getSource();
        if (source == null) {
            DalUtils.getLog().warn(String.format("Couldn't find the resource file containing \"%s\"", resourceItem.getQualifiedNameWithType()));
            return null;
        }
        VirtualFile file = FileExtensions.toVirtualFile((PathString)source);
        if (file == null) {
            DalUtils.getLog().warn(String.format("Couldn't find string resource file (%s) when adding asset statements", source.getNativePath()));
        }
        return file;
    }

    public static boolean checkDalStringResourceExists(@NotNull AndroidFacet facet, @NotNull String statementText) {
        Project project = facet.getModule().getProject();
        Module baseModule = InstantApps.findBaseFeature((Project)project);
        if (baseModule != null) {
            facet = AndroidFacet.getInstance((Module)baseModule);
        }
        List itemList = StudioResourceRepositoryManager.getAppResources((AndroidFacet)facet).getResources(ResourceNamespace.TODO(), ResourceType.STRING, ASSET_STATEMENTS);
        for (ResourceItem item : itemList) {
            XmlTag tag = IdeResourcesUtil.getItemTag((Project)project, (ResourceItem)item);
            if (tag == null || statementText.equals(CharacterDataEscaper.unescape((String)tag.getValue().getText()))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String loadSigningConfigsFromGradle(@NotNull Module module, @NotNull List<IdeSigningConfig> result) {
        AndroidModel androidModel;
        result.clear();
        String packageId = "";
        GradleAndroidModel androidModuleModel = GradleAndroidModel.get((Module)module);
        if (androidModuleModel == null) {
            return packageId;
        }
        Collection signingConfigCollection = androidModuleModel.getAndroidProject().getSigningConfigs();
        result.addAll(signingConfigCollection);
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet != null && (androidModel = AndroidModel.get((AndroidFacet)androidFacet)) != null) {
            packageId = androidModel.getApplicationId();
        }
        return packageId;
    }

    @NotNull
    public static List<AndroidFacet> addMetaDataToAndroidManifest(@NotNull AndroidFacet facet) {
        ArrayList<AndroidFacet> resultFacets = new ArrayList<AndroidFacet>();
        Project project = facet.getModule().getProject();
        Module baseModule = InstantApps.findBaseFeature((Project)project);
        List<Object> facetList = baseModule == null ? new ArrayList<AndroidFacet>(Arrays.asList(facet)) : ProjectSystemUtil.getAndroidFacets((Project)project);
        Map<AndroidFacet, Manifest> facetManifestMap = facetList.stream().filter(f -> SourceProviderManager.getInstance((AndroidFacet)f).getMainManifestFile() != null).collect(Collectors.toMap(f -> f, Manifest::getMainManifest));
        facetList = facetList.stream().filter(facetManifestMap::containsKey).collect(Collectors.toList());
        for (AndroidFacet androidFacet : facetList) {
            List<XmlTag> applications = ManifestUtils.searchXmlTagsByName(facetManifestMap.get(androidFacet).getXmlTag(), "application");
            if (applications.isEmpty() || !DalUtils.setAttributeOnTag(applications.get(0))) continue;
            resultFacets.add(androidFacet);
        }
        return resultFacets;
    }

    public static boolean checkMetaDataInAndroidManifestExists(@NotNull AndroidFacet facet) {
        Project project = facet.getModule().getProject();
        Module baseModule = InstantApps.findBaseFeature((Project)project);
        List<Object> facetList = baseModule == null ? new ArrayList<AndroidFacet>(Collections.singletonList(facet)) : ProjectSystemUtil.getAndroidFacets((Project)project);
        Map<AndroidFacet, Manifest> facetManifestMap = facetList.stream().filter(f -> SourceProviderManager.getInstance((AndroidFacet)f).getMainManifestFile() != null).collect(Collectors.toMap(f -> f, Manifest::getMainManifest));
        facetList = facetList.stream().filter(facetManifestMap::containsKey).collect(Collectors.toList());
        for (AndroidFacet androidFacet : facetList) {
            List<XmlTag> applications = ManifestUtils.searchXmlTagsByName(facetManifestMap.get(androidFacet).getXmlTag(), "application");
            if (applications.isEmpty()) continue;
            XmlTag applicationTag = applications.get(0);
            List<XmlTag> metaDatas = ManifestUtils.searchXmlTagsByName(applicationTag, "meta-data");
            for (XmlTag subTag : metaDatas) {
                if (!"meta-data".equals(subTag.getName()) || !ASSET_STATEMENTS.equals(subTag.getAttributeValue("name", "http://schemas.android.com/apk/res/android")) || STRING_ASSET_STATEMENTS.equals(subTag.getAttributeValue(RESOURCE, "http://schemas.android.com/apk/res/android"))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean setAttributeOnTag(@NotNull XmlTag applicationTag) {
        List<XmlTag> metaDatas = ManifestUtils.searchXmlTagsByName(applicationTag, "meta-data");
        try {
            for (XmlTag subTag : metaDatas) {
                if (!"meta-data".equals(subTag.getName()) || !ASSET_STATEMENTS.equals(subTag.getAttributeValue("name", "http://schemas.android.com/apk/res/android"))) continue;
                subTag.setAttribute(RESOURCE, "http://schemas.android.com/apk/res/android", STRING_ASSET_STATEMENTS);
                return true;
            }
            String prefix = applicationTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
            XmlTag metaData = applicationTag.createChildTag("meta-data", null, null, false);
            if (metaData == null) {
                return false;
            }
            metaData.setAttribute(prefix + ":name", "http://schemas.android.com/apk/res/android", ASSET_STATEMENTS);
            metaData.setAttribute(prefix + ":resource", "http://schemas.android.com/apk/res/android", STRING_ASSET_STATEMENTS);
            applicationTag.addSubTag(metaData, true);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return true;
    }

    public static boolean addAutoVerifyToAppLinks(@NotNull AndroidFacet facet) {
        Manifest manifest = Manifest.getMainManifest((AndroidFacet)facet);
        if (manifest == null) {
            return false;
        }
        Application application = manifest.getApplication();
        if (application == null) {
            return false;
        }
        List activityList = application.getActivities();
        for (Activity activity : activityList) {
            for (IntentFilter intentFilter : activity.getIntentFilters()) {
                if (!ManifestUtils.isValidAppLink(intentFilter.getXmlTag())) continue;
                XmlTag xmlTag = intentFilter.getXmlTag();
                xmlTag.setAttribute(AUTO_VERIFY, "http://schemas.android.com/apk/res/android", "true");
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getDalJsonFileUrl(@NotNull String domain) {
        return domain + "/.well-known/assetlinks.json";
    }

    public static class SigningConfigComboBoxModel
    implements ComboBoxModel<String> {
        private final List<IdeSigningConfig> configList;
        private int selectedIndex = 0;

        public SigningConfigComboBoxModel(@NotNull List<IdeSigningConfig> list) {
            this.configList = list;
        }

        @Nullable
        public IdeSigningConfig getSelectedSigningConfig() {
            try {
                return this.configList.get(this.selectedIndex);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            for (int i = 0; i < this.configList.size(); ++i) {
                if (!this.configList.get(i).getName().equals(anItem)) continue;
                this.selectedIndex = i;
                break;
            }
        }

        @Override
        public Object getSelectedItem() {
            try {
                return this.configList.get(this.selectedIndex).getName();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public int getSize() {
            return this.configList.size();
        }

        @Override
        public String getElementAt(int index) {
            try {
                return this.configList.get(index).getName();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

