/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui.models;

import com.google.urlassistant.datalayer.feature.listlinks.LinkInfo;
import com.google.urlassistant.ui.models.ColumnSelectionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0000\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fJ\u0014\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006!"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel;", "Ljavax/swing/table/AbstractTableModel;", "linkInfos", "", "Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;", "(Ljava/util/List;)V", "columnOptions", "Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel$AppLinksTableColumnOption;", "getColumnOptions", "()Ljava/util/List;", "columnSelectionListeners", "", "Lcom/google/urlassistant/ui/models/ColumnSelectionListener;", "getLinkInfos", "addColumnSelectionListener", "", "l", "getColumnClass", "Ljava/lang/Class;", "modelColumnIndex", "", "getColumnCount", "getColumnName", "", "getRowCount", "getValueAt", "", "rowIndex", "columnIndex", "onColumnSelectionChange", "column", "AppLinksTableColumnOption", "Companion", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nAppLinkOverviewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinkOverviewModel.kt\ncom/google/urlassistant/ui/models/AppLinkOverviewTableModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n1851#2,2:311\n*S KotlinDebug\n*F\n+ 1 AppLinkOverviewModel.kt\ncom/google/urlassistant/ui/models/AppLinkOverviewTableModel\n*L\n268#1:311,2\n*E\n"})
public final class AppLinkOverviewTableModel
extends AbstractTableModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<LinkInfo> linkInfos;
    @NotNull
    private final List<ColumnSelectionListener> columnSelectionListeners;
    @NotNull
    private final List<AppLinksTableColumnOption> columnOptions;
    public static final int SCHEME_MODEL_COLUMN_INDEX = 0;
    public static final int HOST_MODEL_COLUMN_INDEX = 1;
    public static final int PATH_MODEL_COLUMN_INDEX = 2;
    public static final int ACTIVITY_MODEL_COLUMN_INDEX = 3;
    public static final int APP_CHECKS_FAILED_MODEL_COLUMN_INDEX = 4;

    public AppLinkOverviewTableModel(@NotNull List<LinkInfo> linkInfos) {
        Intrinsics.checkNotNullParameter(linkInfos, (String)"linkInfos");
        this.linkInfos = linkInfos;
        this.columnSelectionListeners = new ArrayList();
        Object[] objectArray = new AppLinksTableColumnOption[]{new AppLinksTableColumnOption("Scheme", 0, true, (Function1<? super AppLinksTableColumnOption, Unit>)((Function1)new Function1<AppLinksTableColumnOption, Unit>((Object)this){

            public final void invoke(@NotNull AppLinksTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AppLinkOverviewTableModel.access$onColumnSelectionChange((AppLinkOverviewTableModel)this.receiver, p0);
            }
        })), new AppLinksTableColumnOption("Host", 1, true, (Function1<? super AppLinksTableColumnOption, Unit>)((Function1)new Function1<AppLinksTableColumnOption, Unit>((Object)this){

            public final void invoke(@NotNull AppLinksTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AppLinkOverviewTableModel.access$onColumnSelectionChange((AppLinkOverviewTableModel)this.receiver, p0);
            }
        })), new AppLinksTableColumnOption("Path", 2, true, (Function1<? super AppLinksTableColumnOption, Unit>)((Function1)new Function1<AppLinksTableColumnOption, Unit>((Object)this){

            public final void invoke(@NotNull AppLinksTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AppLinkOverviewTableModel.access$onColumnSelectionChange((AppLinkOverviewTableModel)this.receiver, p0);
            }
        })), new AppLinksTableColumnOption("Activity name", 3, true, (Function1<? super AppLinksTableColumnOption, Unit>)((Function1)new Function1<AppLinksTableColumnOption, Unit>((Object)this){

            public final void invoke(@NotNull AppLinksTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AppLinkOverviewTableModel.access$onColumnSelectionChange((AppLinkOverviewTableModel)this.receiver, p0);
            }
        })), new AppLinksTableColumnOption("App check failures", 4, true, (Function1<? super AppLinksTableColumnOption, Unit>)((Function1)new Function1<AppLinksTableColumnOption, Unit>((Object)this){

            public final void invoke(@NotNull AppLinksTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AppLinkOverviewTableModel.access$onColumnSelectionChange((AppLinkOverviewTableModel)this.receiver, p0);
            }
        }))};
        this.columnOptions = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<LinkInfo> getLinkInfos() {
        return this.linkInfos;
    }

    @NotNull
    public final List<AppLinksTableColumnOption> getColumnOptions() {
        return this.columnOptions;
    }

    public final void addColumnSelectionListener(@NotNull ColumnSelectionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.columnSelectionListeners.add(l);
    }

    private final void onColumnSelectionChange(AppLinksTableColumnOption column) {
        Iterable $this$forEach$iv = this.columnSelectionListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColumnSelectionListener it = (ColumnSelectionListener)element$iv;
            boolean bl = false;
            it.onSelectionChange(column);
        }
    }

    @Override
    public int getRowCount() {
        return this.linkInfos.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        LinkInfo link = this.linkInfos.get(rowIndex);
        Object result = switch (columnIndex) {
            case 0 -> link.getSingleLinkDataTagConfig().getScheme();
            case 1 -> link.getSingleLinkDataTagConfig().getRawHost();
            case 2 -> link.getSingleLinkDataTagConfig().getRawPath();
            case 3 -> link.getActivityConfig().getActivityName();
            case 4 -> link.getAppCheckSummary().getTotalFailedIntentFilterChecks();
            default -> throw new AssertionError(columnIndex);
        };
        return result;
    }

    @Override
    @NotNull
    public String getColumnName(int modelColumnIndex) {
        return this.columnOptions.get(modelColumnIndex).getName();
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int modelColumnIndex) {
        return switch (modelColumnIndex) {
            case 0, 1, 2, 3 -> String.class;
            case 4 -> Integer.TYPE;
            default -> throw new AssertionError(modelColumnIndex);
        };
    }

    public static final /* synthetic */ void access$onColumnSelectionChange(AppLinkOverviewTableModel $this, AppLinksTableColumnOption column) {
        $this.onColumnSelectionChange(column);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B@\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\n\u0012\b\b\u0002\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rR)\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\n\u0012\b\b\u0002\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel$AppLinksTableColumnOption;", "", "name", "", "modelIndex", "", "selected", "", "callback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "column", "", "(Ljava/lang/String;IZLkotlin/jvm/functions/Function1;)V", "getModelIndex", "()I", "getName", "()Ljava/lang/String;", "value", "getSelected", "()Z", "setSelected", "(Z)V", "url-assistant"})
    public static final class AppLinksTableColumnOption {
        @NotNull
        private final String name;
        private final int modelIndex;
        @NotNull
        private final Function1<AppLinksTableColumnOption, Unit> callback;
        private boolean selected;

        public AppLinksTableColumnOption(@NotNull String name, int modelIndex, boolean selected, @NotNull Function1<? super AppLinksTableColumnOption, Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.name = name;
            this.modelIndex = modelIndex;
            this.callback = callback;
            this.setSelected(selected);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getModelIndex() {
            return this.modelIndex;
        }

        public final boolean getSelected() {
            return this.selected;
        }

        public final void setSelected(boolean value) {
            this.selected = value;
            this.callback.invoke((Object)this);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel$Companion;", "", "()V", "ACTIVITY_MODEL_COLUMN_INDEX", "", "APP_CHECKS_FAILED_MODEL_COLUMN_INDEX", "HOST_MODEL_COLUMN_INDEX", "PATH_MODEL_COLUMN_INDEX", "SCHEME_MODEL_COLUMN_INDEX", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

