/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui.models;

import com.google.urlassistant.datalayer.DataLayerAccessor;
import com.google.urlassistant.datalayer.feature.listlinks.LinkFilter;
import com.google.urlassistant.datalayer.feature.listlinks.LinkInfo;
import com.google.urlassistant.datalayer.feature.listlinks.ListLinksRequest;
import com.google.urlassistant.datalayer.feature.listlinks.ListLinksRequestBuilder;
import com.google.urlassistant.datalayer.feature.listlinks.ListLinksResponse;
import com.google.urlassistant.datalayer.feature.listlinks.OrderBy;
import com.google.urlassistant.datalayer.feature.listlinks.OrderDirection;
import com.google.urlassistant.datalayer.feature.listlinks.SortableAttribute;
import com.google.urlassistant.ui.models.AppLinkOverviewTableModel;
import com.google.urlassistant.ui.models.SortListener;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 72\u00020\u0001:\u00017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020*J\u0006\u00102\u001a\u000200J\u000e\u00103\u001a\u0002002\u0006\u00104\u001a\u00020\"J\u000e\u00105\u001a\u0002002\u0006\u00106\u001a\u00020\u0017R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\b\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R<\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u00068"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkOverviewModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "dataAccessor", "Lcom/google/urlassistant/datalayer/DataLayerAccessor;", "kotlin.jvm.PlatformType", "filterOptions", "Ljavax/swing/DefaultComboBoxModel;", "Lcom/google/urlassistant/ui/models/AppLinkOverviewModel$Companion$FilterOptions;", "getFilterOptions", "()Ljavax/swing/DefaultComboBoxModel;", "hasNextPage", "", "getHasNextPage", "()Z", "links", "", "Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;", "getLinks", "()Ljava/util/List;", "mostRecentListLinksRequest", "Lcom/google/urlassistant/datalayer/feature/listlinks/ListLinksRequest;", "nextPageOffset", "", "value", "", "searchText", "getSearchText", "()Ljava/lang/String;", "setSearchText", "(Ljava/lang/String;)V", "Lkotlin/Pair;", "", "Lcom/google/urlassistant/ui/models/AppLinkOverviewModel$Companion$SortDirection;", "sort", "getSort", "()Lkotlin/Pair;", "setSort", "(Lkotlin/Pair;)V", "sortListeners", "Lcom/google/urlassistant/ui/models/SortListener;", "tableModel", "Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel;", "getTableModel", "()Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel;", "addSortListener", "", "l", "loadNextPage", "onSortChange", "column", "updateLinksBasedOnListLinks", "request", "Companion", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nAppLinkOverviewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinkOverviewModel.kt\ncom/google/urlassistant/ui/models/AppLinkOverviewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n1851#2,2:311\n*S KotlinDebug\n*F\n+ 1 AppLinkOverviewModel.kt\ncom/google/urlassistant/ui/models/AppLinkOverviewModel\n*L\n111#1:311,2\n*E\n"})
public final class AppLinkOverviewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final DataLayerAccessor dataAccessor;
    @NotNull
    private final List<LinkInfo> links;
    @NotNull
    private final AppLinkOverviewTableModel tableModel;
    @NotNull
    private final DefaultComboBoxModel<Companion.FilterOptions> filterOptions;
    @NotNull
    private String searchText;
    @NotNull
    private final List<SortListener> sortListeners;
    @NotNull
    private Pair<Integer, ? extends Companion.SortDirection> sort;
    private long nextPageOffset;
    @NotNull
    private ListLinksRequest mostRecentListLinksRequest;
    @NotNull
    private static final Map<Integer, SortableAttribute> columnIdxToSortableAttribute;
    @NotNull
    private static final Map<Companion.SortDirection, OrderDirection> sortDirectionToOrderDirection;

    public AppLinkOverviewModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.dataAccessor = (DataLayerAccessor)this.project.getService(DataLayerAccessor.class);
        this.links = new ArrayList();
        this.tableModel = new AppLinkOverviewTableModel(this.links);
        this.filterOptions = new DefaultComboBoxModel<Companion.FilterOptions>(Companion.FilterOptions.values());
        this.searchText = "";
        this.sortListeners = new ArrayList();
        this.sort = new Pair((Object)0, (Object)Companion.SortDirection.NONE);
        this.mostRecentListLinksRequest = new ListLinksRequest(CollectionsKt.emptyList(), null, null, 0, 0L, false, false, null, 254, null);
        this.updateLinksBasedOnListLinks(new ListLinksRequest(CollectionsKt.emptyList(), null, null, 0, 0L, true, true, null, 158, null));
        this.filterOptions.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(@NotNull ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void intervalRemoved(@NotNull ListDataEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void contentsChanged(@NotNull ListDataEvent e) {
                void $this$contentsChanged_u24lambda_u240;
                ListLinksRequestBuilder listLinksRequestBuilder;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                nextPageOffset = 0L;
                LinkFilter newFilter = this.getFilterOptions().getSelectedItem() == Companion.FilterOptions.MANIFEST_ISSUES ? new LinkFilter(null, 1, null, null) : null;
                ListLinksRequestBuilder listLinksRequestBuilder2 = listLinksRequestBuilder = mostRecentListLinksRequest.toBuilder();
                AppLinkOverviewModel appLinkOverviewModel = this;
                boolean bl = false;
                $this$contentsChanged_u24lambda_u240.setFilter(newFilter);
                $this$contentsChanged_u24lambda_u240.setForceRedoAppChecks(false);
                $this$contentsChanged_u24lambda_u240.setForceRedoWebChecks(false);
                $this$contentsChanged_u24lambda_u240.setPageOffset(0L);
                appLinkOverviewModel.updateLinksBasedOnListLinks(listLinksRequestBuilder.build());
            }
        });
    }

    @NotNull
    public final List<LinkInfo> getLinks() {
        return this.links;
    }

    @NotNull
    public final AppLinkOverviewTableModel getTableModel() {
        return this.tableModel;
    }

    @NotNull
    public final DefaultComboBoxModel<Companion.FilterOptions> getFilterOptions() {
        return this.filterOptions;
    }

    @NotNull
    public final String getSearchText() {
        return this.searchText;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSearchText(@NotNull String value) {
        void $this$_set_searchText__u24lambda_u240;
        ListLinksRequestBuilder listLinksRequestBuilder;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.searchText = value;
        this.nextPageOffset = 0L;
        ListLinksRequestBuilder listLinksRequestBuilder2 = listLinksRequestBuilder = this.mostRecentListLinksRequest.toBuilder();
        AppLinkOverviewModel appLinkOverviewModel = this;
        boolean bl = false;
        $this$_set_searchText__u24lambda_u240.setSearchKey(value);
        $this$_set_searchText__u24lambda_u240.setPageOffset(0L);
        $this$_set_searchText__u24lambda_u240.setForceRedoAppChecks(false);
        $this$_set_searchText__u24lambda_u240.setForceRedoWebChecks(false);
        appLinkOverviewModel.updateLinksBasedOnListLinks(listLinksRequestBuilder.build());
    }

    @NotNull
    public final Pair<Integer, Companion.SortDirection> getSort() {
        return this.sort;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSort(@NotNull Pair<Integer, ? extends Companion.SortDirection> value) {
        void $this$_set_sort__u24lambda_u241;
        ListLinksRequestBuilder listLinksRequestBuilder;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.sort = value;
        SortableAttribute sortableAttribute = columnIdxToSortableAttribute.get(value.getFirst());
        OrderDirection orderDirection = sortDirectionToOrderDirection.get(value.getSecond());
        List orderByList = sortableAttribute == null || orderDirection == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new OrderBy(sortableAttribute, orderDirection));
        this.nextPageOffset = 0L;
        ListLinksRequestBuilder listLinksRequestBuilder2 = listLinksRequestBuilder = this.mostRecentListLinksRequest.toBuilder();
        AppLinkOverviewModel appLinkOverviewModel = this;
        boolean bl = false;
        $this$_set_sort__u24lambda_u241.setOrderBys(orderByList);
        $this$_set_sort__u24lambda_u241.setPageOffset(0L);
        $this$_set_sort__u24lambda_u241.setForceRedoAppChecks(false);
        $this$_set_sort__u24lambda_u241.setForceRedoWebChecks(false);
        appLinkOverviewModel.updateLinksBasedOnListLinks(listLinksRequestBuilder.build());
        Iterable $this$forEach$iv = this.sortListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SortListener listener = (SortListener)element$iv;
            boolean bl2 = false;
            listener.onSortChange(((Number)value.getFirst()).intValue(), (Companion.SortDirection)((Object)value.getSecond()));
        }
    }

    public final boolean getHasNextPage() {
        return this.nextPageOffset != -1L;
    }

    public final void updateLinksBasedOnListLinks(@NotNull ListLinksRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Project project = this.project;
        String string = UrlAssistantBundle.message("overview.update.links", new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, request, project, string){
            final /* synthetic */ AppLinkOverviewModel this$0;
            final /* synthetic */ ListLinksRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    ListLinksResponse response = AppLinkOverviewModel.access$getDataAccessor$p(this.this$0).listLinks(this.$request);
                    indicator.checkCanceled();
                    AppLinkOverviewModel.access$setMostRecentListLinksRequest$p(this.this$0, this.$request);
                    if (AppLinkOverviewModel.access$getNextPageOffset$p(this.this$0) == 0L) {
                        this.this$0.getLinks().clear();
                    }
                    this.this$0.getLinks().addAll((Collection<LinkInfo>)response.getLinks());
                    AppLinkOverviewModel.access$setNextPageOffset$p(this.this$0, response.getNextPageOffset());
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (NotImplementedError notImplementedError) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void loadNextPage() {
        void $this$loadNextPage_u24lambda_u243;
        ListLinksRequestBuilder listLinksRequestBuilder;
        ListLinksRequestBuilder listLinksRequestBuilder2 = listLinksRequestBuilder = this.mostRecentListLinksRequest.toBuilder();
        AppLinkOverviewModel appLinkOverviewModel = this;
        boolean bl = false;
        $this$loadNextPage_u24lambda_u243.setPageOffset(this.nextPageOffset);
        $this$loadNextPage_u24lambda_u243.setForceRedoAppChecks(false);
        $this$loadNextPage_u24lambda_u243.setForceRedoWebChecks(false);
        appLinkOverviewModel.updateLinksBasedOnListLinks(listLinksRequestBuilder.build());
    }

    public final void onSortChange(int column) {
        Pair pair;
        if (((Number)this.sort.getFirst()).intValue() == column) {
            Companion.SortDirection direction = switch (WhenMappings.$EnumSwitchMapping$0[((Companion.SortDirection)((Object)this.sort.getSecond())).ordinal()]) {
                case 1 -> Companion.SortDirection.DESCENDING;
                case 2 -> Companion.SortDirection.NONE;
                case 3 -> Companion.SortDirection.ASCENDING;
                default -> throw new NoWhenBranchMatchedException();
            };
            pair = new Pair((Object)column, (Object)direction);
        } else {
            pair = new Pair((Object)column, (Object)Companion.SortDirection.ASCENDING);
        }
        this.setSort((Pair<Integer, ? extends Companion.SortDirection>)pair);
    }

    public final void addSortListener(@NotNull SortListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.sortListeners.add(l);
    }

    public static final /* synthetic */ DataLayerAccessor access$getDataAccessor$p(AppLinkOverviewModel $this) {
        return $this.dataAccessor;
    }

    public static final /* synthetic */ void access$setMostRecentListLinksRequest$p(AppLinkOverviewModel $this, ListLinksRequest listLinksRequest) {
        $this.mostRecentListLinksRequest = listLinksRequest;
    }

    public static final /* synthetic */ long access$getNextPageOffset$p(AppLinkOverviewModel $this) {
        return $this.nextPageOffset;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)((Object)SortableAttribute.SCHEME)), TuplesKt.to((Object)1, (Object)((Object)SortableAttribute.HOST)), TuplesKt.to((Object)2, (Object)((Object)SortableAttribute.RAW_PATH)), TuplesKt.to((Object)3, (Object)((Object)SortableAttribute.ACTIVITY_NAME)), TuplesKt.to((Object)4, (Object)((Object)SortableAttribute.INTENT_FILTER_ISSUES_COUNT))};
        columnIdxToSortableAttribute = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)Companion.SortDirection.ASCENDING), (Object)((Object)OrderDirection.ASCEND)), TuplesKt.to((Object)((Object)Companion.SortDirection.DESCENDING), (Object)((Object)OrderDirection.DESCEND))};
        sortDirectionToOrderDirection = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkOverviewModel$Companion;", "", "()V", "columnIdxToSortableAttribute", "", "", "Lcom/google/urlassistant/datalayer/feature/listlinks/SortableAttribute;", "sortDirectionToOrderDirection", "Lcom/google/urlassistant/ui/models/AppLinkOverviewModel$Companion$SortDirection;", "Lcom/google/urlassistant/datalayer/feature/listlinks/OrderDirection;", "FilterOptions", "SortDirection", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkOverviewModel$Companion$FilterOptions;", "", "label", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "ALL", "MANIFEST_ISSUES", "url-assistant"})
        public static final class FilterOptions
        extends Enum<FilterOptions> {
            @NotNull
            private final String label;
            public static final /* enum */ FilterOptions ALL = new FilterOptions("All links");
            public static final /* enum */ FilterOptions MANIFEST_ISSUES = new FilterOptions("Links with manifest issues");
            private static final /* synthetic */ FilterOptions[] $VALUES;

            private FilterOptions(String label) {
                this.label = label;
            }

            @NotNull
            public final String getLabel() {
                return this.label;
            }

            public static FilterOptions[] values() {
                return (FilterOptions[])$VALUES.clone();
            }

            public static FilterOptions valueOf(String value) {
                return Enum.valueOf(FilterOptions.class, value);
            }

            static {
                $VALUES = filterOptionsArray = new FilterOptions[]{FilterOptions.ALL, FilterOptions.MANIFEST_ISSUES};
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkOverviewModel$Companion$SortDirection;", "", "(Ljava/lang/String;I)V", "ASCENDING", "DESCENDING", "NONE", "url-assistant"})
        public static final class SortDirection
        extends Enum<SortDirection> {
            public static final /* enum */ SortDirection ASCENDING = new SortDirection();
            public static final /* enum */ SortDirection DESCENDING = new SortDirection();
            public static final /* enum */ SortDirection NONE = new SortDirection();
            private static final /* synthetic */ SortDirection[] $VALUES;

            public static SortDirection[] values() {
                return (SortDirection[])$VALUES.clone();
            }

            public static SortDirection valueOf(String value) {
                return Enum.valueOf(SortDirection.class, value);
            }

            static {
                $VALUES = sortDirectionArray = new SortDirection[]{SortDirection.ASCENDING, SortDirection.DESCENDING, SortDirection.NONE};
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Companion.SortDirection.values().length];
            try {
                nArray[Companion.SortDirection.ASCENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.SortDirection.DESCENDING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.SortDirection.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

