/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui.models;

import com.google.urlassistant.datalayer.feature.listlinks.LinkInfo;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.intentfiltercheck.IntentFilterCheckName;
import com.google.urlassistant.ui.UiUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.icons.AllIcons;
import icons.StudioIcons;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkDetailModel;", "", "link", "Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;", "(Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;)V", "checksColor", "Ljava/awt/Color;", "getChecksColor", "()Ljava/awt/Color;", "checksIcon", "Ljavax/swing/Icon;", "getChecksIcon", "()Ljavax/swing/Icon;", "checksMessage", "", "getChecksMessage", "()Ljava/lang/String;", "getLink", "()Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;", "Companion", "url-assistant"})
public final class AppLinkDetailModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkInfo link;
    @VisibleForTesting
    @NotNull
    public static final String DEEPLINKING_REFERENCE = "https://developer.android.com/training/app-links/deep-linking";
    @VisibleForTesting
    @NotNull
    public static final String VERIFY_REFERENCE = "https://developer.android.com/training/app-links/verify-android-applinks";
    @VisibleForTesting
    @NotNull
    public static final String REDIRECT_REFERENCE = "https://support.google.com/google-ads/answer/10023042?hl=en#:~:text=Note%3A%20Google%20Ads%20doesn't,users%20directly%20to%20the%20app.";

    public AppLinkDetailModel(@NotNull LinkInfo link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        this.link = link;
    }

    @NotNull
    public final LinkInfo getLink() {
        return this.link;
    }

    @NotNull
    public final Icon getChecksIcon() {
        Icon icon;
        if (this.link.getAppCheckSummary().getTotalFailedIntentFilterChecks() == 0) {
            Icon icon2 = AllIcons.RunConfigurations.TestPassed;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"TestPassed");
        } else {
            Icon icon3 = StudioIcons.Common.ERROR;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ERROR");
        }
        return icon;
    }

    @NotNull
    public final String getChecksMessage() {
        String string;
        int failedChecks = this.link.getAppCheckSummary().getTotalFailedIntentFilterChecks();
        switch (failedChecks) {
            case 0: {
                String string2 = UrlAssistantBundle.message("link.passed.all.checks", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"link.passed.all.checks\")");
                break;
            }
            case 1: {
                String string3 = UrlAssistantBundle.message("link.failed.one.check", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"link.failed.one.check\")");
                break;
            }
            default: {
                Object[] objectArray = new Object[]{failedChecks};
                String string4 = UrlAssistantBundle.message("link.failed.number.checks", objectArray);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"link.failed.number.checks\", failedChecks)");
            }
        }
        return string;
    }

    @NotNull
    public final Color getChecksColor() {
        Color color;
        if (this.link.getAppCheckSummary().getTotalFailedIntentFilterChecks() == 0) {
            Color color2 = UIManager.getColor("Label.foreground");
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getColor(\"Label.foreground\")");
        } else {
            color = (Color)UiUtils.INSTANCE.getRED_TEXT_COLOR();
        }
        return color;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkDetailModel$Companion;", "", "()V", "DEEPLINKING_REFERENCE", "", "REDIRECT_REFERENCE", "VERIFY_REFERENCE", "checkNameToExplanation", "intentFilterCheckName", "Lcom/google/urlassistant/datalayer/model/validation/appchecksummary/intentfiltercheck/IntentFilterCheckName;", "checkNameToReferenceLink", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String checkNameToExplanation(@NotNull IntentFilterCheckName intentFilterCheckName) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)intentFilterCheckName), (String)"intentFilterCheckName");
            switch (WhenMappings.$EnumSwitchMapping$0[intentFilterCheckName.ordinal()]) {
                case 1: {
                    String string2 = UrlAssistantBundle.message("accordion.content.data", new Object[0]);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"accordion.content.data\")");
                    break;
                }
                case 2: {
                    String string3 = UrlAssistantBundle.message("accordion.content.action.view", new Object[0]);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"accordion.content.action.view\")");
                    break;
                }
                case 3: {
                    String string4 = UrlAssistantBundle.message("accordion.content.default.category", new Object[0]);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"accordion.content.default.category\")");
                    break;
                }
                case 4: {
                    String string5 = UrlAssistantBundle.message("accordion.content.browsable.category", new Object[0]);
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"accordion.content.browsable.category\")");
                    break;
                }
                case 5: {
                    String string6 = UrlAssistantBundle.message("accordion.content.android.system", new Object[0]);
                    string = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(\"accordion.content.android.system\")");
                    break;
                }
                case 6: {
                    String string7 = UrlAssistantBundle.message("accordion.content.redirect", new Object[0]);
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(\"accordion.content.redirect\")");
                    break;
                }
                case 7: {
                    throw new AssertionError((Object)"Link validation type should be specified.");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @NotNull
        public final String checkNameToReferenceLink(@NotNull IntentFilterCheckName intentFilterCheckName) {
            Intrinsics.checkNotNullParameter((Object)((Object)intentFilterCheckName), (String)"intentFilterCheckName");
            return switch (WhenMappings.$EnumSwitchMapping$0[intentFilterCheckName.ordinal()]) {
                case 1, 2, 3, 4 -> AppLinkDetailModel.DEEPLINKING_REFERENCE;
                case 5 -> AppLinkDetailModel.VERIFY_REFERENCE;
                case 6 -> AppLinkDetailModel.REDIRECT_REFERENCE;
                case 7 -> throw new AssertionError((Object)"Link validation type should be specified.");
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[IntentFilterCheckName.values().length];
                try {
                    nArray[IntentFilterCheckName.DATA_TAG.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.ACTION_VIEW.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.DEFAULT_CATEGORY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.BROWSABLE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.ANDROID_SYSTEM.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.NON_REDIRECT_LINK.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IntentFilterCheckName.LINK_VALIDATION_TYPE_UNSPECIFIED.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

