/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.google.urlassistant.datalayer.feature.listlinks.LinkInfo;
import com.google.urlassistant.ui.AppLinkDetail;
import com.google.urlassistant.ui.HeaderCellRenderer;
import com.google.urlassistant.ui.UrlAssistantSidePanel;
import com.google.urlassistant.ui.models.AppLinkDetailModel;
import com.google.urlassistant.ui.models.AppLinkOverviewModel;
import com.google.urlassistant.ui.models.AppLinkOverviewTableModel;
import com.google.urlassistant.ui.models.ColumnSelectionListener;
import com.intellij.openapi.project.Project;
import com.intellij.ui.table.JBTable;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/google/urlassistant/ui/AppLinkOverviewTable;", "Lcom/intellij/ui/table/JBTable;", "project", "Lcom/intellij/openapi/project/Project;", "overviewModel", "Lcom/google/urlassistant/ui/models/AppLinkOverviewModel;", "model", "Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel;", "sidePanelParent", "Lcom/google/urlassistant/ui/UrlAssistantSidePanel;", "(Lcom/intellij/openapi/project/Project;Lcom/google/urlassistant/ui/models/AppLinkOverviewModel;Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel;Lcom/google/urlassistant/ui/UrlAssistantSidePanel;)V", "headerCellRenderer", "Lcom/google/urlassistant/ui/HeaderCellRenderer;", "hiddenColumns", "", "", "Ljavax/swing/table/TableColumn;", "hideColumn", "", "column", "Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel$AppLinksTableColumnOption;", "onColumnSelection", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nAppLinkOverview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinkOverview.kt\ncom/google/urlassistant/ui/AppLinkOverviewTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,417:1\n1851#2,2:418\n*S KotlinDebug\n*F\n+ 1 AppLinkOverview.kt\ncom/google/urlassistant/ui/AppLinkOverviewTable\n*L\n347#1:418,2\n*E\n"})
public final class AppLinkOverviewTable
extends JBTable {
    @NotNull
    private final Project project;
    @NotNull
    private final AppLinkOverviewModel overviewModel;
    @NotNull
    private final AppLinkOverviewTableModel model;
    @NotNull
    private final UrlAssistantSidePanel sidePanelParent;
    @NotNull
    private final Map<Integer, TableColumn> hiddenColumns;
    @NotNull
    private final HeaderCellRenderer headerCellRenderer;

    public AppLinkOverviewTable(@NotNull Project project, @NotNull AppLinkOverviewModel overviewModel, @NotNull AppLinkOverviewTableModel model, @NotNull UrlAssistantSidePanel sidePanelParent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)overviewModel, (String)"overviewModel");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)sidePanelParent, (String)"sidePanelParent");
        super((TableModel)model);
        this.project = project;
        this.overviewModel = overviewModel;
        this.model = model;
        this.sidePanelParent = sidePanelParent;
        this.hiddenColumns = new LinkedHashMap();
        JTableHeader jTableHeader = this.getTableHeader();
        Intrinsics.checkNotNullExpressionValue((Object)jTableHeader, (String)"getTableHeader()");
        this.headerCellRenderer = new HeaderCellRenderer(jTableHeader, this.overviewModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(this.headerCellRenderer);
        this.setRowSorter(null);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mouseClicked(e);
                overviewModel.onSortChange(this.columnAtPoint(e.getPoint()));
            }
        });
        this.getTableHeader().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void keyReleased(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    overviewModel.onSortChange(this.getSelectedColumn());
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() >= 2) {
                    int row = this.rowAtPoint(e.getPoint());
                    LinkInfo linkInfo = model.getLinkInfos().get(row);
                    sidePanelParent.setContent(new AppLinkDetail(project, sidePanelParent, new AppLinkDetailModel(linkInfo)));
                }
            }

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void keyReleased(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    int row = this.getSelectedRow();
                    LinkInfo linkInfo = model.getLinkInfos().get(row);
                    sidePanelParent.setContent(new AppLinkDetail(project, sidePanelParent, new AppLinkDetailModel(linkInfo)));
                }
            }
        });
        Iterable $this$forEach$iv = this.model.getColumnOptions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppLinkOverviewTableModel.AppLinksTableColumnOption it = (AppLinkOverviewTableModel.AppLinksTableColumnOption)element$iv;
            boolean bl = false;
            if (it.getSelected()) continue;
            this.hideColumn(it);
        }
        this.model.addColumnSelectionListener(new ColumnSelectionListener(){

            @Override
            public final void onSelectionChange(@NotNull AppLinkOverviewTableModel.AppLinksTableColumnOption column) {
                Intrinsics.checkNotNullParameter((Object)column, (String)"column");
                this.onColumnSelection(column);
            }
        });
    }

    private final void onColumnSelection(AppLinkOverviewTableModel.AppLinksTableColumnOption column) {
        if (column.getSelected()) {
            TableColumn tableColumn = this.hiddenColumns.get(column.getModelIndex());
            if (tableColumn == null) {
                return;
            }
            TableColumn hiddenColumn = tableColumn;
            this.hiddenColumns.remove(hiddenColumn.getModelIndex());
            this.addColumn(hiddenColumn);
            int correctPosition = hiddenColumn.getModelIndex();
            int n = hiddenColumn.getModelIndex();
            for (int i = 0; i < n; ++i) {
                if (!this.hiddenColumns.containsKey(i)) continue;
                --correctPosition;
            }
            this.moveColumn(this.model.getColumnCount() - this.hiddenColumns.size() - 1, correctPosition);
        } else {
            this.hideColumn(column);
        }
    }

    private final void hideColumn(AppLinkOverviewTableModel.AppLinksTableColumnOption column) {
        TableColumn tableColumn = this.getColumn(column.getName());
        if (tableColumn == null) {
            return;
        }
        TableColumn columnToHide = tableColumn;
        this.hiddenColumns.put(columnToHide.getModelIndex(), columnToHide);
        this.removeColumn(columnToHide);
    }
}

