/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.google.urlassistant.datalayer.model.validation.appchecksummary.intentfiltercheck.IntentFilterCheckResult;
import com.google.urlassistant.ui.Accordion;
import com.google.urlassistant.ui.AppLinkOverview;
import com.google.urlassistant.ui.ExpansionListener;
import com.google.urlassistant.ui.UiUtils;
import com.google.urlassistant.ui.UrlAssistantSidePanel;
import com.google.urlassistant.ui.models.AppLinkDetailModel;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/google/urlassistant/ui/AppLinkDetail;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "sidePanelParent", "Lcom/google/urlassistant/ui/UrlAssistantSidePanel;", "model", "Lcom/google/urlassistant/ui/models/AppLinkDetailModel;", "(Lcom/intellij/openapi/project/Project;Lcom/google/urlassistant/ui/UrlAssistantSidePanel;Lcom/google/urlassistant/ui/models/AppLinkDetailModel;)V", "createAccordionContent", "intentFilterCheckResult", "Lcom/google/urlassistant/datalayer/model/validation/appchecksummary/intentfiltercheck/IntentFilterCheckResult;", "backgroundColor", "Ljava/awt/Color;", "createHeaderContent", "Lcom/intellij/ui/components/JBLabel;", "dispose", "", "validateAndPaint", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nAppLinkDetail.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinkDetail.kt\ncom/google/urlassistant/ui/AppLinkDetail\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public final class AppLinkDetail
extends JPanel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final UrlAssistantSidePanel sidePanelParent;
    @NotNull
    private final AppLinkDetailModel model;

    public AppLinkDetail(@NotNull Project project, @NotNull UrlAssistantSidePanel sidePanelParent, @NotNull AppLinkDetailModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sidePanelParent, (String)"sidePanelParent");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(new GridBagLayout());
        this.project = project;
        this.sidePanelParent = sidePanelParent;
        this.model = model;
        Disposer.register((Disposable)this.sidePanelParent, (Disposable)this);
        JPanel backButtonRow = new JPanel();
        String string = UrlAssistantBundle.message("back.to.list", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"back.to.list\")");
        Icon icon = StudioIcons.Common.BACK_ARROW;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BACK_ARROW");
        JButton backButton = UiUtils.INSTANCE.createNoStyleButton(string, icon);
        backButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                sidePanelParent.setContent(new AppLinkOverview(project, sidePanelParent, null, 4, null));
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Object object = gridBagConstraints;
        Component component = backButton;
        AppLinkDetail appLinkDetail = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.anchor = 17;
        Unit unit = Unit.INSTANCE;
        appLinkDetail.add(component, gridBagConstraints);
        this.add((Component)backButtonRow, UiUtils.createConstraintsForRow$default(UiUtils.INSTANCE, 0, 0, 3, null));
        object = new JBLabel(this.model.getChecksMessage());
        GridBagConstraints $this$_init__u24lambda_u241 = object;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setIcon(this.model.getChecksIcon());
        $this$_init__u24lambda_u241.setForeground(this.model.getChecksColor());
        $this$_init__u24lambda_u241.setFont(new Font($this$_init__u24lambda_u241.getFont().getFontName(), 1, $this$_init__u24lambda_u241.getFont().getSize()));
        GridBagConstraints errorText = object;
        if (!StringsKt.isBlank((CharSequence)this.model.getChecksMessage())) {
            object = UiUtils.createConstraintsForRow$default(UiUtils.INSTANCE, 1, 0, 2, null);
            $this$_init__u24lambda_u241 = object;
            component = (Component)((Object)errorText);
            appLinkDetail = this;
            boolean bl3 = false;
            $this$_init__u24lambda_u242.insets = (Insets)JBUI.insets((int)12, (int)0);
            unit = Unit.INSTANCE;
            appLinkDetail.add(component, object);
        }
        String string2 = UrlAssistantBundle.message("app.checks.header", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"app.checks.header\")");
        Color color = this.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
        object = UiUtils.createConstraintsForRow$default(UiUtils.INSTANCE, 2, 0, 2, null);
        GridBagConstraints $this$_init__u24lambda_u242 = object;
        component = (Component)UiUtils.INSTANCE.createHeader(string2, color);
        appLinkDetail = this;
        boolean bl4 = false;
        $this$_init__u24lambda_u243.insets = (Insets)JBUI.insets((int)5, (int)0);
        unit = Unit.INSTANCE;
        appLinkDetail.add(component, object);
        String string3 = UrlAssistantBundle.message("app.checks.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"app.checks.description\")");
        Color color2 = this.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"background");
        object = UiUtils.createConstraintsForRow$default(UiUtils.INSTANCE, 3, 0, 2, null);
        GridBagConstraints $this$_init__u24lambda_u243 = object;
        component = (Component)UiUtils.INSTANCE.createMultilineText(string3, color2);
        appLinkDetail = this;
        boolean bl5 = false;
        $this$_init__u24lambda_u244.insets = (Insets)JBUI.insetsBottom((int)12);
        unit = Unit.INSTANCE;
        appLinkDetail.add(component, object);
        object = this.model.getLink().getAppCheckSummary().getIntentFilterCheckResults().iterator();
        int n = 0;
        while (object.hasNext()) {
            int i = n++;
            IntentFilterCheckResult intentFilterCheckResult = (IntentFilterCheckResult)object.next();
            JBColor accordionBackground = JBColor.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)accordionBackground, (String)"accordionBackground");
            Accordion accordion = new Accordion((Color)accordionBackground, (Component)this.createHeaderContent(intentFilterCheckResult), this.createAccordionContent(intentFilterCheckResult, (Color)accordionBackground));
            accordion.addListener(new ExpansionListener(){

                @Override
                public final void onToggle(boolean it) {
                    this.validateAndPaint();
                }
            });
            accordion.setExpanded(!intentFilterCheckResult.isCheckPassed());
            this.add((Component)accordion, UiUtils.createConstraintsForRow$default(UiUtils.INSTANCE, 4 + i, 0, 2, null));
        }
        this.add((Component)new JPanel(), UiUtils.createConstraintsForExpander$default(UiUtils.INSTANCE, 11, 0, 2, null));
    }

    public void dispose() {
    }

    private final JBLabel createHeaderContent(IntentFilterCheckResult intentFilterCheckResult) {
        JBLabel jBLabel;
        JBLabel $this$createHeaderContent_u24lambda_u245 = jBLabel = new JBLabel(intentFilterCheckResult.getCheckName().name());
        boolean bl = false;
        $this$createHeaderContent_u24lambda_u245.setIcon(intentFilterCheckResult.isCheckPassed() ? AllIcons.RunConfigurations.TestPassed : AllIcons.RunConfigurations.TestFailed);
        return jBLabel;
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createAccordionContent(IntentFilterCheckResult intentFilterCheckResult, Color backgroundColor) {
        void $this$createAccordionContent_u24lambda_u249;
        GridBagConstraints gridBagConstraints;
        JPanel res = new JPanel(new GridBagLayout());
        String explanation = AppLinkDetailModel.Companion.checkNameToExplanation(intentFilterCheckResult.getCheckName());
        String referenceLink = AppLinkDetailModel.Companion.checkNameToReferenceLink(intentFilterCheckResult.getCheckName());
        Serializable serializable = gridBagConstraints = UiUtils.createConstraintsForExpander$default(UiUtils.INSTANCE, 0, 0, 3, null);
        Component component = (Component)UiUtils.INSTANCE.createMultilineText(explanation, backgroundColor);
        JPanel jPanel = res;
        boolean bl = false;
        $this$createAccordionContent_u24lambda_u246.insets = (Insets)JBUI.insets((int)12, (int)0);
        $this$createAccordionContent_u24lambda_u246.gridwidth = 2;
        Unit unit = Unit.INSTANCE;
        jPanel.add(component, gridBagConstraints);
        GridBagConstraints $this$createAccordionContent_u24lambda_u247 = serializable = new HyperlinkLabel();
        boolean bl2 = false;
        $this$createAccordionContent_u24lambda_u247.setHyperlinkText(UrlAssistantBundle.message("accordion.content.learn.more", new Object[0]));
        $this$createAccordionContent_u24lambda_u247.setHyperlinkTarget(referenceLink);
        GridBagConstraints hyperlinkLabel = serializable;
        $this$createAccordionContent_u24lambda_u247 = serializable = new GridBagConstraints();
        component = (Component)((Object)hyperlinkLabel);
        jPanel = res;
        boolean bl3 = false;
        $this$createAccordionContent_u24lambda_u248.gridy = 1;
        $this$createAccordionContent_u24lambda_u248.anchor = 17;
        unit = Unit.INSTANCE;
        jPanel.add(component, serializable);
        Serializable $this$createAccordionContent_u24lambda_u248 = serializable = new JPanel();
        jPanel = res;
        boolean bl4 = false;
        $this$createAccordionContent_u24lambda_u249.setBackground(backgroundColor);
        jPanel.add((Component)serializable, UiUtils.INSTANCE.createConstraintsForRow(1, 1));
        return res;
    }

    private final void validateAndPaint() {
        this.revalidate();
        this.repaint();
    }
}

