/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.datalayer.feature.listlinks;

import com.android.annotations.concurrency.WorkerThread;
import com.google.urlassistant.datalayer.db.sql.query.LinksQueryUtilsKt;
import com.google.urlassistant.datalayer.db.table.DisposableConnection;
import com.google.urlassistant.datalayer.feature.listlinks.LinkFilter;
import com.google.urlassistant.datalayer.feature.listlinks.LinkInfo;
import com.google.urlassistant.datalayer.feature.listlinks.ListLinksKt;
import com.google.urlassistant.datalayer.feature.listlinks.ListLinksRequest;
import com.google.urlassistant.datalayer.feature.listlinks.ListLinksResponse;
import com.google.urlassistant.datalayer.feature.listlinks.OrderBy;
import com.google.urlassistant.datalayer.feature.listlinks.OrderDirection;
import com.google.urlassistant.datalayer.feature.listlinks.SortableAttribute;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u001a\u0012\u0010\u0004\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0001\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0002\u001a&\u0010\u000e\u001a\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a(\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"createListLinksSqlQuery", "", "request", "Lcom/google/urlassistant/datalayer/feature/listlinks/ListLinksRequest;", "linkFilterToSqlWhereConditions", "filter", "Lcom/google/urlassistant/datalayer/feature/listlinks/LinkFilter;", "listLinks", "Lcom/google/urlassistant/datalayer/feature/listlinks/ListLinksResponse;", "conn", "Lcom/google/urlassistant/datalayer/db/table/DisposableConnection;", "orderByToSqlColumnAndDirection", "orderBy", "Lcom/google/urlassistant/datalayer/feature/listlinks/OrderBy;", "orderBysToSqlColumnsAndDirectionsWithFallbackOrder", "orderBys", "", "fallbackOrderColumn", "fallbackOrderDirection", "Lcom/google/urlassistant/datalayer/feature/listlinks/OrderDirection;", "searchKeyToSqlWhereCondition", "searchKey", "sortableAttributeToSqlJsonExtract", "sortableAttribute", "Lcom/google/urlassistant/datalayer/feature/listlinks/SortableAttribute;", "toComparison", "columnName", "jsonFieldName", "comparison", "compareTo", "", "url-assistant"})
public final class ListLinksKt {
    private static final String sortableAttributeToSqlJsonExtract(SortableAttribute sortableAttribute) {
        return "json_extract(" + (switch (WhenMappings.$EnumSwitchMapping$0[sortableAttribute.ordinal()]) {
            case 1 -> "single_link_data_tag_config, '$.scheme";
            case 2 -> "single_link_data_tag_config, '$.rawHost";
            case 3 -> "single_link_data_tag_config, '$.rawPath";
            case 4 -> "single_link_data_tag_config, '$.pathType";
            case 5 -> "single_link_data_tag_config, '$.port";
            case 6 -> "app_check_summary, '$.totalFailedIntentFilterChecks";
            case 7 -> "activity_config, '$.activityName";
            default -> throw new NoWhenBranchMatchedException();
        }) + "')";
    }

    private static final String orderByToSqlColumnAndDirection(OrderBy orderBy) {
        return ListLinksKt.sortableAttributeToSqlJsonExtract(orderBy.getColumn()) + " " + orderBy.getDirection().getSql();
    }

    private static final String orderBysToSqlColumnsAndDirectionsWithFallbackOrder(List<OrderBy> orderBys, String fallbackOrderColumn, OrderDirection fallbackOrderDirection) {
        String fallbackOrderSql = fallbackOrderColumn + " " + fallbackOrderDirection.getSql();
        String columnsAndDirectionsSql2 = orderBys.isEmpty() ? fallbackOrderSql : CollectionsKt.joinToString$default((Iterable)orderBys, (CharSequence)", ", null, null, (int)0, null, (Function1)orderBysToSqlColumnsAndDirectionsWithFallbackOrder.columnsAndDirectionsSql.1.INSTANCE, (int)30, null) + ", " + fallbackOrderSql;
        return columnsAndDirectionsSql2;
    }

    private static final String toComparison(String columnName, String jsonFieldName, String comparison, Object compareTo) {
        return "json_extract(" + columnName + ", '$." + jsonFieldName + "') " + comparison + " " + compareTo;
    }

    private static final String searchKeyToSqlWhereCondition(String searchKey) {
        String string;
        if (StringsKt.isBlank((CharSequence)searchKey)) {
            string = "";
        } else {
            Object[] objectArray = new String[]{ListLinksKt.sortableAttributeToSqlJsonExtract(SortableAttribute.SCHEME), ListLinksKt.sortableAttributeToSqlJsonExtract(SortableAttribute.HOST), ListLinksKt.sortableAttributeToSqlJsonExtract(SortableAttribute.RAW_PATH), "interpreted_url_pattern"};
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)" OR ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(searchKey){
                final /* synthetic */ String $searchKey;
                {
                    this.$searchKey = $searchKey;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it + " LIKE '%" + this.$searchKey + "%'";
                }
            }), (int)24, null);
        }
        return string;
    }

    private static final String linkFilterToSqlWhereConditions(LinkFilter filter) {
        String string;
        String string2;
        String string3;
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        if (filter == null) {
            return "";
        }
        String appCheckSummary = "app_check_summary";
        String totalFailedIntentFilterChecks = "totalFailedIntentFilterChecks";
        Object[] objectArray3 = objectArray2 = new String[2];
        int n2 = 0;
        Integer n3 = filter.getMaxAppIssues();
        if (n3 != null) {
            int n4 = ((Number)n3).intValue();
            n = n2;
            objectArray = objectArray3;
            boolean bl = false;
            string3 = ListLinksKt.toComparison(appCheckSummary, totalFailedIntentFilterChecks, "<=", filter.getMaxAppIssues());
            objectArray3 = objectArray;
            n2 = n;
            string2 = string3;
        } else {
            string2 = null;
        }
        objectArray3[n2] = string2;
        Object[] objectArray4 = objectArray2;
        int n5 = 1;
        Integer n6 = filter.getMinAppIssues();
        if (n6 != null) {
            int it = ((Number)n6).intValue();
            n = n5;
            objectArray = objectArray4;
            boolean bl = false;
            string3 = ListLinksKt.toComparison(appCheckSummary, totalFailedIntentFilterChecks, ">=", filter.getMinAppIssues());
            objectArray4 = objectArray;
            n5 = n;
            string = string3;
        } else {
            string = null;
        }
        objectArray4[n5] = string;
        String conditions = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2), (CharSequence)" AND ", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null);
        return conditions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public static final ListLinksResponse listLinks(@NotNull ListLinksRequest request, @NotNull DisposableConnection conn) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        AutoCloseable autoCloseable = conn.getConnection().createStatement();
        Throwable throwable = null;
        try {
            ListLinksResponse listLinksResponse;
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            ResultSet resultSet = it.executeQuery(ListLinksKt.createListLinksSqlQuery(request));
            AutoCloseable autoCloseable2 = resultSet;
            Throwable throwable2 = null;
            try {
                ResultSet it2 = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"resultSet");
                List<LinkInfo> links = LinksQueryUtilsKt.getLinkInfos(resultSet);
                listLinksResponse = new ListLinksResponse(links.size() < request.getPageSize() ? -1L : request.getPageOffset() + (long)request.getPageSize() + 1L, links, System.currentTimeMillis());
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            ListLinksResponse listLinksResponse2 = listLinksResponse;
            return listLinksResponse2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @VisibleForTesting
    @NotNull
    public static final String createListLinksSqlQuery(@NotNull ListLinksRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String searchCondition = ListLinksKt.searchKeyToSqlWhereCondition(request.getSearchKey());
        String filterCondition = ListLinksKt.linkFilterToSqlWhereConditions(request.getFilter());
        String whereConditions = !StringsKt.isBlank((CharSequence)searchCondition) && !StringsKt.isBlank((CharSequence)filterCondition) ? "(" + searchCondition + ") AND (" + filterCondition + ")" : searchCondition + filterCondition;
        return "\n  SELECT\n    links.interpreted_url_pattern,\n    links.single_link_data_tag_config,\n    links.link_type,\n    links.is_unique,\n    links.app_check_summary,\n    intent_filters.activity_config,\n    intent_filters.intent_filter_config,\n    intent_filters.manifest_file_location,\n    intent_filters.start_offset AS intent_filter_start_offset,\n    intent_filters.end_offset AS intent_filter_end_offset\n  FROM intent_filters INNER JOIN links ON\n   intent_filters.internal_intent_filter_id = links.internal_intent_filter_id\n  " + (String)(StringsKt.isBlank((CharSequence)whereConditions) ? "" : "WHERE " + whereConditions) + "\n  ORDER BY " + ListLinksKt.orderBysToSqlColumnsAndDirectionsWithFallbackOrder(request.getOrderBys(), "interpreted_url_pattern", OrderDirection.ASCEND) + "\n  LIMIT " + request.getPageSize() + "\n  OFFSET " + request.getPageOffset() + "\n  ";
    }

    public static final /* synthetic */ String access$orderByToSqlColumnAndDirection(OrderBy orderBy) {
        return ListLinksKt.orderByToSqlColumnAndDirection(orderBy);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SortableAttribute.values().length];
            try {
                nArray[SortableAttribute.SCHEME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortableAttribute.HOST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortableAttribute.RAW_PATH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortableAttribute.PATH_TYPE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortableAttribute.PORT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortableAttribute.INTENT_FILTER_ISSUES_COUNT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortableAttribute.ACTIVITY_NAME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

