/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.datalayer.db.table;

import com.google.urlassistant.datalayer.db.dao.LinkDao;
import com.google.urlassistant.datalayer.db.table.DisposableConnection;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001b\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Lcom/google/urlassistant/datalayer/db/table/LinksDatabaseConnection;", "Lcom/google/urlassistant/datalayer/db/table/DisposableConnection;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "dbFilePath", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/Disposable;Ljava/nio/file/Path;)V", "connection", "Ljava/sql/Connection;", "(Lcom/intellij/openapi/Disposable;Ljava/sql/Connection;)V", "clearTables", "", "insertLink", "link", "Lcom/google/urlassistant/datalayer/db/dao/LinkDao;", "linkTableName", "", "Companion", "url-assistant"})
public final class LinksDatabaseConnection
extends DisposableConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Path dbPath;
    public static final int LINKS_DATABASE_VERSION = 0;
    @NotNull
    private static final String createIfNotExistsVersionTableSql = "CREATE TABLE IF NOT EXISTS links_version (version_num INT)";
    @NotNull
    private static final String queryVersionSql = "SELECT * FROM links_version";
    @NotNull
    private static final String insertVersionNumberSql = "\n      INSERT INTO links_version (version_num)\n      VALUES (0)\n      ";
    @NotNull
    private static final String clearVersionSql = "DELETE FROM links_version";
    @NotNull
    private static final String clearLinksSql = "DELETE FROM links";
    @NotNull
    private static final String createIfNotExistsLinksTableSql;
    @NotNull
    public static final String createIfNotExistsDataTagIndex = "\n      CREATE INDEX IF NOT EXISTS data_tag_idx ON\n        links(json_extract(single_link_data_tag_config, '$.scheme', '$.rawHost', '$.rawPath'))\n      ";
    @NotNull
    public static final String createIfNotExistsFailedIntentFilterChecksIndex = "\n      CREATE INDEX IF NOT EXISTS failed_intent_filter_checks ON\n        links(json_extract(app_check_summary, '$.totalFailedIntentFilterChecks'))\n      ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinksDatabaseConnection(@NotNull Disposable parentDisposable, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super(parentDisposable, connection);
        this.executeAndCloseStatement(createIfNotExistsVersionTableSql);
        AutoCloseable autoCloseable = connection.createStatement();
        Object[] objectArray = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            ResultSet resultSet = it.executeQuery(queryVersionSql);
            if (resultSet.next()) {
                String string = resultSet.getString("version_num");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultSet.getString(\"version_num\")");
                int dbVersion = Integer.parseInt(string);
                if (dbVersion != 0) {
                    this.clearTables();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable object) {
            objectArray = object;
            throw object;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)objectArray);
        }
        objectArray = new String[]{createIfNotExistsLinksTableSql, createIfNotExistsDataTagIndex, createIfNotExistsFailedIntentFilterChecksIndex};
        for (String statement : CollectionsKt.listOf((Object[])objectArray)) {
            this.executeAndCloseStatement(statement);
        }
    }

    @JvmOverloads
    public LinksDatabaseConnection(@NotNull Disposable parentDisposable, @Nullable Path dbFilePath) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this(parentDisposable, DisposableConnection.createConnection(dbFilePath));
    }

    public /* synthetic */ LinksDatabaseConnection(Disposable disposable, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = null;
        }
        this(disposable, path);
    }

    private final void clearTables() {
        Object[] objectArray = new String[]{clearVersionSql, clearLinksSql};
        for (String statement : CollectionsKt.listOf((Object[])objectArray)) {
            this.executeAndCloseStatement(statement);
        }
        this.executeAndCloseStatement(insertVersionNumberSql);
    }

    public final void insertLink(@NotNull LinkDao link, @NotNull String linkTableName) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)linkTableName, (String)"linkTableName");
        this.executeAndCloseStatement("\n      INSERT INTO " + linkTableName + " (\n        interpreted_url_pattern,\n        single_link_data_tag_config,\n        link_type,\n        is_unique,\n        app_check_summary,\n        internal_intent_filter_id\n      )\n      VALUES (\n        '" + link.getInterpretedUrlPattern() + "',\n        '" + link.getSingleLinkDataTagConfig().toJson() + "',\n        '" + link.getLinkType().toJson() + "',\n        " + link.isUnique() + ",\n        '" + (link.getAppCheckSummary() != null ? link.getAppCheckSummary().toJson() : null) + "',\n        " + link.getInternalIntentFilterId() + "\n      )\n      ");
    }

    public static /* synthetic */ void insertLink$default(LinksDatabaseConnection linksDatabaseConnection, LinkDao linkDao, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "links";
        }
        linksDatabaseConnection.insertLink(linkDao, string);
    }

    @JvmOverloads
    public LinksDatabaseConnection(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this(parentDisposable, null, 2, null);
    }

    static {
        String[] stringArray = new String[]{".android", "app_links_assistant.sql"};
        Path path = Paths.get(PathManager.getSystemPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(PathManager.getSyste\u2026app_links_assistant.sql\")");
        dbPath = path;
        createIfNotExistsLinksTableSql = Companion.generateSqlCreateIfNotExistsTable("links");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/google/urlassistant/datalayer/db/table/LinksDatabaseConnection$Companion;", "", "()V", "LINKS_DATABASE_VERSION", "", "clearLinksSql", "", "clearVersionSql", "createIfNotExistsDataTagIndex", "createIfNotExistsFailedIntentFilterChecksIndex", "createIfNotExistsLinksTableSql", "getCreateIfNotExistsLinksTableSql", "()Ljava/lang/String;", "createIfNotExistsVersionTableSql", "dbPath", "Ljava/nio/file/Path;", "getDbPath", "()Ljava/nio/file/Path;", "insertVersionNumberSql", "queryVersionSql", "generateSqlCreateIfNotExistsTable", "tableName", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path getDbPath() {
            return dbPath;
        }

        @NotNull
        public final String generateSqlCreateIfNotExistsTable(@NotNull String tableName) {
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            return "\n      CREATE TABLE IF NOT EXISTS " + tableName + " (\n        internal_link_id INTEGER PRIMARY KEY,\n        interpreted_url_pattern TEXT,\n        single_link_data_tag_config JSON,\n        link_type TEXT,\n        is_unique JSON,\n        app_check_summary JSON,\n        internal_intent_filter_id REFERENCES intent_filters(internal_intent_filter_id)\n      )\n      ";
        }

        @NotNull
        public final String getCreateIfNotExistsLinksTableSql() {
            return createIfNotExistsLinksTableSql;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

