/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.datalayer.db.table;

import com.google.urlassistant.datalayer.db.dao.IntentFilterDao;
import com.google.urlassistant.datalayer.db.table.DisposableConnection;
import com.google.urlassistant.datalayer.db.table.LinksDatabaseConnection;
import com.intellij.openapi.Disposable;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001b\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Lcom/google/urlassistant/datalayer/db/table/IntentFilterDatabaseConnection;", "Lcom/google/urlassistant/datalayer/db/table/DisposableConnection;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "dbFilePath", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/Disposable;Ljava/nio/file/Path;)V", "connection", "Ljava/sql/Connection;", "(Lcom/intellij/openapi/Disposable;Ljava/sql/Connection;)V", "clearTables", "", "insertIntentFilter", "intentFilter", "Lcom/google/urlassistant/datalayer/db/dao/IntentFilterDao;", "tableName", "", "Companion", "url-assistant"})
public final class IntentFilterDatabaseConnection
extends DisposableConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int INTENT_FILTERS_DATABASE_VERSION = 0;
    @NotNull
    private static final String INTENT_FILTERS_VERSION_TABLE_NAME = "intent_filters_version";
    @NotNull
    public static final String INTENT_FILTERS_TABLE_NAME = "intent_filters";
    @NotNull
    private static final String createIfNotExistsVersionTableSql = "CREATE TABLE IF NOT EXISTS intent_filters_version (version_num INT)";
    @NotNull
    private static final String queryVersionSql = "SELECT * FROM intent_filters_version";
    @NotNull
    private static final String insertVersionNumberSql = "\n      INSERT INTO intent_filters_version (version_num)\n      VALUES (0)\n      ";
    @NotNull
    private static final String clearVersionSql = "DELETE FROM intent_filters_version";
    @NotNull
    private static final String clearIntentFiltersSql = "DELETE FROM intent_filters";
    @NotNull
    private static final String createIfNotExistsIntentFilterTableSql = Companion.generateSqlCreateIfNotExistsTable("intent_filters");
    @NotNull
    public static final String createIfNotExistsLocationIndexSql = "CREATE UNIQUE INDEX IF NOT EXISTS location ON intent_filters (start_offset, end_offset, manifest_file_location)";
    @NotNull
    public static final String createIfNotExistsActivityNameIndexSql = "CREATE INDEX IF NOT EXISTS activity_name ON intent_filters(json_extract(activity_config, '$.activityName'))";
    private static boolean cancelIntentFilterRefresh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntentFilterDatabaseConnection(@NotNull Disposable parentDisposable, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super(parentDisposable, connection);
        this.executeAndCloseStatement(createIfNotExistsVersionTableSql);
        AutoCloseable autoCloseable = connection.createStatement();
        Object[] objectArray = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            ResultSet resultSet = it.executeQuery(queryVersionSql);
            if (resultSet.next()) {
                String string = resultSet.getString("version_num");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultSet.getString(\"version_num\")");
                int dbVersion = Integer.parseInt(string);
                if (dbVersion != 0) {
                    this.clearTables();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable object) {
            objectArray = object;
            throw object;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)objectArray);
        }
        this.executeAndCloseStatement(createIfNotExistsIntentFilterTableSql);
        objectArray = new String[]{createIfNotExistsLocationIndexSql, createIfNotExistsActivityNameIndexSql};
        for (String statement : CollectionsKt.listOf((Object[])objectArray)) {
            this.executeAndCloseStatement(statement);
        }
    }

    @JvmOverloads
    public IntentFilterDatabaseConnection(@NotNull Disposable parentDisposable, @Nullable Path dbFilePath) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this(parentDisposable, DisposableConnection.createConnection(dbFilePath));
    }

    public /* synthetic */ IntentFilterDatabaseConnection(Disposable disposable, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = LinksDatabaseConnection.Companion.getDbPath();
        }
        this(disposable, path);
    }

    private final void clearTables() {
        Object[] objectArray = new String[]{clearVersionSql, clearIntentFiltersSql};
        for (String statement : CollectionsKt.listOf((Object[])objectArray)) {
            this.executeAndCloseStatement(statement);
        }
        this.executeAndCloseStatement(insertVersionNumberSql);
    }

    public final void insertIntentFilter(@NotNull IntentFilterDao intentFilter, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)intentFilter, (String)"intentFilter");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        this.executeAndCloseStatement("\n      INSERT INTO " + tableName + "\n      (\n        start_offset,\n        end_offset,\n        activity_config,\n        intent_filter_config,\n        data_tags_config,\n        manifest_file_location\n      )\n      VALUES(\n        " + (intentFilter.getStartOffset() == -1 ? null : Integer.valueOf(intentFilter.getStartOffset())) + ",\n        " + (intentFilter.getEndOffset() == -1 ? null : Integer.valueOf(intentFilter.getEndOffset())) + ",\n        '" + intentFilter.getActivityConfig().toJson() + "',\n        '" + intentFilter.getIntentFilterConfig().toJson() + "',\n        '" + intentFilter.getDataTagsConfig().toJson() + "',\n        '" + intentFilter.getManifestFileLocation() + "'\n      )\n      ");
    }

    public static /* synthetic */ void insertIntentFilter$default(IntentFilterDatabaseConnection intentFilterDatabaseConnection, IntentFilterDao intentFilterDao, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = INTENT_FILTERS_TABLE_NAME;
        }
        intentFilterDatabaseConnection.insertIntentFilter(intentFilterDao, string);
    }

    @JvmOverloads
    public IntentFilterDatabaseConnection(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this(parentDisposable, null, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/google/urlassistant/datalayer/db/table/IntentFilterDatabaseConnection$Companion;", "", "()V", "INTENT_FILTERS_DATABASE_VERSION", "", "INTENT_FILTERS_TABLE_NAME", "", "INTENT_FILTERS_VERSION_TABLE_NAME", "cancelIntentFilterRefresh", "", "getCancelIntentFilterRefresh", "()Z", "setCancelIntentFilterRefresh", "(Z)V", "clearIntentFiltersSql", "clearVersionSql", "createIfNotExistsActivityNameIndexSql", "createIfNotExistsIntentFilterTableSql", "getCreateIfNotExistsIntentFilterTableSql", "()Ljava/lang/String;", "createIfNotExistsLocationIndexSql", "createIfNotExistsVersionTableSql", "insertVersionNumberSql", "queryVersionSql", "generateSqlCreateIfNotExistsTable", "tableName", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String generateSqlCreateIfNotExistsTable(@NotNull String tableName) {
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            return "\n      CREATE TABLE IF NOT EXISTS " + tableName + " (\n        internal_intent_filter_id INTEGER PRIMARY KEY,\n        start_offset INT,\n        end_offset INT,\n        activity_config JSON,\n        intent_filter_config JSON,\n        data_tags_config JSON,\n        manifest_file_location STRING\n      )\n      ";
        }

        @NotNull
        public final String getCreateIfNotExistsIntentFilterTableSql() {
            return createIfNotExistsIntentFilterTableSql;
        }

        public final boolean getCancelIntentFilterRefresh() {
            return cancelIntentFilterRefresh;
        }

        public final void setCancelIntentFilterRefresh(boolean bl) {
            cancelIntentFilterRefresh = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

