/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.datalayer.db.table;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0010\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/google/urlassistant/datalayer/db/table/DisposableConnection;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "dbFilePath", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/Disposable;Ljava/nio/file/Path;)V", "connection", "Ljava/sql/Connection;", "(Lcom/intellij/openapi/Disposable;Ljava/sql/Connection;)V", "getConnection", "()Ljava/sql/Connection;", "databaseNames", "", "", "attachDatabase", "", "name", "filePath", "dispose", "executeAndCloseStatement", "sqlString", "Companion", "url-assistant"})
public class DisposableConnection
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Connection connection;
    @NotNull
    private final Set<String> databaseNames;

    public DisposableConnection(@NotNull Disposable parentDisposable, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
        Object[] objectArray = new String[]{"main"};
        this.databaseNames = SetsKt.mutableSetOf((Object[])objectArray);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @NotNull
    public final Connection getConnection() {
        return this.connection;
    }

    @JvmOverloads
    public DisposableConnection(@NotNull Disposable parentDisposable, @Nullable Path dbFilePath) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this(parentDisposable, DisposableConnection.createConnection(dbFilePath));
    }

    public /* synthetic */ DisposableConnection(Disposable disposable, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = null;
        }
        this(disposable, path);
    }

    public void dispose() {
        this.connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeAndCloseStatement(@NotNull String sqlString) {
        Intrinsics.checkNotNullParameter((Object)sqlString, (String)"sqlString");
        AutoCloseable autoCloseable = this.connection.createStatement();
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            boolean bl2 = it.execute(sqlString);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void attachDatabase(@NotNull String name, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.databaseNames.contains(filePath)) {
            return;
        }
        this.executeAndCloseStatement("ATTACH DATABASE '" + filePath + "' AS " + name);
    }

    @JvmOverloads
    public DisposableConnection(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this(parentDisposable, null, 2, null);
    }

    @JvmStatic
    @NotNull
    protected static final Connection createConnection(@Nullable Path dbFilePath) {
        return Companion.createConnection(dbFilePath);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0005\u00a8\u0006\u0007"}, d2={"Lcom/google/urlassistant/datalayer/db/table/DisposableConnection$Companion;", "", "()V", "createConnection", "Ljava/sql/Connection;", "dbFilePath", "Ljava/nio/file/Path;", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        protected final Connection createConnection(@Nullable Path dbFilePath) {
            Path path = dbFilePath;
            Comparable dbFileName = path != null ? (Comparable)path : (Comparable)((Object)":memory:");
            try {
                String url = "jdbc:sqlite:" + dbFileName;
                Connection connection = DriverManager.getConnection(url);
                Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(url)");
                return connection;
            }
            catch (SQLException e) {
                throw new SQLException("Error while opening Sqlite database file '" + dbFileName + "'", e);
            }
        }

        public static /* synthetic */ Connection createConnection$default(Companion companion, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                path = null;
            }
            return DisposableConnection.createConnection(path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

