/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.datalayer.db.sql.update;

import com.android.annotations.concurrency.WorkerThread;
import com.google.urlassistant.datalayer.db.dao.IntentFilterDao;
import com.google.urlassistant.datalayer.db.dao.LinkDao;
import com.google.urlassistant.datalayer.db.sql.query.IntentFiltersQueryUtilsKt;
import com.google.urlassistant.datalayer.db.sql.query.LinksQueryUtilsKt;
import com.google.urlassistant.datalayer.db.table.LinksDatabaseConnection;
import com.google.urlassistant.datalayer.model.LinkType;
import com.google.urlassistant.datalayer.model.intentfilter.DataTagsConfig;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.AppCheckSummary;
import com.google.urlassistant.datalayer.model.validation.singlelinkdatatagconfig.PathType;
import com.google.urlassistant.datalayer.model.validation.singlelinkdatatagconfig.SingleLinkDataTagConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"LINKS_NEW_TABLE_NAME", "", "createIfNotExistsLinksNewTableSql", "dropLinksTableSql", "renameLinksNewTableSql", "buildLinkDao", "Lcom/google/urlassistant/datalayer/db/dao/LinkDao;", "singleLinkDataTagConfig", "Lcom/google/urlassistant/datalayer/model/validation/singlelinkdatatagconfig/SingleLinkDataTagConfig;", "interpretedUrlPattern", "intentFilterId", "", "createInterpretedUrlPattern", "enumerateAndInsertLinks", "", "intentFilterDao", "Lcom/google/urlassistant/datalayer/db/dao/IntentFilterDao;", "connection", "Lcom/google/urlassistant/datalayer/db/table/LinksDatabaseConnection;", "linkTableName", "refreshLinksTable", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nLinksPopulator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinksPopulator.kt\ncom/google/urlassistant/datalayer/db/sql/update/LinksPopulatorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1#2:150\n1549#3:151\n1620#3,3:152\n1549#3:155\n1620#3,3:156\n1549#3:159\n1620#3,3:160\n1851#3,2:163\n*S KotlinDebug\n*F\n+ 1 LinksPopulator.kt\ncom/google/urlassistant/datalayer/db/sql/update/LinksPopulatorKt\n*L\n113#1:151\n113#1:152,3\n114#1:155\n114#1:156,3\n115#1:159\n115#1:160,3\n115#1:163,2\n*E\n"})
public final class LinksPopulatorKt {
    @NotNull
    private static final String LINKS_NEW_TABLE_NAME = "links_new";
    @NotNull
    private static final String createIfNotExistsLinksNewTableSql = LinksDatabaseConnection.Companion.generateSqlCreateIfNotExistsTable("links_new");
    @NotNull
    private static final String dropLinksTableSql = "DROP TABLE links";
    @NotNull
    private static final String renameLinksNewTableSql = "ALTER TABLE links_new RENAME TO links";

    private static final LinkDao buildLinkDao(SingleLinkDataTagConfig singleLinkDataTagConfig, String interpretedUrlPattern, int intentFilterId) {
        return new LinkDao(interpretedUrlPattern, singleLinkDataTagConfig, Intrinsics.areEqual((Object)singleLinkDataTagConfig.getScheme(), (Object)"https") || Intrinsics.areEqual((Object)singleLinkDataTagConfig.getScheme(), (Object)"http") ? LinkType.APP_LINK : LinkType.CUSTOM_SCHEME, true, new AppCheckSummary(0, 0, CollectionsKt.emptyList(), 0, 0, CollectionsKt.emptyList()), intentFilterId);
    }

    private static final String createInterpretedUrlPattern(SingleLinkDataTagConfig singleLinkDataTagConfig) {
        if (singleLinkDataTagConfig.getScheme() == null) {
            return "";
        }
        if (singleLinkDataTagConfig.getRawHost() == null) {
            return singleLinkDataTagConfig.getScheme() + ":";
        }
        String path = switch (WhenMappings.$EnumSwitchMapping$0[singleLinkDataTagConfig.getPathType().ordinal()]) {
            case 1 -> singleLinkDataTagConfig.getRawPath();
            case 2 -> {
                if (((CharSequence)singleLinkDataTagConfig.getRawPath()).length() == 0) {
                    yield "/.*";
                }
                if (StringsKt.startsWith$default((String)singleLinkDataTagConfig.getRawPath(), (String)"/", (boolean)false, (int)2, null)) {
                    yield singleLinkDataTagConfig.getRawPath() + ".*";
                }
                yield "/" + singleLinkDataTagConfig.getRawPath() + ".*";
            }
            case 3 -> {
                String var2_1 = singleLinkDataTagConfig.getRawPath();
                if (Intrinsics.areEqual((Object)var2_1, (Object)".*")) {
                    yield "/.*";
                }
                if (Intrinsics.areEqual((Object)var2_1, (Object)".")) {
                    yield "/";
                }
                yield singleLinkDataTagConfig.getRawPath();
            }
            case 4 -> "/.*";
            default -> throw new NoWhenBranchMatchedException();
        };
        if (singleLinkDataTagConfig.getPort() == null) {
            return singleLinkDataTagConfig.getScheme() + "://" + singleLinkDataTagConfig.getRawHost() + path;
        }
        return singleLinkDataTagConfig.getScheme() + "://" + singleLinkDataTagConfig.getRawHost() + ":" + singleLinkDataTagConfig.getPort() + path;
    }

    private static final void enumerateAndInsertLinks(IntentFilterDao intentFilterDao, LinksDatabaseConnection connection, String linkTableName) {
        Collection collection;
        LinkDao linkDao = null;
        DataTagsConfig dataTags = intentFilterDao.getDataTagsConfig();
        Collection collection2 = dataTags.getSchemes();
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = CollectionsKt.listOf(null);
        } else {
            collection = collection2;
        }
        for (String scheme : (List)collection) {
            Collection collection3;
            Collection collection4 = dataTags.getHosts();
            if (collection4.isEmpty()) {
                boolean bl = false;
                collection3 = CollectionsKt.listOf(null);
            } else {
                collection3 = collection4;
            }
            for (String host : (List)collection3) {
                Collection collection5;
                Collection collection6 = dataTags.getPorts();
                if (collection6.isEmpty()) {
                    boolean bl = false;
                    collection5 = CollectionsKt.listOf(null);
                } else {
                    collection5 = collection6;
                }
                for (Integer port : (List)collection5) {
                    Collection collection7;
                    Collection collection8 = dataTags.getMimeTypes();
                    if (collection8.isEmpty()) {
                        boolean bl = false;
                        collection7 = CollectionsKt.listOf(null);
                    } else {
                        collection7 = collection8;
                    }
                    for (String mimeType : (List)collection7) {
                        String p;
                        Collection<Pair> collection9;
                        Iterable $this$mapTo$iv$iv;
                        Iterable $this$map$iv;
                        Object[] bl = new List[3];
                        Iterable iterable = dataTags.getPaths().getExact();
                        int n = 0;
                        Object[] objectArray = bl;
                        boolean $i$f$map = false;
                        void var16_22 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            String string = (String)item$iv$iv;
                            collection9 = destination$iv$iv;
                            boolean bl2 = false;
                            collection9.add(new Pair((Object)p, (Object)PathType.EXACT));
                        }
                        collection9 = (List)destination$iv$iv;
                        objectArray[n] = collection9;
                        $this$map$iv = dataTags.getPaths().getPrefix();
                        n = 1;
                        objectArray = bl;
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            p = (String)item$iv$iv;
                            collection9 = destination$iv$iv;
                            boolean bl3 = false;
                            collection9.add(new Pair((Object)p, (Object)PathType.PREFIX));
                        }
                        collection9 = (List)destination$iv$iv;
                        objectArray[n] = collection9;
                        $this$map$iv = dataTags.getPaths().getPattern();
                        n = 2;
                        objectArray = bl;
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            p = (String)item$iv$iv;
                            collection9 = destination$iv$iv;
                            boolean bl4 = false;
                            collection9.add(new Pair((Object)p, (Object)PathType.PATTERN));
                        }
                        collection9 = (List)destination$iv$iv;
                        objectArray[n] = collection9;
                        Iterable $this$forEach$iv = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])bl));
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Pair it = (Pair)element$iv;
                            boolean bl5 = false;
                            SingleLinkDataTagConfig singleLinkDataTagConfig = new SingleLinkDataTagConfig(scheme, host, (String)it.getFirst(), (PathType)((Object)it.getSecond()), port, mimeType);
                            String interpretedUrlPattern = LinksPopulatorKt.createInterpretedUrlPattern(singleLinkDataTagConfig);
                            Integer n2 = intentFilterDao.getIntentFilterId();
                            Intrinsics.checkNotNull((Object)n2);
                            linkDao = LinksPopulatorKt.buildLinkDao(singleLinkDataTagConfig, interpretedUrlPattern, n2);
                            connection.insertLink(linkDao, linkTableName);
                        }
                    }
                }
            }
        }
    }

    @WorkerThread
    public static final void refreshLinksTable(@NotNull LinksDatabaseConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        connection.executeAndCloseStatement(createIfNotExistsLinksNewTableSql);
        List<IntentFilterDao> intentFilters = IntentFiltersQueryUtilsKt.getAllIntentFilters(connection);
        for (IntentFilterDao intentFilterDao : intentFilters) {
            LinksPopulatorKt.enumerateAndInsertLinks(intentFilterDao, connection, LINKS_NEW_TABLE_NAME);
        }
        LinksQueryUtilsKt.updateIsUniqueField(connection.getConnection());
        Object[] objectArray = new String[]{dropLinksTableSql, renameLinksNewTableSql, "\n      CREATE INDEX IF NOT EXISTS data_tag_idx ON\n        links(json_extract(single_link_data_tag_config, '$.scheme', '$.rawHost', '$.rawPath'))\n      ", "\n      CREATE INDEX IF NOT EXISTS failed_intent_filter_checks ON\n        links(json_extract(app_check_summary, '$.totalFailedIntentFilterChecks'))\n      "};
        for (String string : CollectionsKt.listOf((Object[])objectArray)) {
            connection.executeAndCloseStatement(string);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathType.values().length];
            try {
                nArray[PathType.EXACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.PREFIX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.PATTERN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.EMPTY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

