/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.datalayer.db.sql.query;

import com.google.urlassistant.datalayer.db.dao.LinkDao;
import com.google.urlassistant.datalayer.db.table.DisposableConnection;
import com.google.urlassistant.datalayer.feature.listlinks.LinkInfo;
import com.google.urlassistant.datalayer.model.LinkType;
import com.google.urlassistant.datalayer.model.intentfilter.ActivityConfig;
import com.google.urlassistant.datalayer.model.intentfilter.IntentFilterConfig;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.AppCheckSummary;
import com.google.urlassistant.datalayer.model.validation.singlelinkdatatagconfig.SingleLinkDataTagConfig;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u00a8\u0006\u0015"}, d2={"getAllLinks", "", "Lcom/google/urlassistant/datalayer/db/dao/LinkDao;", "connection", "Lcom/google/urlassistant/datalayer/db/table/DisposableConnection;", "Ljava/sql/Connection;", "getLinkInfos", "Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;", "resultSet", "Ljava/sql/ResultSet;", "getLinksAndClose", "getLinksByFailedIntentFilterChecks", "failedIntentFilterChecks", "", "getLinksBySchemeRawHostRawPath", "scheme", "", "rawHost", "rawPath", "updateIsUniqueField", "", "url-assistant"})
public final class LinksQueryUtilsKt {
    @NotNull
    public static final List<LinkDao> getLinksAndClose(@NotNull ResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        List res = new ArrayList();
        while (resultSet.next()) {
            String interpretedUrlPattern = resultSet.getString("interpreted_url_pattern");
            String string = resultSet.getString("single_link_data_tag_config");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultSet.getString(\"single_link_data_tag_config\")");
            SingleLinkDataTagConfig singleLinkDataTagConfig = SingleLinkDataTagConfig.Companion.fromJson(string);
            String string2 = resultSet.getString("link_type");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resultSet.getString(\"link_type\")");
            LinkType linkType = LinkType.Companion.fromJson(string2);
            boolean isUnique = resultSet.getBoolean("is_unique");
            String string3 = resultSet.getString("app_check_summary");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resultSet.getString(\"app_check_summary\")");
            AppCheckSummary appCheckSummary = AppCheckSummary.Companion.fromJson(string3);
            String string4 = resultSet.getString("internal_intent_filter_id");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"resultSet.getString(\"internal_intent_filter_id\")");
            int internalIntentFilterId = Integer.parseInt(string4);
            Intrinsics.checkNotNullExpressionValue((Object)interpretedUrlPattern, (String)"interpretedUrlPattern");
            res.add(new LinkDao(interpretedUrlPattern, singleLinkDataTagConfig, linkType, isUnique, appCheckSummary, internalIntentFilterId));
        }
        resultSet.close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<LinkDao> getAllLinks(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            ResultSet resultSet = it.executeQuery("SELECT * FROM links");
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"it.executeQuery(\"SELECT * FROM links\")");
            List<LinkDao> list = LinksQueryUtilsKt.getLinksAndClose(resultSet);
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final List<LinkDao> getAllLinks(@NotNull DisposableConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        return LinksQueryUtilsKt.getAllLinks(connection.getConnection());
    }

    @NotNull
    public static final List<LinkInfo> getLinkInfos(@NotNull ResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        List res = new ArrayList();
        while (resultSet.next()) {
            String interpretedUrlPattern = resultSet.getString("interpreted_url_pattern");
            String string = resultSet.getString("single_link_data_tag_config");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultSet.getString(\"single_link_data_tag_config\")");
            SingleLinkDataTagConfig singleLinkDataTagConfig = SingleLinkDataTagConfig.Companion.fromJson(string);
            String string2 = resultSet.getString("link_type");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resultSet.getString(\"link_type\")");
            LinkType linkType = LinkType.Companion.fromJson(string2);
            boolean isUnique = resultSet.getBoolean("is_unique");
            String string3 = resultSet.getString("app_check_summary");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resultSet.getString(\"app_check_summary\")");
            AppCheckSummary appCheckSummary = AppCheckSummary.Companion.fromJson(string3);
            String string4 = resultSet.getString("activity_config");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"resultSet.getString(\"activity_config\")");
            ActivityConfig activityConfig = ActivityConfig.Companion.fromJson(string4);
            String string5 = resultSet.getString("intent_filter_config");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"resultSet.getString(\"intent_filter_config\")");
            IntentFilterConfig intentFilterConfig = IntentFilterConfig.Companion.fromJson(string5);
            String manifestFileLocation = resultSet.getString("manifest_file_location");
            String string6 = resultSet.getString("intent_filter_start_offset");
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"resultSet.getString(\"intent_filter_start_offset\")");
            long intentFilterStartOffset = Long.parseLong(string6);
            String string7 = resultSet.getString("intent_filter_end_offset");
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"resultSet.getString(\"intent_filter_end_offset\")");
            long intentFilterEndOffset = Long.parseLong(string7);
            Intrinsics.checkNotNullExpressionValue((Object)interpretedUrlPattern, (String)"interpretedUrlPattern");
            Intrinsics.checkNotNullExpressionValue((Object)manifestFileLocation, (String)"manifestFileLocation");
            res.add(new LinkInfo(interpretedUrlPattern, singleLinkDataTagConfig, linkType, isUnique, appCheckSummary, activityConfig, intentFilterConfig, manifestFileLocation, intentFilterStartOffset, intentFilterEndOffset));
        }
        resultSet.close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<LinkDao> getLinksBySchemeRawHostRawPath(@NotNull String scheme, @NotNull String rawHost, @NotNull String rawPath, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)rawHost, (String)"rawHost");
        Intrinsics.checkNotNullParameter((Object)rawPath, (String)"rawPath");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            ResultSet resultSet = it.executeQuery("\n          SELECT * FROM links WHERE\n            json_extract(single_link_data_tag_config,'$.scheme','$.rawHost','$.rawPath') = '[\"" + scheme + "\",\"" + rawHost + "\",\"" + rawPath + "\"]'\n          ");
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"it.executeQuery(\n       \u2026\"]'\n          \"\"\"\n      )");
            List<LinkDao> list = LinksQueryUtilsKt.getLinksAndClose(resultSet);
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final List<LinkDao> getLinksBySchemeRawHostRawPath(@NotNull String scheme, @NotNull String rawHost, @NotNull String rawPath, @NotNull DisposableConnection connection) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)rawHost, (String)"rawHost");
        Intrinsics.checkNotNullParameter((Object)rawPath, (String)"rawPath");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        return LinksQueryUtilsKt.getLinksBySchemeRawHostRawPath(scheme, rawHost, rawPath, connection.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<LinkDao> getLinksByFailedIntentFilterChecks(int failedIntentFilterChecks, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            ResultSet resultSet = it.executeQuery("\n          SELECT * FROM links WHERE\n            json_extract(app_check_summary, '$.totalFailedIntentFilterChecks') = " + failedIntentFilterChecks + "\n          ");
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"it.executeQuery(\n       \u2026cks\n          \"\"\"\n      )");
            List<LinkDao> list = LinksQueryUtilsKt.getLinksAndClose(resultSet);
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final List<LinkDao> getLinksByFailedIntentFilterChecks(int failedIntentFilterChecks, @NotNull DisposableConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        return LinksQueryUtilsKt.getLinksByFailedIntentFilterChecks(failedIntentFilterChecks, connection.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void updateIsUniqueField(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            boolean bl2 = it.execute("\n      UPDATE Links\n      SET is_unique = FALSE\n      WHERE interpreted_url_pattern IN (\n      SELECT interpreted_url_pattern\n        FROM Links\n        GROUP BY interpreted_url_pattern\n        HAVING COUNT(interpreted_url_pattern) > 1 )\n    ");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }
}

